/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.offline.write;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineException;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineHelper;
import crazydev.iccube.builder.offline.write.OlapBuilderOfflineWriteRowReader;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderOfflineWriteHelper {
    private final OlapBuilderContext owner;
    private final IOlapEngineLoadSchemaParams params;
    private final Map<IOlapBuilderDataTableDef, Map<IOlapBuilderTablePartitionKey, Integer>> partitionIndices = new HashMap<IOlapBuilderDataTableDef, Map<IOlapBuilderTablePartitionKey, Integer>>();
    @Nullable
    private File directory;

    public OlapBuilderOfflineWriteHelper(OlapBuilderContext owner, IOlapEngineLoadSchemaParams params) {
        this.owner = owner;
        this.params = params;
    }

    public void onBuildStarted() {
        File directory;
        OlapEngineComponent olapEngine = this.owner.getEngineContext().getOlapEngineComponent();
        String specifiedSnapshot = this.params.getOfflineSnapshot();
        OlapRuntimeContext rContext = this.owner.getRequestContext().asRuntimeContext();
        CdVFileSystem vfs = rContext.getVfs();
        if (vfs.exists(directory = olapEngine.getOfflineSnapshotForWrite(rContext, specifiedSnapshot, this.owner.getSchema()))) {
            OlapLoggers.BUILDER.error((Object)("[offline] (write) existing file : " + directory.getAbsolutePath()));
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_WRITE_EXISTING_SCHEMA_ZIP_FILE, new Serializable[]{directory.getAbsolutePath()});
        }
        if (!vfs.mkdir(directory)) {
            OlapLoggers.BUILDER.error((Object)("[offline] (write) could not create the directory : " + directory.getAbsolutePath()));
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_WRITE_CANNOT_CREATE_SCHEMA_ZIP_FILE, new Serializable[]{directory.getAbsolutePath()});
        }
        this.directory = directory;
        try {
            File version = new File(directory, "version.txt");
            if (!version.createNewFile()) {
                OlapLoggers.BUILDER.error((Object)("[offline] (write) could not create the version file : " + directory.getAbsolutePath()));
                throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_WRITE_CANNOT_CREATE_SCHEMA_ZIP_FILE_VERSION, new Serializable[]{directory.getAbsolutePath(), "n/a"});
            }
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)("[offline] (write) could not create the version file : " + directory.getAbsolutePath()), (Throwable)ex);
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_WRITE_CANNOT_CREATE_SCHEMA_ZIP_FILE_VERSION, new Serializable[]{directory.getAbsolutePath(), ex.getMessage()});
        }
    }

    public IOlapBuilderTableRowReader decorateRowReader(IOlapBuilderTableRowReader reader) {
        if (this.directory == null) {
            throw new RuntimeException("internal error : missing offline directory");
        }
        int partitionIdx = -1;
        IOlapBuilderTablePartitionKey partitionKey = reader.getPartitionKey();
        if (partitionKey != null) {
            IOlapBuilderDataTableDef table = reader.getTable();
            Map<IOlapBuilderTablePartitionKey, Integer> indices = this.partitionIndices.get(table);
            if (indices == null) {
                throw new RuntimeException("internal error : missing partition-index for table [" + table.getName() + "]");
            }
            Integer idx = indices.get(partitionKey);
            if (idx == null) {
                throw new RuntimeException("internal error : missing partition index for table [" + table.getName() + "] and key [" + partitionKey.getName() + "]");
            }
            partitionIdx = idx;
        }
        OlapBuilderOfflineWriteRowReader offlineReader = new OlapBuilderOfflineWriteRowReader(this.owner, this.directory, this.params, reader, partitionIdx);
        return offlineReader;
    }

    public void setPartitionKeys(IOlapBuilderDataTableDef table, List<IOlapBuilderTablePartitionKey> partitionKeys) {
        Map<IOlapBuilderTablePartitionKey, Integer> indices = this.partitionIndices.get(table);
        if (indices != null) {
            throw new RuntimeException("internal error : multiple partition-index for table [" + table.getName() + "]");
        }
        DataOutputStream stream = null;
        try {
            stream = new DataOutputStream(new FileOutputStream(new File(this.directory, OlapBuilderOfflineHelper.escapeTableIdForFileName(table) + "-partitions")));
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)"[offline] (write) create partition index error", (Throwable)ex);
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_PARTITION_ERROR, new Serializable[]{ex.getMessage()});
        }
        indices = new HashMap<IOlapBuilderTablePartitionKey, Integer>();
        this.partitionIndices.put(table, indices);
        try {
            stream.writeInt(partitionKeys.size());
            for (int idx = 0; idx < partitionKeys.size(); ++idx) {
                IOlapBuilderTablePartitionKey partitionKey = partitionKeys.get(idx);
                stream.writeInt(idx);
                stream.writeUTF(partitionKey.getName());
                indices.put(partitionKey, idx);
            }
            stream.close();
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)"[offline] (write) partition index error", (Throwable)ex);
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_PARTITION_ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    public void onBuildSchemaDone() {
    }

    public void onBuildDone(OlapSchema schema) {
        if (this.directory == null) {
            return;
        }
        OlapSchemaInformation info = schema.getInformation();
        info.setWrittenOfflineSnapshot(this.directory.getName());
    }

    public void onError() {
        if (this.directory == null) {
            return;
        }
        if (!CdVFileSystemUtils.deleteQuietly((File)this.directory)) {
            OlapLoggers.BUILDER.warn((Object)("[offline] on processing error could not delete the directory [" + this.directory.getAbsolutePath() + "]"));
        }
    }
}

