/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.offline.read;

import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.OlapBuilderAbstractTableRow;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderOfflineTableRow
extends OlapBuilderAbstractTableRow {
    private final Map<String, Integer> positions;
    private final Comparable[] row;

    public OlapBuilderOfflineTableRow(Map<String, Integer> positions, Comparable[] row) {
        this.positions = positions;
        this.row = row;
    }

    @Override
    @Nullable
    protected Object getDataImpl(IOlapBuilderDataColumnDef columnDef) {
        Integer position = this.positions.get(columnDef.getName());
        if (position == null) {
            throw new RuntimeException("internal error : no position for [" + columnDef.getName() + "]!");
        }
        return this.row[position];
    }

    public static String dumpHeader(List<String> cols) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < cols.size(); ++ii) {
            String col = cols.get(ii);
            if (ii > 0) {
                sb.append(",");
            }
            sb.append(col);
        }
        return sb.toString();
    }

    public String dumpContent(List<String> cols) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < cols.size(); ++ii) {
            String col = cols.get(ii);
            Integer pos = this.positions.get(col);
            Comparable val = this.row[pos];
            if (ii > 0) {
                sb.append(",");
            }
            sb.append(val);
        }
        return sb.toString();
    }
}

