/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.offline.read;

import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.status.OlapBuilderDataColumnRefreshStatus;
import crazydev.iccube.builder.model.validation.OlapBuilderDataColumnValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.type.OlapBuilderColumnDecorationType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.validation.OlapValidator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderOfflineDataColumn
implements IOlapBuilderDataColumnDef {
    private final String name;
    private final String tableType;
    private final String olapBuilderInputTypeName;
    @Nullable
    private final String nullObjectAsString;
    private final boolean primaryKey;

    public OlapBuilderOfflineDataColumn(String name, String tableType, String olapBuilderInputTypeName, @Nullable String nullObjectAsString, boolean primaryKey) {
        this.name = name;
        this.tableType = tableType;
        this.olapBuilderInputTypeName = olapBuilderInputTypeName;
        this.nullObjectAsString = nullObjectAsString;
        this.primaryKey = primaryKey;
    }

    public IOlapBuilderDataColumnDef setupForEmptyModel() {
        return this;
    }

    @Override
    public IOlapBuilderDataColumnDef duplicateForView(String newName) {
        throw new RuntimeException("internal error: inconsistent (old) offline column usage");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTableType() {
        return this.tableType;
    }

    @Override
    public OlapBuilderInputType getType() {
        return OlapBuilderInputType.valueOf(this.olapBuilderInputTypeName);
    }

    @Override
    @Nullable
    public OlapBuilderColumnDecorationType getDecorationType() {
        return null;
    }

    @Override
    @Nullable
    public String getNullObjectAsString() {
        return this.nullObjectAsString;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public String getContextVisualId() {
        return this.getName();
    }

    @Override
    public OlapValidator<OlapBuilderValidationContext, IOlapBuilderDataTableDef<?>, IOlapBuilderDataColumnDef> getValidator() {
        return new OlapBuilderDataColumnValidator();
    }

    public void save(DataOutputStream out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.tableType);
        out.writeUTF(this.olapBuilderInputTypeName);
        out.writeBoolean(this.nullObjectAsString == null);
        if (this.nullObjectAsString != null) {
            out.writeUTF(this.nullObjectAsString);
        }
        out.writeBoolean(this.primaryKey);
    }

    public static OlapBuilderOfflineDataColumn restore(DataInputStream in) throws IOException {
        String name = in.readUTF();
        String tableType = in.readUTF();
        String olapBuilderInputTypeName = in.readUTF();
        boolean isNullObjectAsStringNull = in.readBoolean();
        String nullObjectAsString = isNullObjectAsStringNull ? null : in.readUTF();
        boolean primaryKey = in.readBoolean();
        return new OlapBuilderOfflineDataColumn(name, tableType, olapBuilderInputTypeName, nullObjectAsString, primaryKey);
    }

    @Override
    public boolean isSelected() {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public void setSelected(boolean selected) {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public boolean isForTableSelect() {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public void setCleanUpBySolver(boolean cleanUpBySolver) {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public Comparable getNullObject() {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public boolean isLinkedTo(IOlapBuilderDataColumnDef columnDef) {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public void updateFrom(IOlapBuilderDataColumnDef other, OlapBuilderDataColumnRefreshStatus refreshStatus) {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public int getIndex() {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public void setIsArray() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public void setIndex(int i) {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public int getJdbcIndex() {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public void setJdbcIndex(int idx) {
        throw new CdDoNotCallMeProgrammingException();
    }
}

