/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.offline.common;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderOfflineHelper {
    public static String schemaFactoryName(File snapshot) {
        String snapshotName = snapshot.getName();
        int pos = snapshotName.indexOf(".icc-schema");
        if (pos != -1) {
            String schemaFactoryName = snapshotName.substring(0, pos + ".icc-schema".length());
            return schemaFactoryName;
        }
        return snapshotName;
    }

    public static String escapeTableIdForFileName(IOlapBuilderDataTableDef<?> table) {
        String id = table.getId();
        String escaped = CdVFileSystem.toFileName((String)id);
        return escaped;
    }

    public static File createNameForWrite(File offlineDirectory, OlapSchema schema) {
        IOlapBuilderSchemaDefFactory factory = schema.getDefinitionFactory();
        File xmlFile = factory.getXmlFile();
        if (xmlFile == null) {
            throw new CdProgrammingException("internal error : missing XML file for the schema [" + schema.getName() + "]");
        }
        String schemaDefinitionFileName = xmlFile.getName();
        Date now = new Date();
        String info = new SimpleDateFormat("yyyy_MM_dd_HH'h'mm'm'ss", Locale.US).format(now);
        String name = schemaDefinitionFileName + "." + info + "." + now.getTime();
        return new File(offlineDirectory, name);
    }

    @Nullable
    public static String getSchemaName(String offlineSnapshotName) {
        try {
            String[] parts = offlineSnapshotName.split("\\.");
            String name = parts[0];
            return name;
        }
        catch (RuntimeException noLuck) {
            return null;
        }
    }

    public static long getNameMillis(String offlineSnapshotName) {
        try {
            String[] parts = offlineSnapshotName.split("\\.");
            String millisAsString = offlineSnapshotName.toLowerCase().endsWith(".zip") ? parts[parts.length - 2] : parts[parts.length - 1];
            long millis = Long.valueOf(millisAsString);
            return millis;
        }
        catch (RuntimeException noLuck) {
            return -1L;
        }
    }

    public static boolean isValid(String offlineSnapshotName) {
        return OlapBuilderOfflineHelper.getNameMillis(offlineSnapshotName) != -1L;
    }
}

