/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdSetList;
import crazydev.common.mdx.scanner.CdMdxNameValidator;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.factory.schema.OlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderColorsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderLocalizationDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderScriptDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.IOlapBuilderValidationEnabled;
import crazydev.iccube.builder.model.impl.OlapBuilderPerspective;
import crazydev.iccube.builder.model.impl.OlapBuilderScript;
import crazydev.iccube.builder.model.impl.OlapBuilderScriptError;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.contextual.IOlapContextual;
import crazydev.iccube.contextual.OlapContextualErrorManager;
import crazydev.iccube.enums.OlapUnresolvedRowsBehavior;
import crazydev.iccube.mdx.parser.MdxParser;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.mdx.parser.ast.expression.script.MdxScriptExpression;
import crazydev.iccube.mdx.parser.exception.MdxDuplicatedFunctionParserException;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierPart;
import crazydev.iccube.olap.eval.calcmember.OlapCreateCalcMemberStatementInstr;
import crazydev.iccube.olap.eval.script.OlapScriptInstr;
import crazydev.iccube.olap.eval.select.OlapStatementInstr;
import crazydev.iccube.olap.eval.set.OlapCreateSetStatementInstr;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OlapBuilderSchemaValidator
extends OlapBuilderValidator<IOlapBuilderValidationEnabled, IOlapBuilderSchemaDef> {
    private final Logger PARENT_LOGGER;

    public OlapBuilderSchemaValidator() {
        this.PARENT_LOGGER = LOGGER;
    }

    public OlapBuilderSchemaValidator(Logger parentLogger) {
        this.PARENT_LOGGER = parentLogger;
    }

    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderValidationEnabled parent, IOlapBuilderSchemaDef schemaDef) {
        String schemaGroupName;
        String schemaName = schemaDef.getName();
        if (!CdMdxNameValidator.isValidSchemaName((String)schemaName)) {
            context.addError(OlapBuilderSchemaDefFactory.NAME, OlapBuilderErrorCode.SCHEMA_NAME_INVALID, new Serializable[]{OlapBuilderSchemaValidator.getNullableString(schemaName)});
        }
        if (!CdMdxNameValidator.isValidSchemaGroup((String)(schemaGroupName = schemaDef.getGroup()))) {
            context.addError(OlapBuilderSchemaDefFactory.GROUP, OlapBuilderErrorCode.SCHEMA_GROUP_NAME_INVALID, new Serializable[]{schemaName, OlapBuilderSchemaValidator.getNullableString(schemaGroupName)});
        }
        OlapBuilderReferenceSolver referenceSolver = OlapBuilderSchemaMain.createReferenceSolver((OlapBuilderErrorManager)context.getErrorManager(), schemaDef);
        this.validateDataSource(context, schemaDef, schemaDef.getDataSources());
        if (context.hasErrors()) {
            return;
        }
        OlapBuilderSchemaMain.solveReferences((OlapBuilderErrorManager)context.getErrorManager(), schemaDef, referenceSolver);
        this.validateDataViews(context, schemaDef);
        referenceSolver.cleanupNotUsedColumns(this.PARENT_LOGGER, schemaDef.autoCleanUpTableColumns());
        this.validateLocalization(context, schemaDef);
        this.validateColors(context, schemaDef);
        HashSet<String> dimensionsIds = new HashSet<String>();
        List<IOlapBuilderDimensionDef> schemaDimensions = schemaDef.getDimensions();
        for (IOlapBuilderDimensionDef dimension : schemaDimensions) {
            this.checkDimensionId(dimensionsIds, dimension, (OlapBuilderErrorManager)context.getErrorManager());
        }
        this.checkDefaultTimeDimensionFlagIsUnique(context, schemaDef, schemaDimensions);
        this.validateChildren(context, null, schemaDimensions);
        this.validateUniqueNames(context, schemaDimensions, OlapBuilderErrorCode.SCHEMA_DIMENSION_NAME_DUPLICATED);
        List<IOlapBuilderCubeDef> cubes = schemaDef.getCubes();
        this.validateUniqueNames(context, cubes, OlapBuilderErrorCode.CUBE_NAME_DUPLICATED);
        this.validateChildren(context, schemaDef, cubes);
        OlapBuilderSchemaValidator.validateScript(context, schemaDef.getScript(), schemaDef.getCubes());
        this.validatePerspectives(context, schemaDef);
        this.validateUnresolvedRowsStrategy(context, schemaDef);
        if (schemaDef.useFactPartitioning() && !context.isFactsPartitioningLicensed()) {
            context.addError(OlapBuilderErrorCode.FACT_PARTITION_NOT_LICENSED, new Serializable[0]);
        }
        this.validateCubeDimensionUniqueNames(context, schemaDimensions, cubes);
    }

    private void validateCubeDimensionUniqueNames(OlapBuilderValidationContext context, List<IOlapBuilderDimensionDef> schemaDimensions, List<IOlapBuilderCubeDef> cubes) {
        if (!context.isDimensionCubeNameUnique()) {
            return;
        }
        for (IOlapBuilderDimensionDef schemaDimension : schemaDimensions) {
            IOlapBuilderCubeDef existingCube = (IOlapBuilderCubeDef)CdCollections.findFirst(cubes, cube -> OlapCaseInsensitiveName.equals(schemaDimension.getName(), cube.getName()));
            if (existingCube == null) continue;
            context.addError(OlapBuilderErrorCode.SCHEMA_DIMENSION_CUBE_NAME_DUPLICATED, new Serializable[]{existingCube.getName()});
        }
    }

    private void validateUnresolvedRowsStrategy(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef) {
        HashMap<IOlapBuilderDataTableDef, ArrayList<IOlapBuilderBaseFactsDef>> factsByTables = new HashMap<IOlapBuilderDataTableDef, ArrayList<IOlapBuilderBaseFactsDef>>();
        List<IOlapBuilderCubeDef> cubes = schemaDef.getCubes();
        for (IOlapBuilderCubeDef cube : cubes) {
            List<IOlapBuilderBaseFactsDef> facts = cube.getFacts();
            for (IOlapBuilderBaseFactsDef fact : facts) {
                IOlapBuilderTabularDataDef tabularData = fact.getDataView();
                CdSetList<IOlapBuilderDataTableDef> dataTables = tabularData.getUnderlyingTables();
                if (dataTables.isEmpty()) continue;
                for (IOlapBuilderDataTableDef dataTable : dataTables) {
                    ArrayList<IOlapBuilderBaseFactsDef> tableFacts = (ArrayList<IOlapBuilderBaseFactsDef>)factsByTables.get(dataTable);
                    if (tableFacts == null) {
                        tableFacts = new ArrayList<IOlapBuilderBaseFactsDef>();
                        factsByTables.put(dataTable, tableFacts);
                    }
                    tableFacts.add(fact);
                }
            }
        }
        for (Map.Entry entry : factsByTables.entrySet()) {
            IOlapBuilderDataTableDef table = (IOlapBuilderDataTableDef)entry.getKey();
            List tableFacts = (List)entry.getValue();
            if (tableFacts.size() <= 1) continue;
            this.validateUnresolvedRowsStrategy(context, schemaDef, table, tableFacts);
        }
    }

    private void validateUnresolvedRowsStrategy(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef, IOlapBuilderDataTableDef table, List<IOlapBuilderBaseFactsDef> tableFacts) {
        OlapUnresolvedRowsBehavior behavior;
        if (tableFacts.size() <= 1) {
            return;
        }
        boolean hasGenerateError = false;
        for (IOlapBuilderBaseFactsDef tableFact : tableFacts) {
            behavior = tableFact.getUnresolvedRowsBehavior();
            if (behavior != OlapUnresolvedRowsBehavior.ERROR) continue;
            hasGenerateError = true;
            break;
        }
        if (hasGenerateError) {
            for (IOlapBuilderBaseFactsDef tableFact : tableFacts) {
                behavior = tableFact.getUnresolvedRowsBehavior();
                if (behavior == OlapUnresolvedRowsBehavior.ERROR) continue;
                IOlapBuilderCubeDef cube = schemaDef.getCube(tableFact);
                IOlapBuilderBaseFactsDef facts = tableFact;
                context.addErrorWithContextual((IOlapContextual)cube, facts, OlapBuilderFacts.UNRESOLVED_ROWS_BEHAVIOR, OlapBuilderErrorCode.UNRESOLVED_ROWS_MULTIPLE_LISTENER_ERROR, new Serializable[]{tableFact.getMeasureGroupName(), table.getName()});
            }
        }
    }

    private void validatePerspectives(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef) {
        List<IOlapBuilderPerspectiveDef> perspectives = schemaDef.getPerspectives();
        if (perspectives != null && !perspectives.isEmpty()) {
            this.validateUniqueNames(context, perspectives, OlapBuilderErrorCode.PERSPECTIVE_NAME_DUPLICATED);
            IOlapBuilderPerspectiveDef defaultPerspective = null;
            for (IOlapBuilderPerspectiveDef perspective : perspectives) {
                if (!perspective.isDefault()) continue;
                if (defaultPerspective != null) {
                    context.addErrorWithContextual((IOlapContextual)perspective, OlapBuilderPerspective.DEFINITION, OlapBuilderErrorCode.PERSPECTIVE_WITH_MULTIPLE_DEFAULTS, new Serializable[]{defaultPerspective.getName(), perspective.getName()});
                }
                defaultPerspective = perspective;
            }
            this.validateChildren(context, schemaDef, perspectives);
        }
    }

    private void checkDefaultTimeDimensionFlagIsUnique(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef, List<IOlapBuilderDimensionDef> schemaDimensions) {
        boolean defaultTimeDimension = false;
        String defaultTimeDimensionName = null;
        for (IOlapBuilderDimensionDef dimension : schemaDimensions) {
            if (!dimension.isDefaultTimeDimension() || !dimension.isTimeDimension()) continue;
            if (defaultTimeDimension) {
                context.addError(OlapBuilderErrorCode.SCHEMA_DIMENSION_DEFAULT_TIME_DIM_NOT_UNIQUE, new Serializable[]{defaultTimeDimensionName, dimension.getName()});
            }
            defaultTimeDimension = true;
            defaultTimeDimensionName = dimension.getName();
        }
    }

    private void validateDataViews(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef) {
        Object errorManager = context.getErrorManager();
        List<IOlapBuilderDataViewDef> views = schemaDef.getViews();
        HashSet<String> viewIds = new HashSet<String>();
        for (IOlapBuilderDataViewDef view : views) {
            if (viewIds.add(view.getId())) continue;
            ((OlapContextualErrorManager)errorManager).addError((OlapBuilderErrorCode)OlapBuilderErrorCode.DATA_VIEW_ID_DUPLICATED, new Serializable[]{view.getId()});
        }
        this.validateChildren(context, schemaDef, views);
    }

    private void validateDataSource(OlapBuilderValidationContext context, IOlapBuilderValidationEnabled parent, List<IOlapBuilderDataSource> dataSources) {
        HashSet<String> dataSourcesIds = new HashSet<String>();
        HashSet<String> dataTablesIds = new HashSet<String>();
        int size = dataSources.size();
        for (int ii = 0; ii < size; ++ii) {
            IOlapBuilderDataSource dataSource = dataSources.get(ii);
            if (!dataSourcesIds.add(dataSource.getName())) {
                context.addError(OlapBuilderErrorCode.DATASOURCE_NAME_DUPLICATED, new Serializable[]{dataSource.getName()});
            }
            List tables = dataSource.getTables();
            int tablesSize = tables.size();
            for (int jj = 0; jj < tablesSize; ++jj) {
                IOlapBuilderDataTableDef table = tables.get(jj);
                this.checkDataTableId(dataTablesIds, (OlapBuilderErrorManager)context.getErrorManager(), table);
            }
        }
        this.validateChildren(context, parent, dataSources);
    }

    private void checkDataTableId(Set<String> dataTableIds, OlapBuilderErrorManager errorManager, IOlapBuilderDataTableDef<?> dataTable) {
        if (!dataTableIds.add(dataTable.getId())) {
            errorManager.addError(OlapBuilderErrorCode.DATATABLE_ID_DUPLICATED, new Serializable[]{dataTable.getId()});
        }
    }

    private void checkDimensionId(Set<String> dimensionsIds, IOlapBuilderDimensionDef dimension, OlapBuilderErrorManager errorManager) {
        if (!dimensionsIds.add(dimension.getId())) {
            errorManager.addError(OlapBuilderErrorCode.DIMENSION_ID_DUPLICATED, new Serializable[]{dimension.getId()});
        }
    }

    private void validateLocalization(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef) {
        IOlapBuilderLocalizationDef localization = schemaDef.getLocalization();
        ArrayList<IOlapBuilderLocalizationDef> children = new ArrayList<IOlapBuilderLocalizationDef>();
        children.add(localization);
        this.validateChildren(context, schemaDef, children);
    }

    private void validateColors(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef) {
        IOlapBuilderColorsDef colors = schemaDef.getColors();
        ArrayList<IOlapBuilderColorsDef> children = new ArrayList<IOlapBuilderColorsDef>();
        children.add(colors);
        this.validateChildren(context, schemaDef, children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateScript(OlapBuilderValidationContext context, IOlapBuilderScriptDef script, List<IOlapBuilderCubeDef> cubes) {
        Object errorManager = context.getErrorManager();
        try {
            ((OlapContextualErrorManager)errorManager).pushContext(script);
            MdxParsingContext parsingContext = context.setupParsingContext();
            MdxScriptExpression scriptExpression = MdxParser.parseMdxScript(parsingContext, script.getName(), script.getContent(), script.getName());
            if (script instanceof OlapBuilderScript) {
                ((OlapBuilderScript)script).generateScriptNativeByteCode(context, scriptExpression);
            }
            Set<String> declaredFunctions = parsingContext.getDeclaredFunctions();
            context.setScriptDeclaredFunctions(declaredFunctions);
            if (!scriptExpression.isEmpty()) {
                OlapCompilationContext compilationContext = context.setupCompilationContext();
                OlapScriptInstr instr = (OlapScriptInstr)compilationContext.compile(scriptExpression);
                OlapBuilderSchemaValidator.validateCalcMemberNames(context, cubes, instr);
                OlapBuilderSchemaValidator.validateDuplicatedCalcMemberNames(context, instr);
                OlapBuilderSchemaValidator.validateDuplicatedNameSetNames(context, instr);
            }
        }
        catch (OlapBuilderScriptError tunnel) {
            ((OlapContextualErrorManager)errorManager).addErrorWithContextual(script, (OlapBuilderError)tunnel.getError());
        }
        catch (MdxDuplicatedFunctionParserException ex) {
            ((OlapContextualErrorManager)errorManager).addErrorWithContextual((IOlapContextual)script, (OlapBuilderErrorCode)OlapBuilderErrorCode.SCHEMA_FUNCTION_NAME_DUPLICATED, new Serializable[]{ex.getName()});
        }
        catch (CdMdxScannerException ex) {
            OlapBuilderError builderError = new OlapBuilderError(ex.getError(), OlapBuilderErrorCode.SCHEMA_SCRIPT_EMBEDDED_MDX_ERROR, new Serializable[0]);
            ((OlapContextualErrorManager)errorManager).addErrorWithContextual(script, (OlapBuilderError)builderError);
        }
        catch (MdxParserException ex) {
            OlapBuilderError builderError = new OlapBuilderError(ex.getError(), OlapBuilderErrorCode.SCHEMA_SCRIPT_EMBEDDED_MDX_ERROR, new Serializable[0]);
            ((OlapContextualErrorManager)errorManager).addErrorWithContextual(script, (OlapBuilderError)builderError);
        }
        finally {
            ((OlapContextualErrorManager)errorManager).popContext();
        }
    }

    private static void validateDuplicatedNameSetNames(OlapBuilderValidationContext context, OlapScriptInstr instr) {
        ArrayList<String> names = new ArrayList<String>();
        List<OlapStatementInstr> statements = instr.getStatements();
        for (OlapStatementInstr statement : statements) {
            if (!(statement instanceof OlapCreateSetStatementInstr)) continue;
            OlapCreateSetStatementInstr set = (OlapCreateSetStatementInstr)statement;
            String setName = set.getName().toLowerCase();
            if (names.contains(setName)) {
                context.addError(OlapBuilderErrorCode.SCHEMA_NAMED_SET_NAME_DUPLICATED, new Serializable[]{set.getName()});
            }
            names.add(setName);
        }
    }

    private static void validateCalcMemberNames(OlapBuilderValidationContext context, List<IOlapBuilderCubeDef> cubes, OlapScriptInstr instr) {
        if (cubes == null || cubes.size() < 2) {
            return;
        }
        for (OlapStatementInstr statement : instr.getStatements()) {
            OlapCreateCalcMemberStatementInstr calcMember;
            OlapEntityIdentifier name;
            int pos;
            if (!(statement instanceof OlapCreateCalcMemberStatementInstr) || (pos = OlapBuilderSchemaValidator.extractMeasuresPos(name = (calcMember = (OlapCreateCalcMemberStatementInstr)statement).getId())) != 0 && name.getPartCount() != 1) continue;
            context.addError(OlapBuilderErrorCode.SCHEMA_CALC_MEMBER_NAME_MISSING_CUBE, new Serializable[]{name.asString()});
        }
    }

    private static int extractMeasuresPos(OlapEntityIdentifier name) {
        int count = name.getPartCount();
        for (int ii = 0; ii < count; ++ii) {
            String part = name.getPartAsName(ii);
            if (!OlapCaseInsensitiveName.equals("measures", part)) continue;
            return ii;
        }
        return -1;
    }

    private static void validateDuplicatedCalcMemberNames(OlapBuilderValidationContext context, OlapScriptInstr instr) {
        ArrayList<OlapEntityIdentifier> names = new ArrayList<OlapEntityIdentifier>();
        for (OlapStatementInstr statement : instr.getStatements()) {
            if (!(statement instanceof OlapCreateCalcMemberStatementInstr)) continue;
            OlapCreateCalcMemberStatementInstr calcMember = (OlapCreateCalcMemberStatementInstr)statement;
            OlapEntityIdentifier name = calcMember.getId();
            if (OlapBuilderSchemaValidator.containsCalcMemberIdentifier(names, name)) {
                context.addError(OlapBuilderErrorCode.SCHEMA_CALC_MEMBER_NAME_DUPLICATED, new Serializable[]{name.asString()});
            }
            names.add(name);
        }
    }

    private static boolean containsCalcMemberIdentifier(List<OlapEntityIdentifier> existingIdentifiers, OlapEntityIdentifier identifier) {
        for (OlapEntityIdentifier existingIdentifier : existingIdentifiers) {
            if (existingIdentifier.getPartCount() != identifier.getPartCount()) continue;
            boolean found = true;
            for (int idx = 0; idx < existingIdentifier.getPartCount(); ++idx) {
                OlapEntityIdentifierPart identifierPart;
                OlapEntityIdentifierPart existingIdentifierPart = existingIdentifier.getPart(idx);
                if (existingIdentifierPart.equals(identifierPart = identifier.getPart(idx))) continue;
                found = false;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }
}

