/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.mdx.scanner.CdMdxNameValidator;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderValidationEnabled;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import java.io.Serializable;

public class OlapBuilderPropertyValidator<T extends IOlapBuilderValidationEnabled>
extends OlapBuilderValidator<T, IOlapBuilderPropertyDef> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, T level, IOlapBuilderPropertyDef property) {
        String propertyName = OlapBuilderPropertyValidator.getNullableString(property.getName());
        if (!CdMdxNameValidator.isValidPropertyName((String)property.getName())) {
            context.addError(OlapBuilderErrorCode.PROPERTY_NAME_INVALID, new Serializable[]{propertyName});
        }
        if (context.isIntrinsicMemberProperty(property.getName())) {
            context.addError(OlapBuilderErrorCode.PROPERTY_NAME_INTRINSIC_ONE, new Serializable[]{propertyName});
        }
        if (!property.isAttribute()) {
            if (property.getPropertyColumn() == null) {
                context.addError(OlapBuilderErrorCode.PROPERTY_VALUE_MANDATORY, new Serializable[]{propertyName});
            } else if (!this.containsColumn(property.getPropertyColumn())) {
                context.addError(OlapBuilderErrorCode.PROPERTY_VALUE_MISSING, new Serializable[]{propertyName});
            }
        }
    }
}

