/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.mdx.error.CdMdxException;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.impl.OlapBuilderPerspective;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.mdx.parser.MdxParser;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import java.io.Serializable;

public class OlapBuilderPerspectivesValidator
extends OlapBuilderValidator<IOlapBuilderSchemaDef, OlapBuilderPerspective> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef, OlapBuilderPerspective perspective) {
        if (!context.isPerspectivesLicensed()) {
            context.addError(OlapBuilderErrorCode.PERSPECTIVE_NOT_LICENSED, new Serializable[0]);
            return;
        }
        boolean isDefault = perspective.isDefault();
        IOlapBuilderCubeDef cube = perspective.getCube();
        if (isDefault && cube != null) {
            context.addError(OlapBuilderErrorCode.PERSPECTIVE_DEFAULT_WITH_CUBE, new Serializable[]{perspective.getName(), cube.getName()});
        } else if (!isDefault && cube == null) {
            context.addError(OlapBuilderErrorCode.PERSPECTIVE_NON_DEFAULT_MISSING_CUBE, new Serializable[]{perspective.getName()});
        }
        MdxParsingContext parsingContext = context.setupParsingContext();
        try {
            MdxParser.parsePerspective(parsingContext, perspective.getDefinition(), "no hash");
        }
        catch (CdMdxException ex) {
            context.addError(OlapBuilderPerspective.DEFINITION, ex.getError().getLocation(), OlapBuilderErrorCode.PERSPECTIVE_DEFINITION_PARSER_ERROR, new Serializable[]{perspective.getName(), ex.getError()});
        }
    }
}

