/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderParentChildHierarchy;
import crazydev.iccube.builder.model.validation.OlapBuilderHierarchyValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import java.io.Serializable;

public class OlapBuilderParentChildHierarchyValidator
extends OlapBuilderHierarchyValidator {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef hierarchy) {
        super.doValidate(context, dimension, hierarchy);
        OlapBuilderParentChildHierarchy myHierarchy = (OlapBuilderParentChildHierarchy)hierarchy;
        this.validateNotNullField(context, OlapBuilderParentChildHierarchy.MEMBER_NAME, myHierarchy.getMemberName());
        this.validateNotNullField(context, OlapBuilderParentChildHierarchy.MEMBER_KEY, myHierarchy.getMemberKey());
        this.validateNotNullField(context, OlapBuilderParentChildHierarchy.PARENT_NODE_ID, myHierarchy.getParentId());
        this.validateNotNullField(context, OlapBuilderParentChildHierarchy.NODE_ID, myHierarchy.getId());
        this.validateColumn(context, myHierarchy.getMemberName());
        this.validateColumn(context, myHierarchy.getMemberKey());
        this.validateColumn(context, myHierarchy.getParentId());
        this.validateColumn(context, myHierarchy.getId());
        if (myHierarchy.getParentId() != null && myHierarchy.getId() != null && myHierarchy.getParentId().getType() != myHierarchy.getId().getType()) {
            context.addError(OlapBuilderParentChildHierarchy.PARENT_NODE_ID, OlapBuilderErrorCode.PARENT_CHILD_HIER_PARENT_ID_MISMATCH, new Serializable[]{myHierarchy.getName(), myHierarchy.getId().getType(), myHierarchy.getParentId().getType()});
        }
        this.validatePatternLevelName(context, myHierarchy.getLevelNamePattern());
        this.validateProperties(context, myHierarchy, myHierarchy.getProperties());
    }

    @Override
    protected void validateLevels(OlapBuilderValidationContext context, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef hierarchy) {
    }

    @Override
    protected void validateIsIndexingByRange(OlapBuilderValidationContext context, IOlapBuilderHierarchyDef hierarchy) {
    }

    @Override
    public void validateFactLink(OlapBuilderErrorManager errorManager, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef defaultHierarchy, IOlapBuilderDataViewLinksDef linksDef) {
        this.validateFactLinkWithoutLevels(errorManager, dimension, defaultHierarchy, linksDef);
    }
}

