/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.property.CdProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderMultiLevelDimension;
import crazydev.iccube.builder.model.validation.OlapBuilderDimensionValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderMultiLevelDimensionValidator<T extends IOlapBuilderHierarchyDef>
extends OlapBuilderDimensionValidator<T> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, @Nullable IOlapBuilderCubeDef cube, IOlapBuilderDimensionDef dimension) {
        super.doValidate(context, cube, dimension);
        OlapBuilderMultiLevelDimension dimDef = (OlapBuilderMultiLevelDimension)dimension;
        this.validateExpr(context, OlapBuilderMultiLevelDimension.DYN_HIER_IS_COLUMN, dimDef.getDynHierIsColumn());
        this.validateExpr(context, OlapBuilderMultiLevelDimension.DYN_HIER_NAME, dimDef.getDynHierName());
        this.validateExpr(context, OlapBuilderMultiLevelDimension.DYN_HIER_LEVEL_NAME, dimDef.getDynHierLevelName());
        this.validateExpr(context, OlapBuilderMultiLevelDimension.DYN_HIER_ALLMEMBER, dimDef.getDynHierAllMember());
        this.validateExpr(context, OlapBuilderMultiLevelDimension.DYN_HIER_IS_KEY, dimDef.getDynHierIsKey());
        this.validateExpr(context, OlapBuilderMultiLevelDimension.DYN_HIER_IS_ORDER, dimDef.getDynHierIsOrder());
        this.validateExpr(context, OlapBuilderMultiLevelDimension.DYN_HIER_IS_ORDER_BY_NAME, dimDef.getDynHierIsOrderByName());
        this.validateExpr(context, OlapBuilderMultiLevelDimension.DYN_HIER_IS_ORDER_DESC, dimDef.getDynHierIsOrderDesc());
        this.validateExpr(context, OlapBuilderMultiLevelDimension.DYN_MISSING_ATTRIBUTE_NAME, dimDef.getDynMissingAttributeName());
        this.validateExpr(context, OlapBuilderMultiLevelDimension.IS_PARENT_CHILD_HIERARCHY, dimDef.getIsParentChildHierarchy());
        this.validateExpr(context, OlapBuilderMultiLevelDimension.PARENT_CHILD_IS_ID_COL, dimDef.getParenChildIsIdCol());
        this.validateExpr(context, OlapBuilderMultiLevelDimension.PARENT_CHILD_IS_KEY_COL, dimDef.getParentChildIsKeyCol());
        this.validateExpr(context, OlapBuilderMultiLevelDimension.PARENT_CHILD_IS_PARENT_ID_COL, dimDef.getParentChildIsParentIdCol());
        this.validateExpr(context, OlapBuilderMultiLevelDimension.DYN_ADD_ALL_MEMBER_TO_PARENT_CHILD, dimDef.getDynAddAllMemberToParentChild());
    }

    private void validateExpr(OlapBuilderValidationContext context, CdProperty prop, String expr) {
        if (CdStringUtils.isNullOrBlank((String)expr)) {
            return;
        }
        if (expr.startsWith("\\")) {
            this.validateNullableJavaRegExp(context, prop, expr.substring(1));
        }
    }
}

