/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.mdx.error.CdMdxException;
import crazydev.common.mdx.scanner.CdMdxNameValidator;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.impl.OlapBuilderMeasure;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.mdx.parser.MdxParser;
import crazydev.iccube.mdx.parser.MdxParserIdentifierHelper;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCalcMemberProperties;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.ast.select.MdxCreateXyzExpressionPropertiesCompilerHelper;
import crazydev.iccube.olap.compiler.exception.OlapCompilationException;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class OlapBuilderMeasureValidator
extends OlapBuilderValidator<IOlapBuilderBaseFactsDef, IOlapBuilderMeasureDef> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderBaseFactsDef facts, IOlapBuilderMeasureDef measure) {
        OlapAggregationType aggregationType;
        if (!CdMdxNameValidator.isValidMeasureName((String)measure.getName())) {
            context.addError(OlapBuilderErrorCode.MEASURE_NAME_INVALID, new Serializable[]{OlapBuilderMeasureValidator.getNullableString(measure.getName())});
        }
        if ((aggregationType = measure.getAggregationType()) == null) {
            context.addError(OlapBuilderErrorCode.MEASURE_AGGREGATION_TYPE_MANDATORY, new Serializable[]{OlapBuilderMeasureValidator.getNullableString(measure.getName())});
        }
        this.validateRollupHierarchy(context, measure);
        if (measure.getColumn() == null) {
            context.addError(OlapBuilderErrorCode.MEASURE_MISSING_COLUMN, new Serializable[]{OlapBuilderMeasureValidator.getNullableString(measure.getName())});
        }
        if (measure.getKey() == null) {
            context.addError(OlapBuilderErrorCode.MEASURE_KEY_MANDATORY, new Serializable[]{OlapBuilderMeasureValidator.getNullableString(measure.getName())});
        }
        if (measure.getInputValueType() == null) {
            context.addError(OlapBuilderErrorCode.MEASURE_VALUE_TYPE_MANDATORY, new Serializable[]{OlapBuilderMeasureValidator.getNullableString(measure.getName())});
        }
        if (aggregationType != null && measure.emptyIsZero() && !aggregationType.supportsEmptyToZero()) {
            context.addError(OlapBuilderErrorCode.MEASURE_EMPTY_TO_ZERO_NOT_SUPPORTED, new Serializable[]{aggregationType.getFriendlyName(), OlapBuilderMeasureValidator.getNullableString(measure.getName())});
        }
        if (aggregationType != null && aggregationType.isRollupHierarchyRequired() && CdStringUtils.isNullOrBlank((String)measure.getRollupHierarchy()) && !OlapBuilderMeasureValidator.hasDefaultTimeDimension(context.getSchemaDef())) {
            context.addError(OlapBuilderErrorCode.MEASURE_ROLLUP_HIERARCHY_DEFAULT_TIME_HIERARCHY_MISSING, new Serializable[]{measure.getName(), aggregationType.getFriendlyName()});
        }
        if (measure.getColumn().isArray() && !measure.getFactDataType().supportsArrayFactColumn()) {
            context.addError(OlapBuilderErrorCode.MEASURE_DATA_TYPE_NOT_SUPPORT_ARRAY_TYPE, new Serializable[]{measure.getInputValueType()});
        }
        if (measure.getColumn().isArray() && aggregationType != null && !aggregationType.supportsArrayFactColumn()) {
            context.addError(OlapBuilderErrorCode.MEASURE_AGGREGATION_TYPE_NOT_SUPPORT_ARRAY_TYPE, new Serializable[]{aggregationType.getFriendlyName()});
        }
        this.doValidateCellProperties(context, measure);
    }

    private void doValidateCellProperties(OlapBuilderValidationContext context, IOlapBuilderMeasureDef measureDef) {
        String cellProperties = measureDef.getCellProperties();
        if (StringUtils.isBlank((CharSequence)cellProperties)) {
            return;
        }
        try {
            String mdx = cellProperties;
            String mdxHash = UUID.randomUUID().toString();
            MdxParsingContext parsingContext = context.setupParsingContext();
            MdxSelectCalcMemberProperties mdxProperties = MdxParser.parseCalcMemberProperties(parsingContext, mdx, mdxHash);
            OlapCompilationContext compilationContext = context.setupCompilationContext();
            OlapCellProperties properties = MdxCreateXyzExpressionPropertiesCompilerHelper.compileProperties(compilationContext, measureDef.getName(), mdxProperties);
            String amg = properties.getAssociatedMeasureGroup();
            if (CdStringUtils.isNotNullAndNotBlank((String)amg)) {
                OlapInstrLocationRange errorLocation = compilationContext.getErrorLocation();
                context.addError(OlapBuilderMeasure.CELL_PROPERTIES, errorLocation, OlapBuilderErrorCode.MEASURE_CELL_PROPERTIES_INVALID, new Serializable[]{measureDef.getName(), "ASSOCIATED_MEASURE_GROUP"});
            }
        }
        catch (CdMdxException ex) {
            context.addError(OlapBuilderMeasure.CELL_PROPERTIES, ex.getError().getLocation(), OlapBuilderErrorCode.MEASURE_CELL_PROPERTIES_INVALID, new Serializable[]{measureDef.getName(), ex.getError()});
        }
        catch (OlapCompilationException ex) {
            context.addError(OlapBuilderMeasure.CELL_PROPERTIES, ex.getError().getLocation(), OlapBuilderErrorCode.MEASURE_CELL_PROPERTIES_INVALID, new Serializable[]{measureDef.getName(), ex.getError()});
        }
    }

    private void validateRollupHierarchy(OlapBuilderValidationContext context, IOlapBuilderMeasureDef measureDef) {
        String rollupHierarchy = measureDef.getRollupHierarchy();
        if (!CdStringUtils.isNullOrBlank((String)rollupHierarchy)) {
            try {
                MdxParserIdentifierHelper.parseIdentifierX(rollupHierarchy, "rollup hierarchy");
            }
            catch (CdMdxException ex) {
                context.addError(OlapBuilderErrorCode.MEASURE_ROLLUP_HIERARCHY_PARSE_ERROR, new Serializable[]{measureDef.getName(), rollupHierarchy, ex.getError()});
            }
        }
    }
}

