/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcStatementDataTable;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.validation.OlapBuilderJdbcDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import java.io.Serializable;

public class OlapBuilderJdbcStatementValidator
extends OlapBuilderJdbcDataTableValidator {
    @Override
    protected boolean checkTable(OlapBuilderValidationContext context, OlapBuilderJdbcConnection connection, IOlapBuilderDataTableDef<OlapBuilderJdbcConnection> dataTable) {
        if (dataTable instanceof OlapBuilderJdbcStatementDataTable) {
            String sql;
            OlapBuilderJdbcStatementDataTable table = (OlapBuilderJdbcStatementDataTable)dataTable;
            if (table.getSql() == null || table.getSql().trim().isEmpty()) {
                context.addError(OlapBuilderJdbcStatementDataTable.SQL_STATEMENT, OlapBuilderErrorCode.EMPTY_SQL_STATEMENT, new Serializable[]{dataTable.getName()});
                return false;
            }
            IOlapBuilderSchemaDef schemaDef = context.getSchemaDef();
            if (schemaDef != null && schemaDef.activateIncrementalLoad() && CdStringUtils.isNotNullAndNotBlank((String)(sql = table.getSqlIncremental())) && !sql.contains("?")) {
                context.addError(OlapBuilderJdbcStatementDataTable.SQL_INCREMENTAL_STATEMENT, OlapBuilderErrorCode.INCREMENTAL_SQL_MISSING_PARAM, new Serializable[]{dataTable.getName()});
            }
        } else {
            throw new CdProgrammingException("invalid validator for class [" + String.valueOf(dataTable.getClass()) + "]");
        }
        return true;
    }
}

