/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.validation.OlapBuilderBaseDataSourceValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Properties;

public class OlapBuilderJdbcDataSourceValidator
extends OlapBuilderBaseDataSourceValidator {
    @Override
    protected void doValidateFields(OlapBuilderValidationContext context, IOlapBuilderDataSource dataSource) {
        String stringToDateConverter;
        super.doValidateFields(context, dataSource);
        OlapBuilderJdbcDataSource myDataSource = (OlapBuilderJdbcDataSource)dataSource;
        this.validateNotNullField(context, OlapBuilderJdbcDataSource.DRIVER_TYPE, (Object)myDataSource.getDriverType());
        if (myDataSource.getDriverType() != OlapBuilderDriverType.SERVER_AS_JDBCDRIVER_DBNAME_AS_JDBCURL) {
            this.validateNotBlankField(context, OlapBuilderJdbcDataSource.SERVER_NAME, myDataSource.getServerName());
        }
        if (myDataSource.getDriverType() != OlapBuilderDriverType.TRINO) {
            this.validateNotBlankField(context, OlapBuilderJdbcDataSource.DB_NAME, myDataSource.getDbName());
        } else {
            this.validateNotBlankField(context, OlapBuilderJdbcDataSource.CATALOG_NAME, myDataSource.getCatalog());
            this.validateNotBlankField(context, OlapBuilderJdbcDataSource.SCHEMA_NAME, myDataSource.getSchemaName());
        }
        String urlParams = myDataSource.getUrlParams();
        if (CdStringUtils.isNotNullAndNotBlank((String)urlParams)) {
            try {
                Properties params = new Properties();
                params.load(new StringReader(urlParams));
            }
            catch (IOException ex) {
                context.addError(OlapBuilderJdbcDataSource.URL_PARAMS, OlapBuilderErrorCode.JDBC_INVALID_PARAMS, new Serializable[]{myDataSource.getDbName(), ex.getMessage()});
            }
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)(stringToDateConverter = myDataSource.getStringDateConverter()))) {
            try {
                String[] converters = stringToDateConverter.split("_&_");
                Arrays.stream(converters).forEach(s -> {
                    if (!"epoch".equalsIgnoreCase((String)s)) {
                        new SimpleDateFormat((String)s);
                    }
                });
            }
            catch (Exception ex) {
                context.addError(OlapBuilderJdbcDataSource.DATE_FORMAT, OlapBuilderErrorCode.JDBC_INVALID_PARAMS, new Serializable[]{myDataSource.getDbName(), ex.getMessage()});
            }
        }
    }
}

