/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.utils.CdLineReader;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.datasource.file.OlapBuilderBaseFileDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderDirectoryConnection;
import crazydev.iccube.builder.datasource.file.OlapBuilderLineDataTable;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderNonEmptyDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class OlapBuilderFileLineDataTableValidator
extends OlapBuilderNonEmptyDataTableValidator<OlapBuilderDirectoryConnection, IOlapBuilderDataSource<OlapBuilderDirectoryConnection>> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderDataSource<OlapBuilderDirectoryConnection> dataSource, IOlapBuilderDataTableDef<OlapBuilderDirectoryConnection> dataTable) {
        OlapBuilderBaseFileDataTable myDataTable = (OlapBuilderBaseFileDataTable)dataTable;
        String encoding = myDataTable.getFileEncoding();
        if (!Charset.isSupported(encoding)) {
            context.addError(OlapBuilderErrorCode.CHAR_ENCODING_NOT_SUPPORTED, new Serializable[]{encoding});
        } else {
            this.validateColumnSeparator(context, myDataTable);
            super.doValidate(context, dataSource, dataTable);
        }
        if (myDataTable.hasTablePartitioning()) {
            StringBuilder builder = new StringBuilder();
            OlapBuilderConnectionPool connectionPool = context.getConnectionPool();
            OlapBuilderDirectoryConnection connection = (OlapBuilderDirectoryConnection)connectionPool.getOrCreateOpenedConnection(context.asRuntimeContext(), myDataTable.getDataSource());
            try {
                CdLineReader lineReader = myDataTable.createLineReader(context.asRuntimeContext(), connection);
                if (lineReader != null) {
                    OlapBuilderBaseFileDataTable.PartitionExtractor extractor = myDataTable.createPartitionExtractor();
                    lineReader.forEachFileName(fileName -> {
                        boolean error = false;
                        try {
                            error = CdStringUtils.isNullOrBlank((String)extractor.extract((String)fileName));
                        }
                        catch (OlapBuilderErrorException ex) {
                            error = true;
                        }
                        if (error) {
                            builder.append(builder.toString().isEmpty() ? "" : ",").append((String)fileName);
                        }
                    });
                }
            }
            finally {
                connectionPool.releaseOpenedConnection(connection);
            }
            String errors = builder.toString();
            if (!errors.isEmpty()) {
                context.addError(OlapBuilderBaseFileDataTable.PARTITIONING_STRATEGY, OlapBuilderErrorCode.WRONG_PARTITION_STRATEGY, new Serializable[]{myDataTable.getPartitioningStrategy(), errors});
            }
        }
    }

    protected void validateColumnSeparator(OlapBuilderValidationContext context, OlapBuilderBaseFileDataTable myDataTable) {
        this.validateNotNullField(context, OlapBuilderLineDataTable.COLUMN_SEPARATOR, myDataTable.getColumnSeparator());
    }

    @Override
    protected boolean checkTableExists(OlapRuntimeContext context, OlapBuilderDirectoryConnection connection, IOlapBuilderDataTableDef<OlapBuilderDirectoryConnection> dataTable) throws SQLException {
        OlapBuilderBaseFileDataTable myDataTable = (OlapBuilderBaseFileDataTable)dataTable;
        if (myDataTable.isSingleFile()) {
            String fileName = myDataTable.getFileName();
            return connection.isFileExist(context, fileName);
        }
        return true;
    }
}

