/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.collection.CdCollections;
import crazydev.common.mdx.scanner.CdMdxNameValidator;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class OlapBuilderCubeValidator
extends OlapBuilderValidator<IOlapBuilderSchemaDef, IOlapBuilderCubeDef> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schema, IOlapBuilderCubeDef cube) {
        List<IOlapBuilderDimensionDef> schemaDimensions;
        if (!CdMdxNameValidator.isValidCubeName((String)cube.getName())) {
            context.addError(OlapBuilderErrorCode.CUBE_NAME_INVALID, new Serializable[]{OlapBuilderCubeValidator.getNullableString(cube.getName())});
        }
        if (CdCollections.isEmpty(schemaDimensions = schema.getDimensions())) {
            context.addError(OlapBuilderErrorCode.CUBE_WITHOUT_DIMENSIONS, new Serializable[]{OlapBuilderCubeValidator.getNullableString(cube.getName())});
        }
        boolean hasDefaultTimeDimension = OlapBuilderCubeValidator.hasDefaultTimeDimension(schema);
        List<IOlapBuilderBaseFactsDef> facts = cube.getFacts();
        if (facts == null || facts.isEmpty()) {
            context.addError(OlapBuilderErrorCode.CUBE_WITHOUT_FACTS, new Serializable[]{OlapBuilderCubeValidator.getNullableString(cube.getName())});
        } else {
            ArrayList<IOlapBuilderMeasureDef> measures = new ArrayList<IOlapBuilderMeasureDef>();
            HashSet<String> groupMeasures = new HashSet<String>();
            for (IOlapBuilderBaseFactsDef factsDef : facts) {
                this.validateFact(context, schema, cube, factsDef, hasDefaultTimeDimension);
                measures.addAll(factsDef.getDefinedMeasures());
                if (groupMeasures.add(factsDef.getName())) continue;
                context.addError(OlapBuilderErrorCode.CUBE_FACT_MEASURE_GROUP_DUPLICATED, new Serializable[]{OlapBuilderCubeValidator.getNullableString(factsDef.getName())});
            }
            this.validateUniqueNames(context, measures, OlapBuilderErrorCode.CUBE_MEASURE_NAME_DUPLICATED);
        }
    }

    private void validateFact(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schema, IOlapBuilderCubeDef cube, IOlapBuilderBaseFactsDef factsDef, boolean hasDefaultTimeDimension) {
        OlapBuilderValidator factsValidator = (OlapBuilderValidator)factsDef.getValidator();
        factsValidator.validate(context, cube, factsDef);
    }
}

