/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderColorsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.colors.OlapBuilderColors;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderColorsValidator
extends OlapBuilderValidator<IOlapBuilderSchemaDef, IOlapBuilderColorsDef> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef, IOlapBuilderColorsDef colors) {
        if (!colors.isEnabled()) {
            return;
        }
        String dataTableId = colors.getDataTableId();
        if (CdStringUtils.isNullOrBlank((String)dataTableId)) {
            return;
        }
        IOlapBuilderTabularDataDef dataView = colors.getDataView();
        this.validateNotNullField(context, OlapBuilderColors.DATA_VIEW, dataView);
        if (dataView != null) {
            List<IOlapBuilderDataColumnDef> columns = dataView.getSelectedColumns();
            this.validateColumn(context, columns, "color", true);
            this.validateColumn(context, columns, "name", true);
            this.validateColumn(context, columns, "level", false);
            this.validateColumn(context, columns, "hierarchy", false);
            this.validateColumn(context, columns, "dimension", false);
        }
    }

    private void validateColumn(OlapBuilderValidationContext context, List<IOlapBuilderDataColumnDef> columns, String columnName, boolean mandatory) {
        OlapBuilderInputType type;
        IOlapBuilderDataColumnDef column = OlapBuilderColorsValidator.getColumn(columns, columnName);
        if (mandatory && column == null) {
            context.addError(OlapBuilderErrorCode.COLORS_COLUMN_MISSING, new Serializable[]{columnName});
        }
        if (column != null && (type = column.getType()) != OlapBuilderInputType.STRING) {
            context.addError(OlapBuilderErrorCode.COLORS_COLUMN_TYPE_MISMATCH, new Serializable[]{columnName});
        }
    }

    @Nullable
    private static IOlapBuilderDataColumnDef getColumn(List<IOlapBuilderDataColumnDef> columns, String name) {
        for (IOlapBuilderDataColumnDef column : columns) {
            if (!name.equalsIgnoreCase(column.getName())) continue;
            return column;
        }
        return null;
    }
}

