/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.property.CdProperty;
import crazydev.iccube.builder.datasource.csv.OlapBuilderCSVDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderBaseFileDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderDirectoryConnection;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderFileLineDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import java.io.Serializable;
import java.util.HashSet;

public class OlapBuilderCSVDataTableValidator
extends OlapBuilderFileLineDataTableValidator {
    @Override
    protected void validateColumnSeparator(OlapBuilderValidationContext context, OlapBuilderBaseFileDataTable myDataTable) {
    }

    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderDataSource<OlapBuilderDirectoryConnection> dataSource, IOlapBuilderDataTableDef<OlapBuilderDirectoryConnection> dataTable) {
        OlapBuilderCSVDataTable cvsDataTable = (OlapBuilderCSVDataTable)dataTable;
        boolean valid = true;
        valid &= this.checkSizeOne(context, OlapBuilderCSVDataTable.ESCAPE, cvsDataTable.getEscape());
        valid &= this.checkSizeOne(context, OlapBuilderCSVDataTable.QUOTE_CHAR, cvsDataTable.getQuotechar());
        valid &= this.checkSizeOne(context, OlapBuilderCSVDataTable.SEPARATOR, cvsDataTable.getCsvseparator());
        HashSet<String> names = new HashSet<String>();
        names.add(cvsDataTable.getEscape());
        if (!names.add(cvsDataTable.getQuotechar())) {
            valid = false;
            context.addError(OlapBuilderErrorCode.CSV_DATA_TABLE_SAME_FIELD, new Serializable[]{cvsDataTable.getQuotechar()});
        }
        if (!names.add(cvsDataTable.getCsvseparator())) {
            valid = false;
            context.addError(OlapBuilderErrorCode.CSV_DATA_TABLE_SAME_FIELD, new Serializable[]{cvsDataTable.getCsvseparator()});
        }
        if (valid) {
            super.doValidate(context, dataSource, dataTable);
        }
    }

    private boolean checkSizeOne(OlapBuilderValidationContext context, CdProperty field, String character) {
        if (character.isEmpty() || character.length() > 1) {
            context.addError(OlapBuilderErrorCode.CSV_DATA_TABLE_FIELD_ONE_CHARACTER, new Serializable[]{field.getName(), character});
            return false;
        }
        return true;
    }
}

