/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.enums.OlapIncrementalLoadStrategy;
import java.io.Serializable;

public class OlapBuilderBaseDataTableValidator<CONNECTION extends IOlapBuilderConnection, DATASOURCE extends IOlapBuilderDataSource<CONNECTION>>
extends OlapBuilderValidator<DATASOURCE, IOlapBuilderDataTableDef<CONNECTION>> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, DATASOURCE dataSource, IOlapBuilderDataTableDef<CONNECTION> dataTable) {
        OlapIncrementalLoadStrategy incrLoadStrategy;
        IOlapBuilderDataColumnDef column;
        String columnName;
        IOlapBuilderSchemaDef schemaDef;
        if (CdStringUtils.isNullOrBlank((String)dataTable.getId())) {
            context.addError(OlapBuilderErrorCode.TABLE_ID_IS_EMPTY, new Serializable[]{dataSource.getName()});
        }
        if (CdStringUtils.isNullOrBlank((String)dataTable.getName())) {
            context.addError(OlapBuilderBaseDataTable.NAME, OlapBuilderErrorCode.TABLE_NAME_IS_EMPTY, new Serializable[]{dataSource.getName()});
        }
        if ((schemaDef = context.getSchemaDef()) != null && schemaDef.activateIncrementalLoad()) {
            if (dataTable.getIncrementalLoadStrategy() == null) {
                context.addError(OlapBuilderBaseDataTable.INCREMENTAL_LOAD_STRATEGY, OlapBuilderErrorCode.TABLE_INCR_COLUMN_STRATEGY_MANDATORY, new Serializable[]{dataTable.getName()});
            }
            if (CdStringUtils.isNullOrBlank((String)(columnName = dataTable.getIncrementalLoadColumnName()))) {
                if (dataTable.getIncrementalLoadStrategy().needsIncrementalLoadColumn()) {
                    context.addError(OlapBuilderBaseDataTable.INCREMENTAL_LOAD_COLUMN_NAME, OlapBuilderErrorCode.TABLE_INCR_COLUMN_NULL, new Serializable[0]);
                }
            } else {
                column = dataTable.lookupSelectedColumn(columnName);
                if (column == null || !column.isSelected()) {
                    context.addError(OlapBuilderBaseDataTable.INCREMENTAL_LOAD_COLUMN_NAME, OlapBuilderErrorCode.TABLE_INCR_COLUMN_INVALID, new Serializable[]{columnName});
                }
            }
        }
        if (schemaDef != null && CdStringUtils.isNotNullAndNotBlank((String)(columnName = dataTable.getPartitioningColumnNameX()))) {
            if (!context.isTablePartitioningLicensed()) {
                context.addError(OlapBuilderErrorCode.TABLE_PARTITION_NOT_LICENSED, new Serializable[0]);
            }
            if ((column = dataTable.lookupSelectedColumn(columnName)) == null || !column.isSelected()) {
                context.addError(OlapBuilderBaseDataTable.PARTITIONING_COLUMN_NAME, OlapBuilderErrorCode.TABLE_PARTITION_COLUMN_INVALID, new Serializable[]{dataTable.getName(), columnName});
            }
        }
        if (schemaDef != null && CdStringUtils.isNotNullAndNotBlank((String)dataTable.getPartitioningColumnNameX()) && (incrLoadStrategy = dataTable.getIncrementalLoadStrategy()) != null) {
            switch (incrLoadStrategy) {
                case NO_UPDATE: {
                    break;
                }
                case INCREMENTAL: 
                case INCREMENTAL_TRIGGER: 
                case FULL_RELOAD: {
                    context.addError(OlapBuilderErrorCode.TABLE_PARTITIONING_WITH_INCR_LOAD, new Serializable[]{dataTable.getName(), incrLoadStrategy});
                }
            }
        }
    }
}

