/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderValidationEnabled;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class OlapBuilderBaseDataSourceValidator
extends OlapBuilderValidator<IOlapBuilderValidationEnabled, IOlapBuilderDataSource> {
    @Override
    protected final void doValidate(OlapBuilderValidationContext context, IOlapBuilderValidationEnabled model, IOlapBuilderDataSource dataSource) {
        if (!context.isValidatingDataSource()) {
            return;
        }
        this.doValidateFields(context, dataSource);
        this.doValidateTables(context, dataSource);
    }

    protected void doValidateFields(OlapBuilderValidationContext context, IOlapBuilderDataSource dataSource) {
        if (StringUtils.isBlank((CharSequence)dataSource.getName())) {
            context.addError(OlapBuilderErrorCode.DATASOURCE_NAME_EMPTY, new Serializable[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidateTables(OlapBuilderValidationContext context, IOlapBuilderDataSource dataSource) {
        OlapBuilderConnectionPool connectionPool = context.getConnectionPool();
        IOlapBuilderConnection connection = null;
        try {
            connection = (IOlapBuilderConnection)connectionPool.getOrCreateOpenedConnection(context.asRuntimeContext(), dataSource);
            connection.open(context.asRuntimeContext());
            this.validateChildren(context, dataSource, dataSource.getTables());
        }
        catch (OlapBuilderErrorException ex) {
            context.addError(ex.getError());
        }
        finally {
            connectionPool.releaseOpenedConnection(connection);
        }
    }
}

