/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.mdx.scanner.CdMdxNameValidator;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderAttributeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderValidationEnabled;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import java.io.Serializable;

public class OlapBuilderAttributeValidator<T extends IOlapBuilderValidationEnabled>
extends OlapBuilderValidator<T, IOlapBuilderAttributeDef> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, T level, IOlapBuilderAttributeDef property) {
        String propertyName = OlapBuilderAttributeValidator.getNullableString(property.getName());
        if (!CdMdxNameValidator.isValidAttributeName((String)property.getName()) || !CdMdxNameValidator.isValidPropertyName((String)property.getName())) {
            context.addError(OlapBuilderErrorCode.MEMBER_ATTRIBUTE_NAME_INVALID, new Serializable[]{propertyName});
        }
        if (context.isIntrinsicMemberProperty(property.getName())) {
            context.addError(OlapBuilderErrorCode.ATTRIBUTE_NAME_INTRINSIC_ONE, new Serializable[]{propertyName});
        }
        if (property.getAttributeColumn() == null) {
            context.addError(OlapBuilderErrorCode.MEMBER_ATTRIBUTE_VALUE_MANDATORY, new Serializable[]{propertyName});
        } else if (!this.containsColumn(property.getAttributeColumn())) {
            context.addError(OlapBuilderErrorCode.MEMBER_ATTRIBUTE_VALUE_MISSING, new Serializable[]{propertyName});
        }
    }
}

