/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.union;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderMultiTableDataViewLogic;
import crazydev.iccube.builder.model.impl.view.union.OlapBuilderUnionDataView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderUnionDataViewLogic
extends OlapBuilderMultiTableDataViewLogic<OlapBuilderUnionDataView> {
    private ConcurrentHashMap<IOlapBuilderTabularDataDef, IOlapBuilderDataColumnDef[]> columnMapper;

    public OlapBuilderUnionDataViewLogic(OlapBuilderUnionDataView view) {
        super(view);
    }

    @Override
    public List<IOlapBuilderDataColumnDef> doSetupSelectedColumns(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver) {
        List<IOlapBuilderTabularDataDef> underlyings = ((OlapBuilderUnionDataView)this.view).getDirectUnderlyings();
        LinkedHashMap<String, IOlapBuilderDataColumnDef> viewColumns = new LinkedHashMap<String, IOlapBuilderDataColumnDef>();
        for (int i = 0; i < underlyings.size(); ++i) {
            IOlapBuilderTabularDataDef table = underlyings.get(i);
            for (int j = 0; j < table.getSelectedColumns().size(); ++j) {
                IOlapBuilderDataColumnDef column = table.getSelectedColumns().get(j);
                IOlapBuilderDataColumnDef prevCol = (IOlapBuilderDataColumnDef)viewColumns.get(column.getName());
                if (prevCol == null) {
                    viewColumns.put(column.getName(), column.duplicateForView(null));
                    continue;
                }
                if (prevCol.getType() == column.getType()) continue;
                errorManager.addError(OlapBuilderErrorCode.DATA_VIEW_UNION_COL_MISMATCH, new Serializable[]{((OlapBuilderUnionDataView)this.view).getName(), table.getName(), column.getName(), prevCol.getType().toString(), column.getType().toString()});
            }
        }
        this.columnMapper = new ConcurrentHashMap();
        Collection viewCols = viewColumns.values();
        return new ArrayList<IOlapBuilderDataColumnDef>(viewCols);
    }

    @Override
    protected void onProcessingInit(OlapBuilderContext context) {
        super.onProcessingInit(context);
        this.columnMapper.clear();
    }

    @Override
    public void onTableProcessingStarted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        List<IOlapBuilderDataColumnDef> viewCols = ((OlapBuilderUnionDataView)this.view).getSelectedColumns();
        IOlapBuilderDataColumnDef[] conv = new IOlapBuilderDataColumnDef[viewCols.size()];
        this.columnMapper.put(tabularData, conv);
        for (int j = 0; j < viewCols.size(); ++j) {
            IOlapBuilderDataColumnDef viewCol = viewCols.get(j);
            conv[viewCol.getIndex()] = tabularData.lookupSelectedColumn(viewCol.getName());
        }
        super.onTableProcessingStarted(context, tabularData);
    }

    @Override
    public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, final IOlapBuilderTableRow row) {
        final IOlapBuilderDataColumnDef[] mapper = this.columnMapper.get(tabularData);
        return ((OlapBuilderUnionDataView)this.view).fireTableNewRow(context, originalTable, partition, rowNb, new IOlapBuilderTableRow(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            @Nullable
            public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
                if (!"VIEW".equals(columnDef.getTableType())) {
                    throw new CdShouldNotBeHereProgrammingException();
                }
                int index = columnDef.getIndex();
                IOlapBuilderDataColumnDef tableCol = mapper[index];
                return tableCol == null ? null : row.getJavaNativeDataValue(tableCol);
            }
        });
    }
}

