/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.rename;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.impl.view.rename.OlapBuilderRenameDataView;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.view.OlapBuilderBaseDataViewValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class OlapBuilderRenameDataViewValidator
extends OlapBuilderBaseDataViewValidator<OlapBuilderRenameDataView> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef, OlapBuilderRenameDataView view) {
        super.doValidate(context, schemaDef, view);
        List<String> names = view.getNewNames();
        HashSet<String> newNames = new HashSet<String>(names);
        List<IOlapBuilderDataColumnDef> columnsToRename = view.getColumnsDefs();
        if (newNames.size() != view.getNewNames().size()) {
            HashSet uniques = new HashSet();
            List duplicatedNames = view.getNewNames().stream().filter(e -> !uniques.add(e)).collect(Collectors.toList());
            context.addError(OlapBuilderRenameDataView.NEW_NAMES, OlapBuilderErrorCode.RENAME_VIEW_NEW_NAMES_NOT_UNIQUE, new Serializable[]{duplicatedNames.toString()});
        }
        List<IOlapBuilderDataColumnDef> underlyingColumns = view.getDirectUnderlying().getSelectedColumns();
        ArrayList<IOlapBuilderDataColumnDef> notChangingColumns = new ArrayList<IOlapBuilderDataColumnDef>(underlyingColumns);
        notChangingColumns.removeAll(columnsToRename);
        Set notChangingNames = notChangingColumns.stream().map(IOlapBuilderNamedDef::getName).collect(Collectors.toSet());
        newNames.removeIf(name -> !notChangingNames.contains(name));
        if (!newNames.isEmpty()) {
            context.addError(OlapBuilderErrorCode.RENAME_VIEW_NAME_COL, new Serializable[]{((Object)newNames).toString()});
        }
    }
}

