/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.parentchildsort.sort;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.impl.view.parentchildsort.sort.OlapBuilderParentChildSortDataView;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.view.OlapBuilderBaseDataViewValidator;
import java.io.Serializable;

public class OlapBuilderParentChildSortDataViewValidator
extends OlapBuilderBaseDataViewValidator<OlapBuilderParentChildSortDataView> {
    private final IOlapBuilderDataColumnDef childColumnDef;
    private final IOlapBuilderDataColumnDef parentColumnDef;

    public OlapBuilderParentChildSortDataViewValidator(IOlapBuilderDataColumnDef childColumnDef, IOlapBuilderDataColumnDef parentColumnDef) {
        this.childColumnDef = childColumnDef;
        this.parentColumnDef = parentColumnDef;
    }

    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef, OlapBuilderParentChildSortDataView view) {
        super.doValidate(context, schemaDef, view);
        if (this.childColumnDef.getType() != this.parentColumnDef.getType()) {
            context.addError(OlapBuilderParentChildSortDataView.CHILD_COL_REF, OlapBuilderErrorCode.DATA_VIEW_SORT_PARENTCHILD_TYPE_MISMATCH, new Serializable[]{this.childColumnDef.getName(), this.childColumnDef.getType().toString(), this.parentColumnDef.getName(), this.parentColumnDef.getType().toString()});
        } else {
            String missingParentId = view.getMissingParentId();
            if (!CdStringUtils.isNullOrBlank((String)missingParentId)) {
                try {
                    this.childColumnDef.getType().toScalarEntity(missingParentId);
                }
                catch (Exception ex) {
                    context.addError(OlapBuilderParentChildSortDataView.CHILD_COL_REF, OlapBuilderErrorCode.DATA_VIEW_SORT_PARENTCHILD_MISSING_MISMATCH, new Serializable[]{missingParentId, ex});
                }
            }
        }
    }
}

