/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.parentchildsort.sort;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataTableRow;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.view.parentchildsort.sort.OlapBuilderParentChildSortDataView;
import crazydev.iccube.builder.model.impl.view.sort.OlapBuilderBaseSortDataViewLogic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderParentChildSortDataViewLogic
extends OlapBuilderBaseSortDataViewLogic<OlapBuilderParentChildSortDataView> {
    private IOlapBuilderDataColumnDef childColDef;
    private IOlapBuilderDataColumnDef parentColDef;
    private String viewMissingParentId;
    private boolean desOrder;
    private String viewName;

    OlapBuilderParentChildSortDataViewLogic(OlapBuilderParentChildSortDataView view) {
        super(view);
    }

    public OlapBuilderParentChildSortDataViewLogic(String viewName, IOlapBuilderDataColumnDef childColDef, IOlapBuilderDataColumnDef parentColDef, String viewMissingParentId, boolean desOrder) {
        super(null);
        this.viewName = viewName;
        this.childColDef = childColDef;
        this.parentColDef = parentColDef;
        this.viewMissingParentId = viewMissingParentId;
        this.desOrder = desOrder;
    }

    @Override
    public List<IOlapBuilderDataColumnDef> doSetupSelectedColumns(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver) {
        List<IOlapBuilderDataColumnDef> selected = this.getSelectedColumnsFromUnderlying();
        OlapBuilderDataColumnRef childColRef = ((OlapBuilderParentChildSortDataView)this.view).getChildColRef();
        OlapBuilderDataColumnRef parentColRef = ((OlapBuilderParentChildSortDataView)this.view).getParentColRef();
        if (childColRef == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"Parent/Child View, child column is empty "});
        }
        if (parentColRef == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"Parent/Child View, parent column is empty"});
        }
        this.childColDef = OlapBuilderDataColumn.lookupColumn(selected, childColRef.getName());
        this.parentColDef = OlapBuilderDataColumn.lookupColumn(selected, parentColRef.getName());
        this.viewMissingParentId = ((OlapBuilderParentChildSortDataView)this.view).getMissingParentId();
        this.desOrder = ((OlapBuilderParentChildSortDataView)this.view).getDesOrder();
        this.viewName = ((OlapBuilderParentChildSortDataView)this.view).getName();
        return selected;
    }

    @Override
    protected List<OlapBuilderBufferDataTableRow> sort(List<OlapBuilderBufferDataTableRow> bufferTableRows) {
        return this.sortAsParenChild(bufferTableRows, key -> false);
    }

    public List<OlapBuilderBufferDataTableRow> sortAsParenChild(List<OlapBuilderBufferDataTableRow> bufferTableRows, Predicate<Comparable> existing) {
        return this.sortAsParenChild(bufferTableRows, existing, false);
    }

    private List<OlapBuilderBufferDataTableRow> sortAsParenChild(List<OlapBuilderBufferDataTableRow> bufferTableRows, Predicate<Comparable> existing, boolean changedMissing) {
        IOlapBuilderDataColumnDef idCol = this.childColDef;
        IOlapBuilderDataColumnDef parentIdCol = this.parentColDef;
        Comparable missingParentId = null;
        if (!CdStringUtils.isNullOrBlank((String)this.viewMissingParentId)) {
            missingParentId = idCol.getType().toJavaNativeValue("n/a", ((OlapBuilderParentChildSortDataView)this.view).getMissingParentId());
        }
        ArrayList<OlapBuilderBufferDataTableRow> allRows = new ArrayList<OlapBuilderBufferDataTableRow>();
        ArrayList<OlapBuilderBufferDataTableRow> root = new ArrayList<OlapBuilderBufferDataTableRow>();
        Iterator<OlapBuilderBufferDataTableRow> iter = bufferTableRows.iterator();
        while (iter.hasNext()) {
            OlapBuilderBufferDataTableRow row = iter.next();
            Comparable parentId = row.getJavaNativeDataValue(parentIdCol);
            if (parentId != null && !existing.test(parentId) && !parentId.equals(row.getJavaNativeDataValue(idCol))) continue;
            root.add(row);
            iter.remove();
        }
        if (root.isEmpty()) {
            String missingIds = this.logMissingParentId(bufferTableRows, idCol, parentIdCol);
            missingIds = missingIds.length() < 100 ? missingIds : missingIds.substring(0, 99) + "...";
            throw new OlapBuilderErrorException(new OlapBuilderError(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"Parent/Child '" + this.viewName + "' : Could not solve the following parentIds : " + missingIds}));
        }
        List<IOlapBuilderDataColumnDef> sortingCols = Collections.singletonList(idCol);
        OlapBuilderParentChildSortDataViewLogic.sortColumns(root, sortingCols, this.desOrder);
        allRows.addAll(root);
        ArrayList<OlapBuilderBufferDataTableRow> currentParents = root;
        while (true) {
            ArrayList<OlapBuilderBufferDataTableRow> currentLevel = new ArrayList<OlapBuilderBufferDataTableRow>();
            iter = bufferTableRows.iterator();
            while (iter.hasNext()) {
                OlapBuilderBufferDataTableRow row = iter.next();
                Comparable lookupParentId = row.getJavaNativeDataValue(parentIdCol);
                if (!this.isIn(currentParents, idCol, lookupParentId)) continue;
                currentLevel.add(row);
                iter.remove();
            }
            OlapBuilderParentChildSortDataViewLogic.sortColumns(currentLevel, sortingCols, this.desOrder);
            allRows.addAll(currentLevel);
            if (bufferTableRows.isEmpty()) break;
            if (currentLevel.isEmpty()) {
                if (missingParentId != null && !changedMissing) {
                    return this.handleMissing(parentIdCol, missingParentId, bufferTableRows, allRows);
                }
                OlapBuilderError error = new OlapBuilderError(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"Parent/Child '" + this.viewName + "' with a list of unsolved parentId's [" + this.forError(bufferTableRows, parentIdCol) + "]."});
                throw new OlapBuilderErrorException(error);
            }
            currentParents = currentLevel;
        }
        return allRows;
    }

    private String logMissingParentId(List<OlapBuilderBufferDataTableRow> bufferTableRows, IOlapBuilderDataColumnDef idCol, IOlapBuilderDataColumnDef parentIdCol) {
        HashSet<Comparable> idS = new HashSet<Comparable>();
        HashSet<Comparable> parentS = new HashSet<Comparable>();
        for (OlapBuilderBufferDataTableRow row : bufferTableRows) {
            idS.add(row.getJavaNativeDataValue(idCol));
            parentS.add(row.getJavaNativeDataValue(parentIdCol));
        }
        parentS.removeAll(idS);
        return parentS.stream().sorted().limit(50L).map(Object::toString).collect(Collectors.joining(", "));
    }

    private List<OlapBuilderBufferDataTableRow> handleMissing(IOlapBuilderDataColumnDef parentIdCol, Comparable missingParentId, List<OlapBuilderBufferDataTableRow> bufferTableRows, List<OlapBuilderBufferDataTableRow> allRows) {
        for (int i = 0; i < bufferTableRows.size(); ++i) {
            OlapBuilderBufferDataTableRow row = bufferTableRows.get(i);
            row.put(parentIdCol, missingParentId);
        }
        bufferTableRows.addAll(allRows);
        return this.sortAsParenChild(bufferTableRows, v -> false, true);
    }

    private String forError(List<OlapBuilderBufferDataTableRow> bufferTableRows, IOlapBuilderDataColumnDef parentIdCol) {
        boolean overflow = false;
        TreeSet<Comparable> values = new TreeSet<Comparable>();
        for (int i = 0; i < bufferTableRows.size(); ++i) {
            values.add(bufferTableRows.get(i).getJavaNativeDataValue(parentIdCol));
            if (values.size() != 10) continue;
            overflow = true;
            break;
        }
        int count = 0;
        StringBuilder builder = new StringBuilder();
        for (Comparable value : values) {
            if (count++ != 0) {
                builder.append(", ");
            }
            builder.append(value);
        }
        if (overflow) {
            builder.append(", ...");
        }
        return builder.toString();
    }

    private boolean isIn(List<OlapBuilderBufferDataTableRow> parentRows, IOlapBuilderDataColumnDef idCols, @Nullable Comparable lookupParentId) {
        if (lookupParentId != null) {
            for (int i = 0; i < parentRows.size(); ++i) {
                OlapBuilderBufferDataTableRow parentRow = parentRows.get(i);
                if (!lookupParentId.equals(parentRow.getJavaNativeDataValue(idCols))) continue;
                return true;
            }
        }
        return false;
    }
}

