/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.javasimple;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.pub.view.IOlapColumnDef;
import crazydev.iccube.pub.view.IOlapDataTableDef;
import crazydev.iccube.pub.view.IOlapReadOnlyDataRow;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class OlapBuilderPassthroughRow
implements IOlapReadOnlyDataRow {
    private final Map<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef> mapViewToUnderlying;
    private final Map<String, IOlapBuilderDataColumnDef> mapUnderlyingRowName;
    private final IOlapBuilderTableRow row;
    private final int rowNb;
    private IOlapDataTableDef table;

    public OlapBuilderPassthroughRow(IOlapBuilderTabularDataDef table, Map<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef> mapViewToUnderlying, Map<String, IOlapBuilderDataColumnDef> mapUnderlyingRowName, IOlapBuilderTableRow row, int rowNb) {
        this.mapViewToUnderlying = mapViewToUnderlying;
        this.mapUnderlyingRowName = mapUnderlyingRowName;
        this.row = row;
        this.rowNb = rowNb;
        this.table = new DataWrapper(table);
    }

    @Override
    public Comparable get(String columnName) {
        IOlapBuilderDataColumnDef underlyingCol = this.getColumnDef(columnName);
        return this.row.getJavaNativeDataValue(underlyingCol);
    }

    @Override
    public IOlapDataTableDef getTableDef() {
        return this.table;
    }

    @Override
    public Comparable get(IOlapColumnDef iColumn) {
        IOlapBuilderDataColumnDef viewCol = (IOlapBuilderDataColumnDef)iColumn;
        IOlapBuilderDataColumnDef columnDef = this.mapViewToUnderlying.get(viewCol);
        columnDef = columnDef != null ? columnDef : this.mapUnderlyingRowName.get(iColumn.getName());
        return columnDef == null ? null : this.row.getJavaNativeDataValue(columnDef);
    }

    @NotNull
    private IOlapBuilderDataColumnDef getColumnDef(String columnName) {
        IOlapBuilderDataColumnDef underlyingCol = this.mapUnderlyingRowName.get(columnName);
        if (underlyingCol == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.JAVA_INTERFACE_ERROR, new Serializable[]{"When evaluating a user java code in a view, unknown column name '" + columnName + " in table/view '" + this.table.getName() + "'"});
        }
        return underlyingCol;
    }

    public static class DataWrapper
    implements IOlapDataTableDef {
        private final IOlapBuilderTabularDataDef tabularDataDef;

        public DataWrapper(IOlapBuilderTabularDataDef tabularDataDef) {
            this.tabularDataDef = tabularDataDef;
        }

        @Override
        public String getName() {
            return this.tabularDataDef.getName();
        }

        @Override
        public List<? extends IOlapColumnDef> getColumns() {
            return this.tabularDataDef.getSelectedColumns();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataWrapper that = (DataWrapper)o;
            return Objects.equals(this.tabularDataDef, that.tabularDataDef);
        }

        public int hashCode() {
            return Objects.hash(this.tabularDataDef);
        }
    }
}

