/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.javascript.tablecache;

import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderCacheMissingRowWrapper;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderCacheRowWrapper;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderCacheTableWrapper;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderTableCache;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.pub.view.IOlapCachedTable;
import crazydev.iccube.pub.view.IOlapCachedTableRow;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderTableCacheIndex {
    private final Map<List<Object>, Object> mapValuesColIdx = new HashMap<List<Object>, Object>();
    private final OlapBuilderTableCache tableCache;
    private final List<String> colNames;

    public OlapBuilderTableCacheIndex(OlapBuilderTableCache tableCache, List<String> colNames) {
        int i;
        this.tableCache = tableCache;
        this.colNames = colNames;
        int numValues = 0;
        ArrayList<OlapScalarEntityFactColumn> colValues = new ArrayList<OlapScalarEntityFactColumn>();
        for (i = 0; i < colNames.size(); ++i) {
            int colIdx = tableCache.getExistingColumnIndex(colNames.get(i));
            OlapScalarEntityFactColumn dataColumn = tableCache.getDataColumn(colIdx);
            colValues.add(dataColumn);
            numValues = numValues != 0 ? numValues : dataColumn.size();
        }
        for (i = 0; i < numValues; ++i) {
            ArrayList<Comparable> key = new ArrayList<Comparable>(colNames.size());
            for (int j = 0; j < colValues.size(); ++j) {
                OlapScalarEntityFactColumn dataColumn = (OlapScalarEntityFactColumn)colValues.get(j);
                key.add(dataColumn.getValueAsObject(i));
            }
            Object lookupIdx = this.mapValuesColIdx.get(key);
            if (lookupIdx == null) {
                this.mapValuesColIdx.put(key, i);
                continue;
            }
            if (lookupIdx instanceof IntArrayList) {
                IntArrayList arrayList = (IntArrayList)lookupIdx;
                arrayList.add(i);
                continue;
            }
            IntArrayList arrayList = new IntArrayList(2);
            arrayList.add(((Integer)lookupIdx).intValue());
            arrayList.add(i);
            this.mapValuesColIdx.put(key, arrayList);
        }
    }

    @Nullable
    public Comparable lookupValue(List<Object> lookupValues, String columnName) {
        int first;
        int idx = this.tableCache.getExistingColumnIndex(columnName);
        Object rowList = this.mapValuesColIdx.get(lookupValues);
        if (rowList == null) {
            return null;
        }
        if (rowList instanceof IntArrayList) {
            IntArrayList list = (IntArrayList)rowList;
            first = list.getInt(0);
        } else {
            first = (Integer)rowList;
        }
        OlapScalarEntityFactColumn dataColumn = this.tableCache.getDataColumn(idx);
        return dataColumn.getValueAsObject(first);
    }

    public Stream<OlapBuilderCacheRowWrapper> stream(OlapBuilderCacheTableWrapper tableWrapper, List<Object> lookupValues) {
        Object rowList = this.mapValuesColIdx.get(lookupValues);
        return this.stream(tableWrapper, rowList);
    }

    @NotNull
    Stream<OlapBuilderCacheRowWrapper> stream(final OlapBuilderCacheTableWrapper tableWrapper, final Object rowList) {
        Iterator<OlapBuilderCacheRowWrapper> iterable = new Iterator<OlapBuilderCacheRowWrapper>(){
            final IntArrayList list;
            final int size;
            int currRowIdx;
            {
                Objects.requireNonNull(this$0);
                this.list = rowList instanceof IntArrayList ? (IntArrayList)rowList : null;
                this.size = this.list == null ? 1 : this.list.size();
                this.currRowIdx = -1;
            }

            @Override
            public boolean hasNext() {
                return rowList != null && this.currRowIdx < this.size && ++this.currRowIdx < this.size;
            }

            @Override
            public OlapBuilderCacheRowWrapper next() {
                Integer rowIdx = this.list == null ? (Integer)rowList : Integer.valueOf(this.list.getInt(this.currRowIdx));
                return tableWrapper.row(rowIdx);
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterable, 0), false);
    }

    public IOlapCachedTableRow firstMatching(OlapBuilderCacheTableWrapper tableWrapper, List<Object> lookupValues) {
        int first;
        Object rowList = this.mapValuesColIdx.get(lookupValues);
        if (rowList == null) {
            return new OlapBuilderCacheMissingRowWrapper(tableWrapper);
        }
        if (rowList instanceof IntArrayList) {
            IntArrayList list = (IntArrayList)rowList;
            first = list.getInt(0);
        } else {
            first = (Integer)rowList;
        }
        return new OlapBuilderCacheRowWrapper(tableWrapper, first);
    }

    public IOlapCachedTable groupBy(String[] groupByColumns, String[] aggregationColumns, String[] aggregationTypes) {
        ArrayList<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>();
        ArrayList<OlapScalarEntityFactColumn> values = new ArrayList<OlapScalarEntityFactColumn>();
        Stream.concat(Arrays.stream(groupByColumns), Arrays.stream(aggregationColumns)).forEach(columnName -> columns.add(this.tableCache.getExistingColumn((String)columnName)));
        columns.forEach(column -> values.add(this.tableCache.createColumn((IOlapBuilderDataColumnDef)column)));
        List aggregations = Arrays.stream(aggregationTypes).map(name -> OlapAggregationType.valueOf(name)).collect(Collectors.toList());
        for (Map.Entry<List<Object>, Object> entry : this.mapValuesColIdx.entrySet()) {
            for (int i = 0; i < entry.getKey().size(); ++i) {
                Object groupByValue = entry.getKey().get(i);
                values.get(i).addNewValue(groupByValue);
            }
            Object rowList = entry.getValue();
            for (int j = 0; j < aggregationColumns.length; ++j) {
                Object val = this.aggregate(rowList, aggregationColumns[j], (OlapAggregationType)((Object)aggregations.get(j)));
                values.get(groupByColumns.length + j).addNewValue(val);
            }
        }
        OlapBuilderTableCache table = new OlapBuilderTableCache(this.tableCache.context(), columns, values, this.tableCache.getTableName() + " - GroupBy on " + Arrays.toString(groupByColumns));
        return new OlapBuilderCacheTableWrapper(table);
    }

    @Nullable
    Object aggregate(@Nullable Object rowList, String aggregationColumn, OlapAggregationType aggregationType) {
        if (rowList == null) {
            return null;
        }
        if (rowList instanceof IntArrayList) {
            return this.tableCache.aggregate(aggregationColumn, aggregationType, (IntArrayList)rowList);
        }
        return this.tableCache.aggregate(aggregationColumn, aggregationType, (Integer)rowList);
    }

    int count(@Nullable Object rowList) {
        if (rowList == null) {
            return 0;
        }
        if (rowList instanceof IntArrayList) {
            return ((IntArrayList)rowList).size();
        }
        return 1;
    }

    public Object[][] distinct() {
        if (this.colNames.size() == 1) {
            Object[] values = this.mapValuesColIdx.keySet().stream().map(list -> list.get(0)).collect(Collectors.toList()).toArray();
            return new Object[][]{values};
        }
        Object[][] values = (Object[][])this.mapValuesColIdx.keySet().stream().map(list -> list.toArray(new Object[list.size()])).collect(Collectors.toList()).toArray((T[])new Object[0][]);
        return values;
    }

    @Nullable
    public Object rows(List<Object> values) {
        return this.mapValuesColIdx.get(values);
    }
}

