/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.java;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseLanguageDataViewLogic;
import crazydev.iccube.builder.model.impl.view.java.OlapBuilderJavaDataView;
import crazydev.iccube.builder.model.impl.view.javascript.tablecache.OlapBuilderTableCache;
import crazydev.iccube.builder.model.impl.view.javasimple.OlapBuilderPassthroughRow;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.view.IOlapBuilderViewLogic;
import crazydev.iccube.pub.view.IOlapCachedTable;
import crazydev.iccube.pub.view.IOlapColumnDef;
import crazydev.iccube.pub.view.IOlapDataTableDef;
import crazydev.iccube.pub.view.IOlapDataTableRow;
import crazydev.iccube.pub.view.IOlapReadOnlyDataRow;
import crazydev.iccube.pub.view.IOlapViewContext;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class OlapBuilderJavaDataViewLogic
extends OlapBuilderBaseLanguageDataViewLogic<OlapBuilderJavaDataView> {
    private IOlapBuilderViewLogic logicWrapper;
    private DataWrapper mainTableWrapper;
    private IOlapBuilderTabularDataDef originalTable;
    private AtomicInteger rowNumber = new AtomicInteger(0);
    private Object LOCK = new Object();
    private boolean defaultOnNewCachedRow;

    public OlapBuilderJavaDataViewLogic(OlapBuilderJavaDataView view) {
        super(view);
    }

    @Override
    protected void assertAvailable(OlapBuilderContext context) {
        context.assertJavaViewActivated();
    }

    @Override
    protected void onProcessingInit(OlapBuilderContext context) {
        super.onProcessingInit(context);
        this.logicWrapper = null;
        try {
            this.logicWrapper = (IOlapBuilderViewLogic)((OlapBuilderJavaDataView)this.view).getOrCreateInstance();
            try {
                Class<?> methodDeclaringClass = this.logicWrapper.getClass().getMethod("onNewCachedRow", IOlapDataTableDef.class, IOlapReadOnlyDataRow.class).getDeclaringClass();
                this.defaultOnNewCachedRow = methodDeclaringClass == IOlapBuilderViewLogic.class;
            }
            catch (Exception ex) {
                this.defaultOnNewCachedRow = false;
            }
        }
        catch (Exception ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.JAVA_VIEW_ERROR, new Serializable[]{((OlapBuilderJavaDataView)this.view).getName(), ex});
        }
    }

    @Override
    protected void onInitMainTable(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        super.onInitMainTable(context, tabularData);
        this.mainTableWrapper = new DataWrapper(tabularData);
        this.logicWrapper.onInitMainTable(this.getCachedTables(), this.mainTableWrapper);
    }

    @Override
    protected void onNewRowForCache(OlapBuilderTableCache cacheTable, IOlapBuilderTableRow row, int rowNb) {
        if (this.defaultOnNewCachedRow || this.logicWrapper.onNewCachedRow(cacheTable.getTableDef(), new RowWrapper(cacheTable, row))) {
            cacheTable.onNewRow(rowNb, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean onMainTableNewRowNotSynchronized(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        this.originalTable = originalTable;
        Map<String, IOlapCachedTable> cachedTables = this.getCachedTables();
        if (this.simultaneousRows() && this.logicWrapper.synchronizeOnRow()) {
            Object object = this.LOCK;
            synchronized (object) {
                return this.logicWrapper.onNewRow(new Context(this, context), cachedTables, this.mainTableWrapper, new OlapBuilderPassthroughRow(tabularData, this.mapViewToUnderlying, this.mapUnderlyingRows, data, rowNb));
            }
        }
        return this.logicWrapper.onNewRow(new Context(this, context), cachedTables, this.mainTableWrapper, new OlapBuilderPassthroughRow(tabularData, this.mapViewToUnderlying, this.mapUnderlyingRows, data, rowNb));
    }

    @Override
    protected void onMainTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        Map<String, IOlapCachedTable> cachedTables = this.getCachedTables();
        this.logicWrapper.onProcessingCompleted(new Context(this, context){
            {
                Objects.requireNonNull(this$0);
                super(this$0, context);
            }

            @Override
            public void fireRow(IOlapReadOnlyDataRow row) {
                if (row instanceof OlapBuilderPassthroughRow) {
                    throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"A row from an underlying table stream can no be fired during onMainTableProcessingCompleted (unsafe status)"});
                }
                super.fireRow(row);
            }
        }, cachedTables);
        this.logicWrapper = null;
        ((OlapBuilderJavaDataView)this.view).destroyInstance();
    }

    @Override
    protected void clearCache() {
        super.clearCache();
        this.logicWrapper = null;
        ((OlapBuilderJavaDataView)this.view).destroyInstance();
    }

    public String toString() {
        return ((OlapBuilderJavaDataView)this.view).toString();
    }

    public static class DataWrapper
    implements IOlapDataTableDef {
        private final IOlapBuilderTabularDataDef tabularDataDef;

        public DataWrapper(IOlapBuilderTabularDataDef tabularDataDef) {
            this.tabularDataDef = tabularDataDef;
        }

        @Override
        public String getName() {
            return this.tabularDataDef.getName();
        }

        @Override
        public List<? extends IOlapColumnDef> getColumns() {
            return this.tabularDataDef.getSelectedColumns();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataWrapper that = (DataWrapper)o;
            return Objects.equals(this.tabularDataDef, that.tabularDataDef);
        }

        public int hashCode() {
            return Objects.hash(this.tabularDataDef);
        }
    }

    private static class RowWrapper
    implements IOlapReadOnlyDataRow {
        private final OlapBuilderTableCache cacheTable;
        private final IOlapBuilderTableRow row;

        RowWrapper(OlapBuilderTableCache cacheTable, IOlapBuilderTableRow row) {
            this.cacheTable = cacheTable;
            this.row = row;
        }

        @Override
        public IOlapDataTableDef getTableDef() {
            return this.cacheTable.getTableDef();
        }

        @Override
        public Comparable get(IOlapColumnDef columnDef) {
            return this.row.getJavaNativeDataValue((IOlapBuilderDataColumnDef)columnDef);
        }

        @Override
        public Comparable get(String columnName) {
            return this.get(this.cacheTable.getExistingColumn(columnName));
        }
    }

    protected class Context
    implements IOlapViewContext {
        private final OlapBuilderContext context;
        IOlapReadOnlyDataRow formerRow;
        final /* synthetic */ OlapBuilderJavaDataViewLogic this$0;

        public Context(OlapBuilderJavaDataViewLogic this$0, OlapBuilderContext context) {
            OlapBuilderJavaDataViewLogic olapBuilderJavaDataViewLogic = this$0;
            Objects.requireNonNull(olapBuilderJavaDataViewLogic);
            this.this$0 = olapBuilderJavaDataViewLogic;
            this.formerRow = null;
            this.context = context;
        }

        @Override
        public Logger getLogger() {
            return OlapLoggers.BUILDER_VIEW_JAVA;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addColumn(String columnName, Class columnType, String columnDescription) {
            Object object = this.this$0.LOCK;
            synchronized (object) {
                ((OlapBuilderJavaDataView)this.this$0.view).addColumn(columnName, columnType, columnDescription, false);
                this.this$0.refreshColumnCache();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addColumn(String columnName, Class columnType, String columnDescription, boolean isArray) {
            Object object = this.this$0.LOCK;
            synchronized (object) {
                ((OlapBuilderJavaDataView)this.this$0.view).addColumn(columnName, columnType, columnDescription, isArray);
                this.this$0.refreshColumnCache();
            }
        }

        @Override
        public void fireRow(IOlapReadOnlyDataRow row) {
            if (row == null) {
                return;
            }
            if (this.formerRow == row) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"The same row can not be fired more than once -> context.fireRow(). Please create a new one after each fireRow -> e.g. with context.newRow or copyRow"});
            }
            ((OlapBuilderJavaDataView)this.this$0.view).fireTableNewRow(this.context, this.this$0.originalTable, null, this.this$0.rowNumber.getAndIncrement(), row::get);
            this.formerRow = row;
        }

        @Override
        public IOlapDataTableRow newRow() {
            return this.this$0.emptyRow();
        }

        @Override
        public IOlapDataTableRow copyRow(IOlapReadOnlyDataRow row) {
            return this.this$0.copyRow(row);
        }
    }
}

