/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.groupby;

import crazydev.common.collection.CdComparableArray;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataTableRow;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderSingleTableDataViewLogic;
import crazydev.iccube.builder.model.impl.view.groupby.Aggregator;
import crazydev.iccube.builder.model.impl.view.groupby.Aggregators;
import crazydev.iccube.builder.model.impl.view.groupby.OlapBuilderGroupByDataView;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OlapBuilderGroupByDataViewLogic
extends OlapBuilderSingleTableDataViewLogic<OlapBuilderGroupByDataView> {
    public static final Logger LOGGER = OlapLoggers.BUILDER_VIEW_GROUP_BY;
    private final Object LOCK = new Object();
    private int rowNum;
    private Map<CdComparableArray, List<Aggregator>> bufferTableRows;
    private List<IOlapBuilderDataColumnDef> groupByTCols;
    private List<IOlapBuilderDataColumnDef> aggregateTCols;
    private List<IOlapBuilderDataColumnDef> groupByVCols;
    private List<IOlapBuilderDataColumnDef> aggregateVCols;
    private List<Aggregators.AggregateFunction> aggregateFunctions;
    private CdComparableArray currenkKeyValue;

    OlapBuilderGroupByDataViewLogic(OlapBuilderGroupByDataView view) {
        super(view);
    }

    @Override
    public List<IOlapBuilderDataColumnDef> doSetupSelectedColumns(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver) {
        this.aggregateFunctions = new ArrayList<Aggregators.AggregateFunction>();
        this.groupByTCols = new ArrayList<IOlapBuilderDataColumnDef>();
        this.aggregateTCols = new ArrayList<IOlapBuilderDataColumnDef>();
        this.groupByVCols = new ArrayList<IOlapBuilderDataColumnDef>();
        this.aggregateVCols = new ArrayList<IOlapBuilderDataColumnDef>();
        IOlapBuilderTabularDataDef underlying = ((OlapBuilderGroupByDataView)this.view).getDirectUnderlying();
        if (underlying == null) {
            return new ArrayList<IOlapBuilderDataColumnDef>();
        }
        ArrayList<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>();
        for (IOlapBuilderDataColumnDef tCol : ((OlapBuilderGroupByDataView)this.view).getGroupByColDefs()) {
            OlapBuilderDataColumn vCol = this.newColumn(tCol);
            columns.add(vCol);
            this.groupByTCols.add(tCol);
            this.groupByVCols.add(vCol);
        }
        Function<Integer, Aggregators.AggregateFunction> aggregateF = ((OlapBuilderGroupByDataView)this.view).getAggregateFunctions();
        for (int i = 0; i < ((OlapBuilderGroupByDataView)this.view).getAggreColDefs().size(); ++i) {
            IOlapBuilderDataColumnDef tCol = ((OlapBuilderGroupByDataView)this.view).getAggreColDefs().get(i);
            Aggregators.AggregateFunction aggregateFunction = aggregateF.apply(i);
            OlapBuilderDataColumn vCol = this.newAggregateColumn(tCol, aggregateFunction);
            columns.add(vCol);
            this.aggregateTCols.add(tCol);
            this.aggregateVCols.add(vCol);
            this.aggregateFunctions.add(aggregateFunction);
        }
        return columns;
    }

    private OlapBuilderDataColumn newColumn(IOlapBuilderDataColumnDef t) {
        return new OlapBuilderDataColumn(t.getType(), t.getTableType(), t.getName());
    }

    private OlapBuilderDataColumn newAggregateColumn(IOlapBuilderDataColumnDef t, Aggregators.AggregateFunction aggregateFunction) {
        boolean isArray;
        OlapBuilderInputType type;
        String name;
        if (aggregateFunction != Aggregators.AggregateFunction.DEFAULT && aggregateFunction != null) {
            name = aggregateFunction.nameForColumn(t.getName());
            type = aggregateFunction.getType(t.getType());
            isArray = aggregateFunction.isArray();
        } else {
            name = t.getName();
            type = t.getType();
            isArray = false;
        }
        OlapBuilderDataColumn column = new OlapBuilderDataColumn(type, t.getType().getName(), name, isArray);
        return column;
    }

    @Override
    public void onProcessingInit(OlapBuilderContext context) {
        this.bufferTableRows = new HashMap<CdComparableArray, List<Aggregator>>();
        this.rowNum = 0;
        this.currenkKeyValue = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        if (partition != null) {
            throw new RuntimeException("internal error: unexpected partition");
        }
        Object object = this.LOCK;
        synchronized (object) {
            CdComparableArray newKeyValue = this.getKeyValues(data);
            if (((OlapBuilderGroupByDataView)this.view).isUnderlinyTableKeySorted() && this.currenkKeyValue != null && !this.currenkKeyValue.equals((Object)newKeyValue)) {
                this.processBuffer(context);
            }
            this.addRowDataToCache(data, newKeyValue);
            this.currenkKeyValue = newKeyValue;
        }
        return true;
    }

    private void processBuffer(OlapBuilderContext context) {
        if (this.bufferTableRows.isEmpty()) {
            return;
        }
        for (Map.Entry<CdComparableArray, List<Aggregator>> entry : this.bufferTableRows.entrySet()) {
            IOlapBuilderDataColumnDef vCol;
            int i;
            CdComparableArray keys = entry.getKey();
            List<Aggregator> aggregators = entry.getValue();
            OlapBuilderBufferDataTableRow rowData = new OlapBuilderBufferDataTableRow(this.groupByTCols.size() + this.aggregateTCols.size());
            for (i = 0; i < this.groupByVCols.size(); ++i) {
                vCol = this.groupByVCols.get(i);
                rowData.put(vCol, keys.get(i));
            }
            for (i = 0; i < this.aggregateVCols.size(); ++i) {
                vCol = this.aggregateVCols.get(i);
                Comparable value = aggregators.get(i).value();
                Comparable val = value == null || vCol.isArray() ? value : vCol.getType().toJavaNativeValue(vCol.getName(), value);
                rowData.put(vCol, val);
            }
            ++this.rowNum;
            aggregators.clear();
            if (((OlapBuilderGroupByDataView)this.view).fireTableNewRow(context, ((OlapBuilderGroupByDataView)this.view).getDirectUnderlying(), null, this.rowNum - 1, rowData)) continue;
            return;
        }
        this.bufferTableRows.clear();
    }

    @Override
    public void onTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        this.processBuffer(context);
        this.bufferTableRows = null;
        super.onTableProcessingCompleted(context, tabularData);
    }

    private void addRowDataToCache(IOlapBuilderTableRow data, CdComparableArray keyValues) {
        List aggrs = this.bufferTableRows.computeIfAbsent(keyValues, key -> this.newAggregatorList());
        for (int i = 0; i < this.aggregateTCols.size(); ++i) {
            IOlapBuilderDataColumnDef tCol = this.aggregateTCols.get(i);
            Comparable javaNativeDataValue = data.getJavaNativeDataValue(tCol);
            ((Aggregator)aggrs.get(i))._aggregate(javaNativeDataValue);
        }
    }

    private List<Aggregator> newAggregatorList() {
        ArrayList<Aggregator> aggrs = new ArrayList<Aggregator>(this.aggregateFunctions.size());
        for (int i = 0; i < this.aggregateFunctions.size(); ++i) {
            aggrs.add(this.aggregateFunctions.get(i).build());
        }
        return aggrs;
    }

    @NotNull
    private CdComparableArray getKeyValues(IOlapBuilderTableRow data) {
        Comparable[] keyValues = new Comparable[this.groupByTCols.size()];
        for (int i = 0; i < this.groupByTCols.size(); ++i) {
            IOlapBuilderDataColumnDef tCol = this.groupByTCols.get(i);
            keyValues[i] = data.getJavaNativeDataValue(tCol);
        }
        return new CdComparableArray(keyValues);
    }
}

