/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.groupby;

import crazydev.common.collection.CdSingleItemList;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.executor.common.OlapBuilderSchedulingPolicy;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderSingleTableDataView;
import crazydev.iccube.builder.model.impl.view.groupby.Aggregators;
import crazydev.iccube.builder.model.impl.view.groupby.OlapBuilderGroupByDataViewLogic;
import crazydev.iccube.builder.model.impl.view.groupby.OlapBuilderGroupByDataViewValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.ux.meta.dataview.UxBuilderDataViewTypeGroupId;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="groupByDataView")
public class OlapBuilderGroupByDataView
extends OlapBuilderSingleTableDataView<OlapBuilderGroupByDataView, OlapBuilderGroupByDataViewLogic>
implements IOlapBuilderJaxbListener {
    public static final CdProperty GROUP_BY = new CdReadWriteProperty(OlapBuilderGroupByDataView.class, "groupByColRefs");
    public static final CdProperty SUM = new CdReadWriteProperty(OlapBuilderGroupByDataView.class, "sumColRefs");
    public static final CdProperty AGGREGATEFUNCTION = new CdReadWriteProperty(OlapBuilderGroupByDataView.class, "aggregateFunction");
    public static final CdProperty ISUNDERLINYTABLEKEYSORTED = new CdReadWriteProperty(OlapBuilderGroupByDataView.class, "isUnderlinyTableKeySorted");
    @XmlElement(name="groupBy", required=false)
    private OlapBuilderDataColumnRef groupByColRef;
    @XmlElement(name="groupByCols", required=false)
    private List<OlapBuilderDataColumnRef> groupByColRefs;
    @Deprecated
    @XmlElement(name="takeFirst", required=true)
    private List<OlapBuilderDataColumnRef> takeFirstColRefs;
    @XmlElement(name="sum", required=true)
    private List<OlapBuilderDataColumnRef> sumColRefs;
    @XmlElement(name="aggregateFunction", required=false)
    private List<String> aggregateFunction;
    @XmlElement(name="isUnderlinyTableKeySorted", required=false)
    private boolean isUnderlinyTableKeySorted;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> groupByColDefs;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> aggreColDefs;
    @XmlTransient
    private List<Aggregators.AggregateFunction> aggregateFunctions;

    @Override
    @Nullable
    public String getHelpUrl() {
        return "etl_group_by";
    }

    @Override
    public UxBuilderDataViewTypeGroupId getUxGroupId() {
        return UxBuilderDataViewTypeGroupId.dvTypeGroupClassic;
    }

    @Override
    protected OlapBuilderGroupByDataViewLogic createLogic() {
        return new OlapBuilderGroupByDataViewLogic(this);
    }

    @Override
    public OlapBuilderSchedulingPolicy schedulingPolicy() {
        return OlapBuilderSchedulingPolicy.POST_ORDER;
    }

    public List<IOlapBuilderDataColumnDef> getAggreColDefs() {
        return this.aggreColDefs;
    }

    public List<IOlapBuilderDataColumnDef> getGroupByColDefs() {
        return this.groupByColDefs;
    }

    @Override
    public String getInternalFriendlyTypeName() {
        return "Group By View ( " + (this.underlying != null ? this.underlying.getName() : "<null>") + " )";
    }

    @Override
    public OlapValidator<OlapBuilderValidationContext, IOlapBuilderSchemaDef, OlapBuilderGroupByDataView> getValidator() {
        return new OlapBuilderGroupByDataViewValidator();
    }

    @Override
    public void solveDirectReferences(OlapBuilderReferenceSolver referenceSolver) {
        super.solveDirectReferences(referenceSolver);
        this.groupByColDefs = null;
        this.aggreColDefs = null;
    }

    public boolean isUnderlinyTableKeySorted() {
        return this.isUnderlinyTableKeySorted;
    }

    @Override
    public void solveDirectReferencesColumns(OlapBuilderReferenceSolver referenceSolver) {
        super.solveDirectReferencesColumns(referenceSolver);
        this.groupByColDefs = referenceSolver.getColumns(this.underlying, this.groupByColRefs);
        this.aggreColDefs = referenceSolver.getColumns(this.underlying, this.sumColRefs);
        if (this.groupByColDefs.isEmpty() && this.groupByColRef != null) {
            this.groupByColDefs = new CdSingleItemList((Object)referenceSolver.getColumn(this.underlying, this.groupByColRef));
        }
    }

    public Function<Integer, Aggregators.AggregateFunction> getAggregateFunctions() {
        List<Aggregators.AggregateFunction> aggregates = this.buildAggregates();
        return i -> i >= aggregates.size() ? Aggregators.AggregateFunction.DEFAULT : (Aggregators.AggregateFunction)((Object)((Object)aggregates.get((int)i)));
    }

    int getAggregateFunctionSize() {
        return this.aggregateFunction == null ? 0 : this.aggregateFunction.size();
    }

    private List<Aggregators.AggregateFunction> buildAggregates() {
        List<Aggregators.AggregateFunction> aggregates;
        if (this.aggregateFunction != null) {
            OlapBuilderGroupByDataView.checkValues(this.aggregateFunction);
            aggregates = this.aggregateFunction.stream().map(String::toUpperCase).map(Aggregators.AggregateFunction::valueOf).collect(Collectors.toList());
        } else {
            aggregates = new ArrayList<Aggregators.AggregateFunction>();
        }
        return aggregates;
    }

    private static void checkValues(List<String> str) {
        ArrayList<String> invalid = new ArrayList<String>();
        for (int i = 0; i < str.size(); ++i) {
            String s = str.get(i);
            try {
                Aggregators.AggregateFunction.valueOf(s.toUpperCase());
                continue;
            }
            catch (Exception ex) {
                invalid.add(s);
            }
        }
        if (!invalid.isEmpty()) {
            String message = invalid.stream().collect(Collectors.joining(","));
            String validValues = Arrays.stream(Aggregators.AggregateFunction.values()).filter(t -> t != Aggregators.AggregateFunction.DEFAULT).map(Enum::name).collect(Collectors.joining(","));
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_GROUP_BY_INVALID_AGGREGATION, new Serializable[]{message, validValues});
        }
    }

    @Override
    public void beforeMarshal() {
    }

    @Override
    public void afterUnmarshal() {
        if ((this.groupByColRefs == null || this.groupByColRefs.isEmpty()) && this.groupByColRef != null) {
            this.groupByColRefs = new ArrayList<OlapBuilderDataColumnRef>();
            this.groupByColRefs.add(this.groupByColRef);
        }
        this.groupByColRef = null;
        this.takeFirstColRefs = null;
    }
}

