/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.common;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.view.common.OlapBaseBuilderMultiTableDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataViewLogic;
import crazydev.iccube.pub.view.IOlapColumnDef;
import crazydev.iccube.pub.view.IOlapDataTableDef;
import crazydev.iccube.pub.view.IOlapDataTableRow;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class OlapBuilderMultiTableDataViewLogic<VIEW extends OlapBaseBuilderMultiTableDataView>
extends OlapBuilderBaseDataViewLogic<VIEW> {
    private final Object lifeCycleLOCK = new Object();
    private int onTableProcessingInitNotified = 0;
    private int onTableProcessingStartedNotified = 0;
    private int onTableProcessingCompletedNotified = 0;
    private int onTableRowsProcessingCompletedNotified = 0;
    private int onTableProcessingFinallyNotified = 0;
    private boolean onPreInitProcessingDone;
    private boolean onInitProcessingDone;

    public OlapBuilderMultiTableDataViewLogic(VIEW view) {
        super(view);
    }

    @Override
    public void onReferenceSolved(OlapBuilderErrorManager errorManager) {
        super.onReferenceSolved(errorManager);
        this.resetCounters();
    }

    @Override
    public void onClearAllListenersCalled() {
        super.onClearAllListenersCalled();
        this.resetCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCounters() {
        Object object = this.lifeCycleLOCK;
        synchronized (object) {
            this.onTableProcessingInitNotified = 0;
            this.onTableProcessingStartedNotified = 0;
            this.onTableProcessingCompletedNotified = 0;
            this.onTableRowsProcessingCompletedNotified = 0;
            this.onTableProcessingFinallyNotified = 0;
            this.onPreInitProcessingDone = false;
            this.onInitProcessingDone = false;
        }
    }

    protected void onProcessingPreInit(OlapBuilderContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTableProcessingPreInit(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        Object object = this.lifeCycleLOCK;
        synchronized (object) {
            if (!this.onPreInitProcessingDone) {
                this.onPreInitProcessingDone = true;
                this.onProcessingPreInit(context);
            }
        }
        super.onTableProcessingPreInit(context, tabularData);
    }

    protected void onProcessingInit(OlapBuilderContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTableProcessingInit(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        Object object = this.lifeCycleLOCK;
        synchronized (object) {
            ++this.onTableProcessingInitNotified;
            if (this.onTableProcessingInitNotified > 1) {
                return;
            }
            if (!this.onInitProcessingDone) {
                this.onInitProcessingDone = true;
                this.onProcessingInit(context);
            }
        }
        ((OlapBaseBuilderMultiTableDataView)this.view).fireTableProcessingInit(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTableProcessingStarted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        Object object = this.lifeCycleLOCK;
        synchronized (object) {
            ++this.onTableProcessingStartedNotified;
            if (this.onTableProcessingStartedNotified > 1) {
                return;
            }
        }
        ((OlapBaseBuilderMultiTableDataView)this.view).fireTableProcessingStarted(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTableRowsProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        Object object = this.lifeCycleLOCK;
        synchronized (object) {
            ++this.onTableRowsProcessingCompletedNotified;
            if (this.onTableRowsProcessingCompletedNotified < ((OlapBaseBuilderMultiTableDataView)this.view).getDirectUnderlyingsCount()) {
                return;
            }
        }
        ((OlapBaseBuilderMultiTableDataView)this.view).fireTableRowsProcessingCompleted(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        Object object = this.lifeCycleLOCK;
        synchronized (object) {
            ++this.onTableProcessingCompletedNotified;
            if (this.onTableProcessingCompletedNotified < ((OlapBaseBuilderMultiTableDataView)this.view).getDirectUnderlyingsCount()) {
                return;
            }
        }
        ((OlapBaseBuilderMultiTableDataView)this.view).fireTableProcessingCompleted(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTableProcessingFinally(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        Object object = this.lifeCycleLOCK;
        synchronized (object) {
            ++this.onTableProcessingFinallyNotified;
            if (this.onTableProcessingFinallyNotified < ((OlapBaseBuilderMultiTableDataView)this.view).getDirectUnderlyingsCount()) {
                return;
            }
        }
        ((OlapBaseBuilderMultiTableDataView)this.view).fireTableProcessingFinally(context);
    }

    public static class OlapNewDataRow
    implements IOlapDataTableRow {
        private final Comparable[] values;
        private final List<? extends IOlapColumnDef> columns;
        private final Map<String, IOlapBuilderDataColumnDef> mapRowsName;
        private String viewName;

        public OlapNewDataRow(String viewName, Map<String, IOlapBuilderDataColumnDef> mapRowsName, List<? extends IOlapColumnDef> columns) {
            this.viewName = viewName;
            this.columns = columns;
            this.mapRowsName = mapRowsName;
            this.values = new Comparable[columns.size()];
        }

        @Override
        public List<? extends IOlapColumnDef> getColumns() {
            return this.columns;
        }

        @Override
        public IOlapColumnDef getColumn(String columnName) {
            return columnName == null ? null : (IOlapColumnDef)this.mapRowsName.get(columnName);
        }

        @Override
        public void set(String columnName, Comparable newValue) {
            this.set(this.getExistingColumn(columnName), newValue);
        }

        private IOlapColumnDef getExistingColumn(String columnName) {
            IOlapColumnDef col = this.getColumn(columnName);
            if (col == null) {
                throw new RuntimeException("Could not find column '" + columnName + "' in view '" + this.viewName + "'");
            }
            return col;
        }

        @Override
        public void set(IOlapColumnDef columnDef, Comparable newValue) {
            Comparable typedValue;
            if (columnDef == null) {
                return;
            }
            this.values[columnDef.getIndex()] = columnDef.isArray() ? newValue : (typedValue = this.convertValue(columnDef, newValue));
        }

        @Override
        public IOlapDataTableDef getTableDef() {
            return new IOlapDataTableDef(this){
                final /* synthetic */ OlapNewDataRow this$0;
                {
                    OlapNewDataRow olapNewDataRow = this$0;
                    Objects.requireNonNull(olapNewDataRow);
                    this.this$0 = olapNewDataRow;
                }

                @Override
                public String getName() {
                    return this.this$0.viewName;
                }

                @Override
                public List<? extends IOlapColumnDef> getColumns() {
                    return this.this$0.columns;
                }
            };
        }

        @Override
        public Comparable get(IOlapColumnDef columnDef) {
            return this.values[columnDef.getIndex()];
        }

        @Override
        public Comparable get(String columnName) {
            return this.get(this.getExistingColumn(columnName));
        }
    }
}

