/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.common;

import crazydev.common.math.CdSortingGraph;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataViewLogic;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderSingleTableDataView;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class OlapBuilderBaseSingleTableDataView<VIEW extends OlapBuilderBaseDataView, LOGIC extends OlapBuilderBaseDataViewLogic<VIEW>>
extends OlapBuilderBaseDataView<VIEW, LOGIC> {
    @XmlAttribute(name="tableId")
    protected String tabularDataId;
    @XmlTransient
    protected IOlapBuilderTabularDataDef underlying;

    public OlapBuilderBaseSingleTableDataView() {
    }

    protected OlapBuilderBaseSingleTableDataView(String name, List<IOlapBuilderDataColumnDef> columns) {
        super(name, columns);
    }

    protected OlapBuilderBaseSingleTableDataView(OlapBuilderSingleTableDataView dataView) {
        super(dataView);
        this.tabularDataId = dataView.tabularDataId;
    }

    public String getTabularDataId() {
        return this.tabularDataId;
    }

    @Override
    public boolean hasDirectUnderlying(String id) {
        return this.tabularDataId != null && this.tabularDataId.equals(id);
    }

    @Override
    public void solveDirectReferences(OlapBuilderReferenceSolver referenceSolver) {
        this.underlying = referenceSolver.getTabularData(this.tabularDataId);
    }

    @Override
    protected List<IOlapBuilderDataColumnDef> doCreateSelectedColumns(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver) {
        return this.logic.setupSelectedColumns(errorManager, referenceSolver);
    }

    @Override
    public void onReferenceSolved(OlapBuilderErrorManager errorManager, CdSortingGraph<IOlapBuilderTabularDataDef> graph) {
        super.onReferenceSolved(errorManager, graph);
        graph.setOneOneRelation((Object)this.underlying, (Object)this);
        this.logic.onReferenceSolved(errorManager);
    }

    @Override
    public List<String> getInternalTabularDataIds() {
        return Collections.singletonList(this.tabularDataId);
    }

    @Override
    public List<IOlapBuilderTabularDataDef> getDirectUnderlyings() {
        ArrayList<IOlapBuilderTabularDataDef> tables = new ArrayList<IOlapBuilderTabularDataDef>();
        if (this.underlying != null) {
            tables.add(this.underlying);
        }
        return tables;
    }

    @Nullable
    public IOlapBuilderTabularDataDef getDirectUnderlying() {
        return this.underlying;
    }

    @Override
    protected void doConnectToUnderlyingTables() {
        if (this.underlying != null) {
            this.underlying.addListener(this.logic);
        }
    }

    @Override
    protected void doDisconnectFromUnderlyingTables() {
        if (this.underlying != null) {
            this.underlying.removeListener(this.logic);
        }
    }

    @Override
    public void undoSwitchTableIfColliding(String fromId) {
        if (this.getId().equals(this.tabularDataId)) {
            this.tabularDataId = fromId;
        }
    }

    @Override
    public void onReferenceStarted() {
        super.onReferenceStarted();
        if (this.underlying != null) {
            this.underlying.onReferenceStarted();
        }
    }
}

