/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.common;

import crazydev.common.collection.CdSetList;
import crazydev.common.math.CdSortingGraph;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.common.OlapBuilderTypeUIXmlIdentifier;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.executor.common.OlapBuilderSchedulingPolicy;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderAction;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseTabularDataTable;
import crazydev.iccube.builder.model.impl.table.OlapBuilderDataTableListeners;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataViewLogic;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderDataViewColumnsError;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderViewCycleDetector;
import crazydev.iccube.builder.type.OlapBuilderColumnDecorationType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.builder.ux.meta.dataview.UxBuilderDataViewType;
import crazydev.iccube.builder.ux.meta.dataview.UxBuilderDataViewTypeGroup;
import crazydev.iccube.builder.ux.meta.dataview.UxBuilderDataViewTypeGroupId;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="dataView")
public abstract class OlapBuilderBaseDataView<VIEW extends OlapBuilderBaseDataView, LOGIC extends OlapBuilderBaseDataViewLogic<VIEW>>
extends OlapBuilderBaseTabularDataTable
implements IOlapBuilderDataViewDef<VIEW> {
    public static final CdProperty TYPE_UI = new CdReadWriteProperty(OlapBuilderBaseDataView.class, "typeUI"){

        public Class<?> getType() {
            return OlapBuilderTypeUIXmlIdentifier.class;
        }
    };
    public static final CdProperty NAME = new CdReadWriteProperty(OlapBuilderBaseDataView.class, "name");
    public static final CdProperty DESCRIPTION = new CdReadWriteProperty(OlapBuilderBaseDataView.class, "description");
    public static final CdProperty COLUMNS = new CdReadWriteProperty(OlapBuilderBaseDataView.class, "columns");
    public static final CdProperty ACTIONS = new CdReadProperty(OlapBuilderBaseDataView.class, "actions", CdProperty.Access.METHOD);
    @XmlTransient
    private final OlapBuilderDataTableListeners listeners = new OlapBuilderDataTableListeners();
    @XmlTransient
    protected LOGIC logic;
    @XmlTransient
    protected List<IOlapBuilderDataColumnDef> columns;
    @XmlTransient
    protected boolean columnsSetup;
    @XmlTransient
    private String typeUI;
    @XmlAttribute(required=true)
    private String name;
    @XmlTransient
    private Integer depth;
    @XmlTransient
    private final AtomicInteger firedRowCount = new AtomicInteger();

    protected OlapBuilderBaseDataView() {
        this.logic = this.createLogic();
    }

    public OlapBuilderBaseDataView(String name) {
        this.name = name;
        this.logic = this.createLogic();
    }

    protected OlapBuilderBaseDataView(String name, List<IOlapBuilderDataColumnDef> columns) {
        this.name = name;
        this.columns = columns;
        this.logic = this.createLogic();
    }

    protected OlapBuilderBaseDataView(OlapBuilderBaseDataView<VIEW, LOGIC> dataView) {
        super(dataView);
        this.name = dataView.name;
        this.logic = this.createLogic();
    }

    @Nullable
    public String getTypeId() {
        return this.getClass().getSimpleName();
    }

    public abstract UxBuilderDataViewTypeGroupId getUxGroupId();

    public void setupUxType(UxBuilderDataViewTypeGroup group) {
        String id = this.getTypeId();
        UxBuilderDataViewType type = new UxBuilderDataViewType(this.getClass());
        group.add(type);
    }

    public List<OlapBuilderAction> getActions() {
        return Collections.emptyList();
    }

    protected abstract LOGIC createLogic();

    public LOGIC getLogic() {
        return this.logic;
    }

    @Override
    public String getContextVisualId() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public OlapBuilderSchedulingPolicy schedulingPolicy() {
        return null;
    }

    @Override
    public boolean isColumnsSetup() {
        return this.columnsSetup;
    }

    @Override
    public List<IOlapBuilderDataColumnDef> getAllColumns() {
        return this.getSelectedColumns();
    }

    @Override
    public List<IOlapBuilderDataColumnDef> getSelectedColumns() {
        if (!this.columnsSetup) {
            throw new OlapBuilderDataViewColumnsError("internal error: inconsistent usage of view (columns not setup) : " + this.getName());
        }
        if (this.columns == null) {
            throw new OlapBuilderDataViewColumnsError("internal error: inconsistent usage of view (no columns) : " + this.getName());
        }
        return this.columns;
    }

    @Override
    public void onReferenceStarted() {
        this.columnsSetup = false;
    }

    @Override
    public void setupSelectedColumns(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver, OlapBuilderViewCycleDetector cycleDetector) {
        if (this.columnsSetup) {
            return;
        }
        this.columns = null;
        try {
            cycleDetector.add(this);
        }
        catch (OlapBuilderViewCycleDetector.CycleError error) {
            errorManager.addError(OlapBuilderErrorCode.DATA_VIEW_CYCLE, new Serializable[]{this.getName(), error.cycle()});
            return;
        }
        List<IOlapBuilderTabularDataDef> underlyings = this.getDirectUnderlyings();
        for (IOlapBuilderTabularDataDef underlying : underlyings) {
            if (!(underlying instanceof OlapBuilderBaseDataView)) continue;
            ((OlapBuilderBaseDataView)underlying).setupSelectedColumns(errorManager, referenceSolver, cycleDetector);
        }
        this.solveDirectReferencesColumns(referenceSolver);
        if (!errorManager.hasErrors()) {
            this.columns = this.createSelectedColumns(errorManager, referenceSolver);
        }
        if (this.columns == null) {
            this.columns = new ArrayList<IOlapBuilderDataColumnDef>();
        }
        this.columnsSetup = true;
        for (IOlapBuilderTabularDataDef underlying : underlyings) {
            for (IOlapBuilderDataColumnDef col : underlying.getSelectedColumns()) {
                referenceSolver.touchColumn(underlying, col);
            }
        }
        referenceSolver.addWithColumnsSetup(this);
    }

    private List<IOlapBuilderDataColumnDef> createSelectedColumns(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver) {
        try {
            return this.doCreateSelectedColumns(errorManager, referenceSolver);
        }
        catch (OlapBuilderErrorException ex) {
            errorManager.addError(ex.getError());
            return Collections.emptyList();
        }
    }

    protected abstract List<IOlapBuilderDataColumnDef> doCreateSelectedColumns(OlapBuilderErrorManager var1, OlapBuilderReferenceSolver var2);

    @Override
    public final void solveReferences(OlapBuilderReferenceSolver referenceSolver, OlapBuilderViewCycleDetector cycleDetector) {
        super.solveReferences(referenceSolver, cycleDetector);
        try {
            this.solveReferencesEx(referenceSolver, cycleDetector, this);
        }
        catch (OlapBuilderViewCycleDetector.CycleError error) {
            OlapBuilderErrorManager errorManager = referenceSolver.getErrorManager();
            String cycle = error.cycle();
            errorManager.addError(OlapBuilderErrorCode.DATA_VIEW_CYCLE, new Serializable[]{this.getName(), cycle});
        }
    }

    private void solveReferencesEx(OlapBuilderReferenceSolver referenceSolver, OlapBuilderViewCycleDetector cycleDetector, IOlapBuilderTabularDataDef item) throws OlapBuilderViewCycleDetector.CycleError {
        if (!(item instanceof IOlapBuilderDataViewDef)) {
            return;
        }
        cycleDetector.add((IOlapBuilderDataViewDef)item);
        item.solveDirectReferences(referenceSolver);
        List<IOlapBuilderTabularDataDef> itemDirectUnderlyings = item.getDirectUnderlyings();
        for (IOlapBuilderTabularDataDef itemDirectUnderlying : itemDirectUnderlyings) {
            this.solveReferencesEx(referenceSolver, cycleDetector, itemDirectUnderlying);
        }
    }

    @Override
    public abstract void solveDirectReferences(OlapBuilderReferenceSolver var1);

    @Override
    public void solveDirectReferencesColumns(OlapBuilderReferenceSolver referenceSolver) {
    }

    @Override
    public void onReferenceSolved(OlapBuilderErrorManager errorManager, CdSortingGraph<IOlapBuilderTabularDataDef> graph) {
        boolean withTablePartition = false;
        List<IOlapBuilderTabularDataDef> underlyings = this.getDirectUnderlyings();
        for (IOlapBuilderTabularDataDef underlying : underlyings) {
            IOlapBuilderDataTableDef table;
            String partition;
            if (!(underlying instanceof IOlapBuilderDataTableDef) || !CdStringUtils.isNotNullAndNotBlank((String)(partition = (table = (IOlapBuilderDataTableDef)underlying).getPartitioningColumnNameX()))) continue;
            withTablePartition = true;
            break;
        }
        if (withTablePartition && underlyings.size() > 1) {
            errorManager.addError(OlapBuilderErrorCode.DATA_VIEW_PARTITION_TABLES, new Serializable[]{this.getName(), Integer.valueOf(underlyings.size())});
        }
    }

    @Override
    public void onReferenceSolvedFinished(OlapBuilderErrorManager errorManager) {
    }

    @Override
    public CdSetList<IOlapBuilderDataTableDef> getUnderlyingTables() {
        try {
            OlapBuilderViewCycleDetector cycleDetector = new OlapBuilderViewCycleDetector();
            CdSetList underlyingTables = new CdSetList();
            OlapBuilderBaseDataView.getUnderlyingTablesEx(cycleDetector, (CdSetList<IOlapBuilderDataTableDef>)underlyingTables, this);
            return underlyingTables;
        }
        catch (OlapBuilderViewCycleDetector.CycleError error) {
            OlapLoggers.BUILDER.error((Object)("getUnderlyingTables() : cycle in view : " + error.cycle()), (Throwable)error);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_VIEW_CYCLE, new Serializable[]{this.getName(), error.cycle()});
        }
    }

    private static void getUnderlyingTablesEx(OlapBuilderViewCycleDetector cycleDetector, CdSetList<IOlapBuilderDataTableDef> allUnderlyingTables, IOlapBuilderTabularDataDef item) throws OlapBuilderViewCycleDetector.CycleError {
        if (item instanceof IOlapBuilderDataViewDef) {
            cycleDetector.add((IOlapBuilderDataViewDef)item);
        }
        if (item instanceof IOlapBuilderDataTableDef) {
            allUnderlyingTables.add((Object)((IOlapBuilderDataTableDef)item));
            return;
        }
        List<IOlapBuilderTabularDataDef> itemDirectUnderlyings = item.getDirectUnderlyings();
        for (IOlapBuilderTabularDataDef itemDirectUnderlying : itemDirectUnderlyings) {
            OlapBuilderBaseDataView.getUnderlyingTablesEx(cycleDetector, allUnderlyingTables, itemDirectUnderlying);
        }
    }

    @Override
    public Set<IOlapBuilderDataViewDef> getAllViews() {
        try {
            OlapBuilderViewCycleDetector cycleDetector = new OlapBuilderViewCycleDetector();
            HashSet<IOlapBuilderDataViewDef> views = new HashSet<IOlapBuilderDataViewDef>();
            this.getAllViewsEx(cycleDetector, views, this);
            return views;
        }
        catch (OlapBuilderViewCycleDetector.CycleError error) {
            return new HashSet<IOlapBuilderDataViewDef>();
        }
    }

    private void getAllViewsEx(OlapBuilderViewCycleDetector cycleDetector, Set<IOlapBuilderDataViewDef> views, IOlapBuilderTabularDataDef item) throws OlapBuilderViewCycleDetector.CycleError {
        if (item instanceof IOlapBuilderDataViewDef) {
            cycleDetector.add((IOlapBuilderDataViewDef)item);
        }
        if (item instanceof OlapBuilderBaseDataView) {
            views.add((IOlapBuilderDataViewDef)item);
        }
        List<IOlapBuilderTabularDataDef> itemDirectUnderlyings = item.getDirectUnderlyings();
        for (IOlapBuilderTabularDataDef itemDirectUnderlying : itemDirectUnderlyings) {
            if (!(itemDirectUnderlying instanceof IOlapBuilderDataViewDef)) continue;
            this.getAllViewsEx(cycleDetector, views, itemDirectUnderlying);
        }
    }

    @Override
    public boolean canCleanupNotUsedColumns() {
        return false;
    }

    @Override
    public boolean canCleanupNotUsedColumn(IOlapBuilderDataColumnDef column) {
        return false;
    }

    public boolean isForFactBuilding() {
        return this.listeners.isForFactBuilding();
    }

    public boolean hasPostOrderListener(OlapBuilderViewCycleDetector cycleDetector) {
        try {
            cycleDetector.add(this);
        }
        catch (OlapBuilderViewCycleDetector.CycleError error) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_VIEW_CYCLE, new Serializable[]{this.getName(), error.cycle()});
        }
        if (this.schedulingPolicy() == OlapBuilderSchedulingPolicy.POST_ORDER) {
            return true;
        }
        for (IOlapBuilderTableListener listener : this.listeners.listeners()) {
            if (!listener.hasPostOrderListener(cycleDetector)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void addListener(IOlapBuilderTableListener listener) {
        if (!this.listeners.hasListeners()) {
            this.doConnectToUnderlyingTables();
        }
        if (OlapLoggers.BUILDER_LISTENERS.isDebugEnabled()) {
            OlapLoggers.BUILDER_LISTENERS.debug((Object)("[view] [" + this.getName() + "] add-listener " + listener.debug()));
        }
        this.listeners.addListener(listener);
    }

    @Override
    public final void removeListener(IOlapBuilderTableListener listener) {
        this.listeners.removeListener(listener);
        if (!this.listeners.hasListeners()) {
            this.doDisconnectFromUnderlyingTables();
        }
    }

    @Override
    public final void clearAllListeners() {
        if (OlapLoggers.BUILDER_LISTENERS.isDebugEnabled()) {
            OlapLoggers.BUILDER_LISTENERS.debug((Object)("[view] [" + this.getName() + "] clear-all-listeners"));
        }
        this.listeners.clearAllListeners();
        this.doDisconnectFromUnderlyingTables();
        ((OlapBuilderBaseDataViewLogic)this.logic).onClearAllListenersCalled();
    }

    protected abstract void doConnectToUnderlyingTables();

    protected abstract void doDisconnectFromUnderlyingTables();

    protected void setColumnsIndex() {
        List<IOlapBuilderDataColumnDef> columns = this.getSelectedColumns();
        for (int idx = 0; idx < columns.size(); ++idx) {
            IOlapBuilderDataColumnDef columnDef = columns.get(idx);
            columnDef.setIndex(idx);
        }
    }

    public void fireTableProcessingPreInit(OlapBuilderContext context) {
        this.firedRowCount.set(0);
        this.listeners.fireTableProcessingPreInit(context, this);
    }

    public void fireTableProcessingInit(OlapBuilderContext context) {
        this.setColumnsIndex();
        this.firedRowCount.set(0);
        this.listeners.fireTableProcessingInit(context, this);
    }

    public void fireTableProcessingStarted(OlapBuilderContext context) {
        this.firedRowCount.set(0);
        this.listeners.fireTableProcessingStarted(context, this);
    }

    public boolean fireTableNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        this.firedRowCount.incrementAndGet();
        return this.listeners.fireTableNewRow(context, tabularData, originalTable, columns, partition, rowNb, data);
    }

    public boolean fireTableNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        this.firedRowCount.incrementAndGet();
        return this.listeners.fireTableNewRow(context, this, originalTable, this.getSelectedColumns(), partition, rowNb, data);
    }

    public void fireTableProcessingCompleted(OlapBuilderContext context) {
        OlapLoggers.BUILDER.info((Object)String.format("[view] [%s] processing completed : %s total rows", this.getName(), CdStringUtils.formatNice((long)this.firedRowCount.intValue())));
        this.listeners.fireTableProcessingCompleted(context, this);
    }

    public void fireTableRowsProcessingCompleted(OlapBuilderContext context) {
        this.listeners.fireTableRowsProcessingCompleted(context, this);
    }

    public void fireTableProcessingFinally(OlapBuilderContext context) {
        this.listeners.fireTableProcessingFinally(context, this);
    }

    public String toString() {
        return this.getName();
    }

    public abstract void undoSwitchTableIfColliding(String var1);

    @Override
    public IOlapBuilderDataViewDef<VIEW> executeAction(OlapEngineRequestContext context, IOlapBuilderSchemaDef schemaDef, String clazz, String name) {
        try {
            Class<?> actionClazz = Class.forName(clazz);
            OlapBuilderAction action = (OlapBuilderAction)actionClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return this.executeAction(context, schemaDef, action);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("internal error : action [" + name + "] class unexpected error", ex);
        }
    }

    protected IOlapBuilderDataViewDef<VIEW> executeAction(OlapEngineRequestContext context, IOlapBuilderSchemaDef schemaDef, OlapBuilderAction action) {
        return this;
    }

    public static void synchronizeColumns(Consumer<List<IOlapBuilderDataColumnDef>> setter, String columnDefs) throws IOException {
        ArrayList<OlapBuilderDataColumn> colDefs = new ArrayList<OlapBuilderDataColumn>();
        if (CdStringUtils.isNotNullAndNotBlank((String)columnDefs)) {
            List lines = IOUtils.readLines((Reader)new StringReader(columnDefs));
            for (String line : lines) {
                if (CdStringUtils.isNullOrBlank((String)(line = line.trim())) || line.startsWith("#") || line.startsWith("//")) continue;
                String[] parts = line.split(":");
                String name = null;
                String type = null;
                String decoration = null;
                if (parts.length > 0) {
                    name = parts[0].trim();
                }
                if (CdStringUtils.isNullOrBlank(name)) {
                    throw new RuntimeException("missing name");
                }
                if (parts.length > 1) {
                    type = parts[1].trim();
                }
                if (CdStringUtils.isNullOrBlank(type)) {
                    throw new RuntimeException("missing type for " + name);
                }
                if (parts.length > 2) {
                    decoration = parts[2].trim();
                }
                OlapBuilderInputType cType = OlapBuilderInputType.valueOf(type.toUpperCase());
                OlapBuilderColumnDecorationType dType = CdStringUtils.isNotNullAndNotBlank((String)decoration) ? OlapBuilderColumnDecorationType.valueOf(decoration.toUpperCase()) : null;
                colDefs.add(new OlapBuilderDataColumn(cType, "js", name, dType));
            }
        }
        setter.accept(colDefs);
    }

    @Override
    @Nullable
    public final Integer getDepth() {
        return this.depth;
    }

    @Override
    public final void setDepth(@Nullable Integer depth) {
        this.depth = depth;
    }
}

