/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.localization;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.builders.OlapBuilderAbstractTableListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderLocalizationBuilder
extends OlapBuilderAbstractTableListener {
    private final OlapSchemaLocalization localization;

    public OlapBuilderLocalizationBuilder(OlapSchemaLocalization localization) {
        this.localization = localization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTableProcessingStarted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        super.onTableProcessingStarted(context, tabularData);
        OlapSchemaLocalization olapSchemaLocalization = this.localization;
        synchronized (olapSchemaLocalization) {
            this.localization.onProcessingStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        super.onTableProcessingCompleted(context, tabularData);
        OlapSchemaLocalization olapSchemaLocalization = this.localization;
        synchronized (olapSchemaLocalization) {
            this.localization.onProcessingDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        if (columns.size() <= 1) {
            return false;
        }
        IOlapBuilderDataColumnDef keyColumn = columns.get(0);
        Comparable key = data.getJavaNativeDataValue(keyColumn);
        if (key == null) {
            return true;
        }
        String keyAsString = key.toString();
        if (CdStringUtils.isNullOrBlank((String)keyAsString)) {
            return true;
        }
        for (int ii = 1; ii < columns.size(); ++ii) {
            String valueAsString;
            IOlapBuilderDataColumnDef localeColumn = columns.get(ii);
            Comparable value = data.getJavaNativeDataValue(localeColumn);
            if (value == null || CdStringUtils.isNullOrBlank((String)(valueAsString = value.toString()))) continue;
            String locale = localeColumn.getName();
            OlapSchemaLocalization olapSchemaLocalization = this.localization;
            synchronized (olapSchemaLocalization) {
                this.localization.addLocalization(locale, keyAsString, valueAsString);
                continue;
            }
        }
        return true;
    }
}

