/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.hierarchy;

import crazydev.common.collection.CdSetList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.xml.CdLocalDateTimeXmlAdapter;
import crazydev.common.xml.CdLocaleXmlAdapter;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.model.builders.IOlapBuilderDimensionListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.impl.OlapBuilderAllLevelParsedDefinition;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.OlapBuilderNamedDefinitionHelper;
import crazydev.iccube.builder.model.impl.hierarchy.IOlapBuilderBaseHierarchyLevelDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderBaseWithAllHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderExcelTimeLineSupport;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderTimeWizardHierarchyLevel;
import crazydev.iccube.builder.model.validation.OlapBuilderTimeWizardHierarchyValidator;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;

@XmlRootElement(name="timeHierarchy")
public class OlapBuilderTimeWizardHierarchy
extends OlapBuilderBaseWithAllHierarchy {
    public static final CdProperty LOCALE = new CdReadWriteProperty(OlapBuilderTimeWizardHierarchy.class, "locale");
    public static final CdProperty LEVEL_DEFINITIONS = new CdReadWriteProperty(OlapBuilderTimeWizardHierarchy.class, "levelDefinitions");
    public static final CdProperty EXCEL_TIME_LINE_SUPPORT = new CdReadWriteProperty(OlapBuilderTimeWizardHierarchy.class, "excelTimeLineSupport");
    @XmlElements(value={@XmlElement(name="level")})
    private List<OlapBuilderTimeWizardHierarchyLevel> levelDefinitions;
    @XmlJavaTypeAdapter(value=CdLocalDateTimeXmlAdapter.class)
    @XmlElement
    private LocalDateTime from;
    @XmlJavaTypeAdapter(value=CdLocalDateTimeXmlAdapter.class)
    @XmlElement
    private LocalDateTime to;
    @XmlJavaTypeAdapter(value=CdLocaleXmlAdapter.class)
    @XmlElement
    private Locale locale;
    @XmlElement(required=false)
    private OlapBuilderExcelTimeLineSupport excelTimeLineSupport;
    @XmlTransient
    private List<IOlapBuilderHierarchyLevelDef> levels = new ArrayList<IOlapBuilderHierarchyLevelDef>();

    public OlapBuilderTimeWizardHierarchy() {
        this(null, OlapBuilderAllLevelParsedDefinition.UNDEFINED, false, new OlapLevelType[0]);
    }

    public OlapBuilderTimeWizardHierarchy(String name, OlapBuilderAllLevelParsedDefinition allLevel, boolean isDefault, OlapLevelType ... levelTypes) {
        super(name, isDefault, allLevel);
        if (levelTypes == null || levelTypes.length == 0) {
            this.levelDefinitions = new ArrayList<OlapBuilderTimeWizardHierarchyLevel>();
        } else {
            this.levelDefinitions = new ArrayList<OlapBuilderTimeWizardHierarchyLevel>(levelTypes.length);
            for (int idx = 0; idx < levelTypes.length; ++idx) {
                OlapLevelType levelType = levelTypes[idx];
                this.addLevel(new OlapBuilderTimeWizardHierarchyLevel(levelType));
            }
        }
    }

    public OlapBuilderTimeWizardHierarchy(String name) {
        this(null, OlapBuilderAllLevelParsedDefinition.UNDEFINED, false, new OlapLevelType[0]);
        this.setName(name);
    }

    @Override
    public void resetUUID() {
        if (this.levelDefinitions != null) {
            for (OlapBuilderTimeWizardHierarchyLevel levelDefinition : this.levelDefinitions) {
                levelDefinition.resetUUID();
            }
        }
    }

    @Override
    public boolean isTimeWizard() {
        return true;
    }

    @Override
    public OlapBuilderExcelTimeLineSupport getExcelTimeLineSupport() {
        return this.excelTimeLineSupport;
    }

    public void addLevel(OlapBuilderTimeWizardHierarchyLevel timeLevel) {
        this.levelDefinitions.add(timeLevel);
    }

    @Override
    public List<IOlapBuilderHierarchyLevelDef> getLevels() {
        return this.levels;
    }

    @Override
    public List<? extends IOlapBuilderBaseHierarchyLevelDef> getLevelsForUX() {
        return this.levelDefinitions;
    }

    @Override
    @Nullable
    public IOlapBuilderBaseHierarchyLevelDef getLevelByUUIDForUX(String uuid) {
        for (OlapBuilderTimeWizardHierarchyLevel level : this.levelDefinitions) {
            if (!level.getUUID().equals(uuid)) continue;
            return level;
        }
        return null;
    }

    @Override
    @Nullable
    public IOlapBuilderBaseHierarchyLevelDef getLevelForUX(String name) {
        for (OlapBuilderTimeWizardHierarchyLevel level : this.levelDefinitions) {
            if (!level.getName().equals(name)) continue;
            return level;
        }
        return null;
    }

    @Override
    public void addLevelForUX(IOlapBuilderBaseHierarchyLevelDef level) {
        this.levelDefinitions.add((OlapBuilderTimeWizardHierarchyLevel)level);
    }

    @Override
    public void removeLevelForUX(IOlapBuilderBaseHierarchyLevelDef level) {
        this.levelDefinitions.remove(level);
    }

    public List<IOlapBuilderHierarchyLevelDef> createLevels() {
        return OlapBuilderTimeWizardHierarchy.buildOlapBuilderLevels(this.levelDefinitions);
    }

    @Override
    public IOlapBuilderDimensionListener createBuilder(OlapBuilderContext context, OlapDimension dimension) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public OlapBuilderTimeWizardHierarchyValidator getValidator() {
        this.levels = OlapBuilderTimeWizardHierarchy.buildOlapBuilderLevels(this.levelDefinitions);
        return new OlapBuilderTimeWizardHierarchyValidator();
    }

    private static List<IOlapBuilderHierarchyLevelDef> buildOlapBuilderLevels(List<OlapBuilderTimeWizardHierarchyLevel> levelDefinitions) {
        ArrayList<IOlapBuilderHierarchyLevelDef> levels = new ArrayList<IOlapBuilderHierarchyLevelDef>();
        for (OlapBuilderTimeWizardHierarchyLevel levelDefinition : levelDefinitions) {
            String levelName = levelDefinition.getName();
            String levelDescription = levelDefinition.getDescription();
            OlapLevelType levelType = levelDefinition.getType();
            IOlapBuilderDataColumnDef column = OlapBuilderDataColumn.createDateColumn(levelName);
            OlapBuilderHierarchyLevel level = new OlapBuilderHierarchyLevel(levelName, levelDescription, levelType, column);
            level.setKeyUniqueInLevel(true);
            levels.add(level);
        }
        return levels;
    }

    @Nullable
    public IOlapBuilderDataColumnDef getColumn(OlapLevelType levelType) {
        for (IOlapBuilderHierarchyLevelDef levelDef : this.getLevels()) {
            IOlapBuilderDataColumnDef columnDef = levelDef.getNameColumn();
            if (columnDef == null || !columnDef.getName().equals(levelType.getName())) continue;
            return columnDef;
        }
        return null;
    }

    @Override
    @Nullable
    public Locale getLocale() {
        return this.locale;
    }

    public OlapBuilderTimeWizardHierarchyLevel[] getLevelDefinitions() {
        return this.levelDefinitions.toArray(new OlapBuilderTimeWizardHierarchyLevel[this.levelDefinitions.size()]);
    }

    @Override
    public List<OlapBuilderDataColumnRef> getAllFactIndexingColumns() {
        CdSetList columns = new CdSetList();
        List<IOlapBuilderHierarchyLevelDef> alllevels = OlapBuilderTimeWizardHierarchy.buildOlapBuilderLevels(this.levelDefinitions);
        for (IOlapBuilderHierarchyLevelDef levelDef : alllevels) {
            for (IOlapBuilderDataColumnDef columnRef : levelDef.getKeyColumns()) {
                columns.add(OlapBuilderDataColumnRef.asRef(columnRef));
            }
        }
        return columns;
    }

    @Override
    public boolean mightBeIndexingByOneLevel() {
        return true;
    }

    @Nullable
    public List<? extends IOlapBuilderDataColumnDef> getFactIndexingColumns() {
        ArrayList<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>();
        List<IOlapBuilderHierarchyLevelDef> levels = OlapBuilderTimeWizardHierarchy.buildOlapBuilderLevels(this.levelDefinitions);
        for (int i = levels.size() - 1; i >= 0; --i) {
            IOlapBuilderHierarchyLevelDef levelDef = levels.get(i);
            columns.add(levelDef.getKeyColumns().get(0));
        }
        return columns;
    }

    @Override
    public boolean orderLevels(List<String> orderedNames) {
        return OlapBuilderNamedDefinitionHelper.order(this.levelDefinitions, orderedNames);
    }

    public LocalDateTime peekFrom() {
        LocalDateTime t = this.from;
        this.from = null;
        return t;
    }

    public LocalDateTime peekTo() {
        LocalDateTime t = this.to;
        this.to = null;
        return t;
    }

    public boolean isFactIndexing(int i) {
        return this.levels.get(i).isFactIndexing();
    }

    @Override
    public void moveLevelUp(IOlapBuilderBaseHierarchyLevelDef level) {
        int pos = this.getLevelPos(level);
        if (pos > 0) {
            this.levelDefinitions.remove(pos);
            this.levelDefinitions.add(pos - 1, (OlapBuilderTimeWizardHierarchyLevel)level);
        }
    }

    @Override
    public void moveLevelDown(IOlapBuilderBaseHierarchyLevelDef level) {
        int pos = this.getLevelPos(level);
        if (pos < this.levelDefinitions.size() - 1) {
            this.levelDefinitions.remove(pos);
            this.levelDefinitions.add(pos + 1, (OlapBuilderTimeWizardHierarchyLevel)level);
        }
    }

    private int getLevelPos(IOlapBuilderBaseHierarchyLevelDef level) {
        int pos = -1;
        for (int ii = 0; ii < this.levelDefinitions.size(); ++ii) {
            OlapBuilderTimeWizardHierarchyLevel tLevel = this.levelDefinitions.get(ii);
            if (!tLevel.getName().equals(level.getName())) continue;
            pos = ii;
            break;
        }
        return pos;
    }

    @Override
    public boolean withCreateLevel() {
        return true;
    }

    @Override
    public IOlapBuilderBaseHierarchyLevelDef createEmptyLevel() {
        return new OlapBuilderTimeWizardHierarchyLevel();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

