/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.hierarchy;

import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdSetList;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.model.builders.IOlapBuilderDimensionListener;
import crazydev.iccube.builder.model.builders.hierarchy.OlapBuilderDefaultMultiLevelHierarchyBuilder;
import crazydev.iccube.builder.model.builders.hierarchy.OlapBuilderNoDefaultMultiLevelHierarchyBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderAttributeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.impl.OlapBuilderAllLevelParsedDefinition;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.OlapBuilderNamedDefinitionHelper;
import crazydev.iccube.builder.model.impl.OlapBuilderProperty;
import crazydev.iccube.builder.model.impl.hierarchy.IOlapBuilderBaseHierarchyLevelDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderBaseHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderCommonHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderExcelTimeLineSupport;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="multiLevelHierarchy")
public class OlapBuilderMultiLevelHierarchy
extends OlapBuilderCommonHierarchy {
    public static final CdProperty EXCEL_TIME_LINE_SUPPORT = new CdReadWriteProperty(OlapBuilderMultiLevelHierarchy.class, "excelTimeLineSupport");
    @XmlElement(required=false)
    @Nullable
    private OlapBuilderExcelTimeLineSupport excelTimeLineSupport;
    @XmlTransient
    @Nullable
    private Locale locale;
    @XmlTransient
    private boolean isAttributeHierarchy;

    public OlapBuilderMultiLevelHierarchy() {
        this(null, false, new IOlapBuilderHierarchyLevelDef[0]);
    }

    public OlapBuilderMultiLevelHierarchy(String name, boolean isDefaultHierarchy, OlapBuilderAllLevelParsedDefinition allLevelDef, List<IOlapBuilderHierarchyLevelDef> levels) {
        super(name, isDefaultHierarchy, allLevelDef, levels);
    }

    public OlapBuilderMultiLevelHierarchy(String name, boolean isDefaultHierarchy, List<IOlapBuilderHierarchyLevelDef> levels) {
        super(name, isDefaultHierarchy, OlapBuilderAllLevelParsedDefinition.UNDEFINED, levels);
    }

    public OlapBuilderMultiLevelHierarchy(String name, boolean isDefaultHierarchy, IOlapBuilderHierarchyLevelDef ... levels) {
        super(name, isDefaultHierarchy, levels);
    }

    public OlapBuilderMultiLevelHierarchy(String name, boolean isDefaultHierarchy, OlapBuilderAllLevelParsedDefinition allLevelDef, IOlapBuilderHierarchyLevelDef ... levels) {
        super(name, isDefaultHierarchy, allLevelDef, levels);
    }

    public OlapBuilderMultiLevelHierarchy(String name, boolean isDefaultHierarchy, OlapBuilderExcelTimeLineSupport excelTimeLineSupport, OlapBuilderAllLevelParsedDefinition allLevelDef, IOlapBuilderHierarchyLevelDef ... levels) {
        super(name, isDefaultHierarchy, allLevelDef, levels);
        this.excelTimeLineSupport = excelTimeLineSupport;
    }

    public static OlapBuilderMultiLevelHierarchy create(IOlapBuilderAttributeDef attributeDef, IOlapBuilderHierarchyLevelDef level) {
        String attributeName = attributeDef.getName();
        OlapBuilderHierarchyLevel singleLevel = new OlapBuilderHierarchyLevel(attributeName, null, attributeDef.getAttributeColumn());
        singleLevel.setOrderKind(attributeDef.getOrderKind());
        singleLevel.setOrderMembersByType(attributeDef.getOrderMembersByType());
        singleLevel.setOrderNoKey(level.getOrderNoKey());
        singleLevel.setAttributeNameIfNull(attributeDef.getNameIfNull());
        singleLevel.setKeyUniqueInLevel(true);
        singleLevel.setNameUniqueInLevel();
        OlapBuilderAllLevelParsedDefinition all = OlapBuilderAllLevelParsedDefinition.create(OlapBuilderBaseHierarchy.DEFAULT_ALL_LEVEL_NAME, OlapBuilderBaseHierarchy.DEFAULT_ALL_MEMBER_NAME);
        OlapBuilderMultiLevelHierarchy hier = new OlapBuilderMultiLevelHierarchy(attributeName, false, all, singleLevel);
        hier.setIsAttributeHierarchy(true);
        hier.setTupleDimensionalityIndex(attributeDef.getTupleDimensionalityIndex());
        return hier;
    }

    @Override
    public boolean isAttributeHierarchy() {
        return this.isAttributeHierarchy;
    }

    private void setIsAttributeHierarchy(boolean set) {
        this.isAttributeHierarchy = set;
    }

    @Override
    @Nullable
    public OlapBuilderExcelTimeLineSupport getExcelTimeLineSupport() {
        return this.excelTimeLineSupport;
    }

    @Override
    @Nullable
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(@Nullable Locale locale) {
        this.locale = locale;
    }

    @Override
    @Nullable
    protected OlapBuilderProperty getOrderMemberProperty(IOlapBuilderHierarchyLevelDef level) {
        return level.getOrderByProperty();
    }

    @Override
    public IOlapBuilderDimensionListener createBuilder(OlapBuilderContext context, OlapDimension dimension) {
        if (this.isDefault()) {
            return new OlapBuilderDefaultMultiLevelHierarchyBuilder(context, dimension, this);
        }
        return new OlapBuilderNoDefaultMultiLevelHierarchyBuilder(context, dimension, this);
    }

    @Override
    public List<OlapBuilderDataColumnRef> getAllFactIndexingColumns() {
        List<IOlapBuilderHierarchyLevelDef> levels = this.getLevels();
        if (levels == null || levels.isEmpty()) {
            return Collections.emptyList();
        }
        CdSetList columns = new CdSetList();
        for (int i = levels.size() - 1; i >= 0; --i) {
            IOlapBuilderHierarchyLevelDef levelDef = levels.get(i);
            List<OlapBuilderDataColumnRef> keyColumns = levelDef.getKeyColumnsRef();
            if (keyColumns != null && !keyColumns.isEmpty()) {
                columns.addAll(keyColumns);
                continue;
            }
            CdCollections.addIfNotNull((List)columns, (Object)levelDef.getNameColumnRef());
        }
        return columns;
    }

    @Override
    public boolean mightBeIndexingByOneLevel() {
        return true;
    }

    @Override
    public boolean orderLevels(List<String> orderedNames) {
        return OlapBuilderNamedDefinitionHelper.order(this.levels, orderedNames);
    }

    @Override
    public boolean withCreateLevel() {
        return true;
    }

    @Override
    public IOlapBuilderBaseHierarchyLevelDef createEmptyLevel() {
        return new OlapBuilderHierarchyLevel();
    }
}

