/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.hierarchy;

import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdFilter;
import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.model.builders.IOlapBuilderDimensionListener;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.OlapBuilderProperty;
import crazydev.iccube.builder.model.impl.hierarchy.IOlapBuilderBaseHierarchyLevelDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderExcelTimeLineSupport;
import crazydev.iccube.builder.model.validation.OlapBuilderHierarchyValidator;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class OlapBuilderBaseHierarchy
implements IOlapBuilderHierarchyDef,
IOlapBuilderJaxbListener {
    public static String VERY_DEFAULT_LEVEL_PATTERN_NAME = "Level$";
    public static String DEFAULT_ALL_LEVEL_NAME = "__All-Level";
    public static String DEFAULT_ALL_MEMBER_NAME = "__All";
    public static final CdProperty UUID = new CdReadWriteProperty(OlapBuilderBaseHierarchy.class, "uuid");
    public static final CdProperty NAME = new CdReadWriteProperty(OlapBuilderBaseHierarchy.class, "name");
    public static final CdProperty DESCRIPTION = new CdReadWriteProperty(OlapBuilderBaseHierarchy.class, "description");
    public static final CdProperty FOLDER_NAME = new CdReadWriteProperty(OlapBuilderBaseHierarchy.class, "folderName");
    public static final CdProperty IS_DEFAULT = new CdReadWriteProperty(OlapBuilderBaseHierarchy.class, "isDefault");
    public static final CdProperty DEFAULT_MEMBER_NAME = new CdReadWriteProperty(OlapBuilderBaseHierarchy.class, "defaultMemberName");
    @XmlAttribute(required=false)
    @Nullable
    protected String folderName;
    @XmlAttribute(required=true)
    protected String name;
    @XmlAttribute(required=false)
    protected String description;
    @XmlAttribute(required=true)
    protected boolean isDefault = true;
    @XmlAttribute(name="uuid", required=true)
    private String uuid = java.util.UUID.randomUUID().toString();
    @XmlAttribute
    @Nullable
    private String defaultMemberName;
    @XmlTransient
    private int tupleDimensionalityIndex = -1;
    @XmlAttribute(required=false)
    private String caption;

    protected OlapBuilderBaseHierarchy() {
        this.tupleDimensionalityIndex = -1;
    }

    public OlapBuilderBaseHierarchy(String folderName, String name, boolean isDefault, String defaultMemberName) {
        this.folderName = folderName;
        this.name = name;
        this.isDefault = isDefault;
        this.defaultMemberName = defaultMemberName;
        this.tupleDimensionalityIndex = -1;
    }

    public OlapBuilderBaseHierarchy(String name, boolean isDefault) {
        this.name = name;
        this.isDefault = isDefault;
        this.tupleDimensionalityIndex = -1;
    }

    @Override
    public void beforeMarshal() {
    }

    @Override
    public void afterUnmarshal() {
        if (this.uuid == null) {
            this.uuid = java.util.UUID.randomUUID().toString();
        }
    }

    @Override
    public void resetUUID() {
        this.uuid = java.util.UUID.randomUUID().toString();
        this.resetLevelUUIDs();
    }

    protected void resetLevelUUIDs() {
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public int getTupleDimensionalityIndex() {
        if (this.tupleDimensionalityIndex == -1) {
            throw new RuntimeException("internal error: missing hierarchy index [" + this.name + "]");
        }
        return this.tupleDimensionalityIndex;
    }

    @Override
    public void setTupleDimensionalityIndex(int tupleDimensionalityIndex) {
        this.tupleDimensionalityIndex = tupleDimensionalityIndex;
    }

    @Override
    public boolean isParentChild() {
        return false;
    }

    @Override
    public boolean isTimeWizard() {
        return false;
    }

    @Override
    @Nullable
    public OlapBuilderExcelTimeLineSupport getExcelTimeLineSupport() {
        return null;
    }

    @Override
    public boolean hasAll() {
        return false;
    }

    @Override
    @Nullable
    public String getAllLevelName() {
        return null;
    }

    @Override
    @Nullable
    public String getAllMemberName() {
        return null;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean removeLevel(IOlapBuilderHierarchyLevelDef level) {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public List<IOlapBuilderHierarchyLevelDef> getLevels() {
        return null;
    }

    @Override
    public List<? extends IOlapBuilderBaseHierarchyLevelDef> getLevelsForUX() {
        return null;
    }

    @Override
    @Nullable
    public IOlapBuilderBaseHierarchyLevelDef getLevelByUUIDForUX(String uuid) {
        return null;
    }

    @Override
    @Nullable
    public IOlapBuilderBaseHierarchyLevelDef getLevelForUX(String name) {
        return null;
    }

    @Override
    public void addLevelForUX(IOlapBuilderBaseHierarchyLevelDef level) {
    }

    @Override
    public void removeLevelForUX(IOlapBuilderBaseHierarchyLevelDef level) {
    }

    @Override
    public boolean orderLevels(List<String> orderedNames) {
        return false;
    }

    @Override
    public IOlapBuilderDimensionListener createBuilder(OlapBuilderContext context, OlapDimension dimension) {
        return null;
    }

    @Override
    public boolean mightBeIndexingByOneLevel() {
        return false;
    }

    @Override
    public List<OlapBuilderDataColumnRef> getAllFactIndexingColumns() {
        return null;
    }

    @Override
    public boolean aggrFactOnAncestor() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setAsDefault() {
        this.isDefault = true;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean value) {
        this.isDefault = value;
    }

    @Override
    public OlapBuilderHierarchyValidator getValidator() {
        return new OlapBuilderHierarchyValidator();
    }

    @Override
    public List<IOlapBuilderPropertyDef> getPropertiesForBuilder(final String levelName) {
        IOlapBuilderHierarchyLevelDef level = (IOlapBuilderHierarchyLevelDef)CdCollections.findFirst(this.getLevels(), (CdFilter)new CdFilter<IOlapBuilderHierarchyLevelDef>(){
            {
                Objects.requireNonNull(this$0);
            }

            public boolean accept(IOlapBuilderHierarchyLevelDef levelDef) {
                return OlapCaseInsensitiveName.equals(levelName, levelDef.getName());
            }
        });
        return this.getPropertiesForLevel(level);
    }

    @Override
    @Nullable
    public String getDefaultMemberName() {
        return this.defaultMemberName;
    }

    public void setDefaultMemberName(@Nullable String defaultMemberName) {
        this.defaultMemberName = defaultMemberName;
    }

    private List<IOlapBuilderPropertyDef> getPropertiesForLevel(IOlapBuilderHierarchyLevelDef level) {
        List<IOlapBuilderPropertyDef> propertyDefList = level != null ? Collections.unmodifiableList(level.getPropertiesAndAttributes()) : Collections.emptyList();
        OlapBuilderProperty property = this.getOrderMemberProperty(level);
        if (property == null) {
            return propertyDefList;
        }
        ArrayList<IOlapBuilderPropertyDef> nlist = new ArrayList<IOlapBuilderPropertyDef>(propertyDefList);
        nlist.add(property);
        return nlist;
    }

    @Nullable
    protected OlapBuilderProperty getOrderMemberProperty(IOlapBuilderHierarchyLevelDef level) {
        return null;
    }

    @Override
    public String getContextVisualId() {
        return this.name;
    }

    @Override
    public void solveReference(OlapBuilderReferenceSolver referenceSolver, IOlapBuilderTabularDataDef dataView) {
        List<IOlapBuilderHierarchyLevelDef> levels = this.getLevels();
        if (levels != null) {
            int size = levels.size();
            for (int ii = 0; ii < size; ++ii) {
                IOlapBuilderHierarchyLevelDef level = levels.get(ii);
                referenceSolver.solveReference(level, dataView);
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public void setFolderName(@Nullable String folderName) {
        this.folderName = folderName;
    }

    @Override
    @Nullable
    public String getFolderName() {
        return this.folderName;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public boolean withCreateLevel() {
        return false;
    }

    @Override
    public IOlapBuilderBaseHierarchyLevelDef createEmptyLevel() {
        throw new RuntimeException("internal error: inconsistent usage of createEmptyLevel()");
    }
}

