/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.dimension;

import crazydev.common.collection.CdCollections;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderCommonHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderMultiLevelHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderParentChildHierarchy;
import crazydev.iccube.enums.OlapFactHierarchyAggregationType;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.enums.OlapMemberOrderKind;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderDynamicHierarchies {
    private final OlapDimension dimension;
    private final boolean includeUsedColumn;
    private final Solver dynHierIsColumn;
    private final Solver dynHierIsAttribute;
    private final Solver dynHierIsProperty;
    private final Solver dynHierName;
    private final Solver dynHierCaption;
    private final Solver dynHierLevelName;
    private final Solver dynAllMemberName;
    private final Solver dynIsKey;
    private final Solver dynIsOrderCol;
    private final Solver dynIsOrderByName;
    private final Solver dynIsOrderDESC;
    private final Solver dynMissingAttributeName;
    private final Solver dynFolder;
    private final Solver dynIsParentChildHierarchy;
    private final Solver dynAddAllMemberToParentChild;
    private final Solver dynIsParentChildKeyCol;
    private final Solver dynIsParentChildIdCol;
    private final Solver dynIsParentChildParentIdCol;

    private OlapBuilderDynamicHierarchies(OlapDimension dimension, boolean includeUsedColumn, String dynHierIsColumn, String dynHierIsAttribute, String dynHierIsProperty, String dynHierName, String dynHierCaption, String dynHierLevelName, String dynHierIsKey, String dynHierIsOrderCol, String dynIsOrderByName, String dynIsOrderDESC, String dynIsAllMember, String dynFolder, String dynMissingAttributeName, String dynIsParentChildHierarchy, String dynIsParentChildKeyCol, String dynIsParentChildIdCol, String dynIsParentChildParentIdCol, String dynAddAllMemberToParentChild) {
        this.dimension = dimension;
        this.includeUsedColumn = includeUsedColumn;
        this.dynHierIsColumn = new Solver(dynHierIsColumn, new String[0]);
        this.dynHierIsAttribute = new Solver(dynHierIsAttribute, new String[0]);
        this.dynHierIsProperty = new Solver(dynHierIsProperty, new String[0]);
        this.dynHierName = new Solver(dynHierName, new String[0]);
        this.dynHierCaption = new Solver(dynHierCaption, new String[0]);
        this.dynHierLevelName = new Solver(dynHierLevelName, new String[0]);
        this.dynIsKey = new Solver(dynHierIsKey, new String[0]);
        this.dynIsOrderCol = new Solver(dynHierIsOrderCol, new String[0]);
        this.dynIsOrderByName = new Solver(dynIsOrderByName, new String[0]);
        this.dynIsOrderDESC = new Solver(dynIsOrderDESC, new String[0]);
        this.dynAllMemberName = new Solver(dynIsAllMember, "$HierarchyName", "$HierarchyCaption");
        this.dynFolder = new Solver(dynFolder, new String[0]);
        this.dynMissingAttributeName = new Solver(dynMissingAttributeName, new String[0]);
        this.dynIsParentChildHierarchy = new Solver(dynIsParentChildHierarchy, new String[0]);
        this.dynIsParentChildIdCol = new Solver(dynIsParentChildIdCol, new String[0]);
        this.dynIsParentChildKeyCol = new Solver(dynIsParentChildKeyCol, new String[0]);
        this.dynIsParentChildParentIdCol = new Solver(dynIsParentChildParentIdCol, new String[0]);
        this.dynAddAllMemberToParentChild = new Solver(dynAddAllMemberToParentChild, new String[0]);
    }

    public static OlapBuilderDynamicHierarchies build(OlapDimension dimension, boolean includeUsedColumn, String dynHierIsColumn, String dynHierIsAttribute, String dynHierIsProperty, String dynHierName, String dynHierCaption, String dynHierLevelName, String dynHierIsKey, String dynHierIsOrderCol, String dynIsOrderByName, String dynIsOrderDESC, String dynIsAllMember, String dynFolder, String dynMissingAttributeName, String dynHierIsParentChildHierarchy, String dynIsParentChildKeyCol, String dynIsIdCol, String dynIsParentIdCol, String dynAddAllMemberToParentChild) {
        if (CdStringUtils.isNullOrBlank((String)dynHierIsColumn)) {
            return null;
        }
        return new OlapBuilderDynamicHierarchies(dimension, includeUsedColumn, dynHierIsColumn, dynHierIsAttribute, dynHierIsProperty, dynHierName, dynHierCaption, dynHierLevelName, dynHierIsKey, dynHierIsOrderCol, dynIsOrderByName, dynIsOrderDESC, dynIsAllMember, dynFolder, dynMissingAttributeName, dynHierIsParentChildHierarchy, dynIsParentChildKeyCol, dynIsIdCol, dynIsParentIdCol, dynAddAllMemberToParentChild);
    }

    public List<? extends IOlapBuilderHierarchyDef> addDynamicBuilders(OlapBuilderContext context, List<? extends IOlapBuilderHierarchyDef> defaultHierarchies, IOlapBuilderTabularDataDef tabularData) {
        ArrayList<? extends IOlapBuilderHierarchyDef> hs = new ArrayList<IOlapBuilderHierarchyDef>(defaultHierarchies);
        try {
            List<? extends IOlapBuilderHierarchyDef> additionalHierarchyBuilders = this.createDynamicBuilders(context, defaultHierarchies, tabularData);
            hs.addAll(additionalHierarchyBuilders);
        }
        catch (RuntimeException ex) {
            OlapLoggers.BUILDER.error((Object)"[dynamic-hierarchies] could not create the dynamic hierarchies", (Throwable)ex);
        }
        return hs;
    }

    private List<? extends IOlapBuilderHierarchyDef> createDynamicBuilders(OlapBuilderContext context, List<? extends IOlapBuilderHierarchyDef> defaultHierarchies, IOlapBuilderTabularDataDef tabularData) {
        List<IOlapBuilderDataColumnDef> tableCols;
        if (this.includeUsedColumn) {
            tableCols = tabularData.getSelectedColumns();
        } else {
            Set usedColumns = defaultHierarchies.stream().flatMap(builder -> builder.getLevels().stream()).flatMap(levelDef -> CdCollections.join(levelDef.getKeyColumns(), (Object)levelDef.getNameColumn()).stream()).collect(Collectors.toSet());
            tableCols = tabularData.getSelectedColumns().stream().filter(c -> !usedColumns.contains(c)).collect(Collectors.toList());
        }
        Map<String, List<IOlapBuilderDataColumnDef>> newHierarchies = tableCols.stream().filter(this.dynHierIsColumn::matches).collect(Collectors.groupingBy(c -> this.dynHierName.group((IOlapBuilderDataColumnDef)c, c.getName(), new String[0])));
        return newHierarchies.entrySet().stream().filter(entry -> CdStringUtils.isNotNullAndNotBlank((String)((String)entry.getKey()))).map(this::createDynamicBuilder).filter(Objects::nonNull).sorted((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName())).collect(Collectors.toList());
    }

    private OlapBuilderCommonHierarchy createDynamicBuilder(Map.Entry<String, List<IOlapBuilderDataColumnDef>> entry) {
        String hierName = entry.getKey();
        List<IOlapBuilderDataColumnDef> hierColumns = entry.getValue();
        try {
            String n;
            boolean isParentChildHierarchy = hierColumns.stream().anyMatch(this.dynIsParentChildHierarchy::matches);
            Predicate<IOlapBuilderDataColumnDef> isNotSpecialColumn = c -> !this.dynIsKey.matches((IOlapBuilderDataColumnDef)c) && !this.dynIsOrderCol.matches((IOlapBuilderDataColumnDef)c) && !this.dynIsKey.matches((IOlapBuilderDataColumnDef)c) && !this.dynIsParentChildIdCol.matches((IOlapBuilderDataColumnDef)c);
            OlapBuilderCommonHierarchy hier = !isParentChildHierarchy ? this.createMultiLevelHierarchy(hierColumns, hierName, isNotSpecialColumn) : this.createParentChildHierarchy(hierColumns, isNotSpecialColumn, hierName);
            if (hier == null) {
                return null;
            }
            hierColumns.stream().map(c -> this.dynHierCaption.group((IOlapBuilderDataColumnDef)c, null, new String[0])).filter(CdStringUtils::isNotNullAndNotBlank).findFirst().ifPresent(hier::setCaption);
            String captionForAllMember = CdStringUtils.isNullOrBlank((String)hier.getCaption()) ? hierName : hier.getCaption();
            Optional<String> allMember = hierColumns.stream().filter(isNotSpecialColumn).map(c -> this.dynAllMemberName.group((IOlapBuilderDataColumnDef)c, null, hierName, captionForAllMember)).findFirst();
            if (allMember.isPresent() && CdStringUtils.isNotNullAndNotBlank((String)(n = allMember.get()))) {
                hier.setHasAllLevel(true);
                hier.setAllMemberNameForDynHier(n);
            }
            hierColumns.stream().filter(isNotSpecialColumn).findFirst().ifPresent(c -> {
                String folder = this.dynFolder.group((IOlapBuilderDataColumnDef)c, null, new String[0]);
                if (CdStringUtils.isNotNullAndNotBlank((String)folder)) {
                    hier.setFolderName(folder);
                }
            });
            OlapHierarchy hierarchy = this.dimension.lookupHierarchyByName(OlapNameContext.DEFAULT_VALUES, hier.getName());
            if (hierarchy == null) {
                hier.setTupleDimensionalityIndex(-2);
            }
            return hier;
        }
        catch (RuntimeException ex) {
            OlapLoggers.BUILDER.error((Object)("[dynamic-hierarchies] could not create the dynamic hierarchy [" + hierName + "]"), (Throwable)ex);
            return null;
        }
    }

    @Nullable
    private OlapBuilderParentChildHierarchy createParentChildHierarchy(List<IOlapBuilderDataColumnDef> hierColumns, Predicate<IOlapBuilderDataColumnDef> isNotSpecialColumn, String hierName) {
        OlapBuilderParentChildHierarchy hier = hierColumns.stream().filter(isNotSpecialColumn).map(c -> {
            Optional<IOlapBuilderDataColumnDef> keyColumns = hierColumns.stream().filter(this.dynIsParentChildKeyCol::matches).findAny();
            Optional<IOlapBuilderDataColumnDef> id = hierColumns.stream().filter(this.dynIsParentChildIdCol::matches).findAny();
            Optional<IOlapBuilderDataColumnDef> parentIdCol = hierColumns.stream().filter(this.dynIsParentChildParentIdCol::matches).findAny();
            IOlapBuilderDataColumnDef cmemberName = c;
            IOlapBuilderDataColumnDef cId = id.get();
            IOlapBuilderDataColumnDef cmemberKey = keyColumns.orElse(cId);
            IOlapBuilderDataColumnDef cParentId = parentIdCol.get();
            OlapBuilderParentChildHierarchy parentChildHier = new OlapBuilderParentChildHierarchy(hierName, false, cId, cParentId, cmemberKey, cmemberName, new IOlapBuilderHierarchyLevelDef[0]);
            boolean addAllMember = this.dynAddAllMemberToParentChild.matches((IOlapBuilderDataColumnDef)c);
            if (!addAllMember) {
                parentChildHier.setFirstLevelIsAll();
            }
            parentChildHier.setFactAggregationType(OlapFactHierarchyAggregationType.MEMBER_ONLY);
            String levelName = this.dynHierLevelName.group((IOlapBuilderDataColumnDef)c, hierName, new String[0]);
            if (CdStringUtils.isNotNullAndNotBlank((String)levelName)) {
                parentChildHier.setLevelNamePattern(levelName);
            }
            Optional<IOlapBuilderDataColumnDef> orderColumn = hierColumns.stream().filter(this.dynIsOrderCol::matches).findAny();
            boolean isOrderByName = this.dynIsOrderByName.matches((IOlapBuilderDataColumnDef)c);
            boolean isOrderDESC = this.dynIsOrderDESC.matches((IOlapBuilderDataColumnDef)c);
            parentChildHier.setOrderMembersByType((OlapMemberOrderByType)OlapBuilderDynamicHierarchies.getEnumFromCol((IOlapBuilderDataColumnDef)c, (Enum[])OlapMemberOrderByType.values(), (Enum)(isOrderByName ? OlapMemberOrderByType.BY_NAME : OlapMemberOrderByType.BY_KEY)));
            parentChildHier.setOrderKind((OlapMemberOrderKind)OlapBuilderDynamicHierarchies.getEnumFromCol((IOlapBuilderDataColumnDef)c, (Enum[])OlapMemberOrderKind.values(), (Enum)(isOrderDESC ? OlapMemberOrderKind.DESC : OlapMemberOrderKind.ASC)));
            if (orderColumn.isPresent()) {
                parentChildHier.setOrderMembersByType(OlapMemberOrderByType.BY_COLUMN);
                parentChildHier.setOrderMembersColumn(orderColumn.get());
            }
            return parentChildHier;
        }).findFirst().orElse(null);
        return hier;
    }

    @Nullable
    private OlapBuilderCommonHierarchy createMultiLevelHierarchy(List<IOlapBuilderDataColumnDef> hierColumns, String hierName, Predicate<IOlapBuilderDataColumnDef> isNotSpecialColumn) {
        Map keyColumns = hierColumns.stream().filter(this.dynIsKey::matches).collect(Collectors.toMap(c -> this.dynHierLevelName.group((IOlapBuilderDataColumnDef)c, hierName, new String[0]), Function.identity()));
        Map orderColumns = hierColumns.stream().filter(this.dynIsOrderCol::matches).collect(Collectors.toMap(c -> this.dynHierLevelName.group((IOlapBuilderDataColumnDef)c, hierName, new String[0]), Function.identity()));
        List<IOlapBuilderHierarchyLevelDef> levels = hierColumns.stream().filter(isNotSpecialColumn).map(c -> {
            String missingAttributeName;
            String levelName = this.dynHierLevelName.group((IOlapBuilderDataColumnDef)c, hierName, new String[0]);
            if (CdStringUtils.isNullOrBlank((String)levelName)) {
                return null;
            }
            IOlapBuilderDataColumnDef keyColumn = (IOlapBuilderDataColumnDef)keyColumns.get(levelName);
            IOlapBuilderDataColumnDef orderColumn = (IOlapBuilderDataColumnDef)orderColumns.get(levelName);
            OlapBuilderHierarchyLevel builder = new OlapBuilderHierarchyLevel(levelName, null, (IOlapBuilderDataColumnDef)c, keyColumn, new IOlapBuilderPropertyDef[0]);
            boolean isOrderByName = this.dynIsOrderByName.matches((IOlapBuilderDataColumnDef)c);
            boolean isOrderDESC = this.dynIsOrderDESC.matches((IOlapBuilderDataColumnDef)c);
            builder.setOrderMembersByType((OlapMemberOrderByType)OlapBuilderDynamicHierarchies.getEnumFromCol((IOlapBuilderDataColumnDef)c, (Enum[])OlapMemberOrderByType.values(), (Enum)(isOrderByName ? OlapMemberOrderByType.BY_NAME : OlapMemberOrderByType.BY_KEY)));
            builder.setOrderKind((OlapMemberOrderKind)OlapBuilderDynamicHierarchies.getEnumFromCol((IOlapBuilderDataColumnDef)c, (Enum[])OlapMemberOrderKind.values(), (Enum)(isOrderDESC ? OlapMemberOrderKind.DESC : OlapMemberOrderKind.ASC)));
            if (orderColumn != null) {
                builder.setOrderMembersByType(OlapMemberOrderByType.BY_COLUMN);
                builder.setOrderMembersColumn(orderColumn);
            }
            if (CdStringUtils.isNotNullAndNotBlank((String)(missingAttributeName = this.dynMissingAttributeName.group((IOlapBuilderDataColumnDef)c, null, new String[0])))) {
                builder.setAttributeNameIfNull(missingAttributeName);
            }
            return builder;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (levels.isEmpty()) {
            return null;
        }
        OlapBuilderMultiLevelHierarchy hier = new OlapBuilderMultiLevelHierarchy(hierName, false, levels);
        return hier;
    }

    private static <T extends Enum<T>> T getEnumFromCol(IOlapBuilderDataColumnDef c, T[] values, T defaultValue) {
        String definition = c.getName();
        for (T value : values) {
            String enumName = ((Enum)value).name();
            if (!definition.contains(":" + enumName)) continue;
            return value;
        }
        return defaultValue;
    }

    public static class Solver {
        @Nullable
        private final Pattern pattern;
        private final String stringPattern;
        private final String[] stringPatterParameter;

        public Solver(String definition, String ... stringPatterParameter) {
            String[] stringArray = this.stringPatterParameter = stringPatterParameter == null ? new String[]{} : stringPatterParameter;
            if (CdStringUtils.isNotNullAndNotBlank((String)definition)) {
                if (definition.startsWith("\\")) {
                    try {
                        this.pattern = Pattern.compile(definition.substring(1), 2);
                    }
                    catch (RuntimeException ex) {
                        throw new OlapBuilderErrorException(OlapBuilderErrorCode.INVALID_JAVA_REGEXP, new Serializable[]{definition, ex.getMessage()});
                    }
                    this.stringPattern = null;
                } else {
                    this.pattern = null;
                    this.stringPattern = CdStringUtils.isNotNullAndNotBlank((String)definition) ? definition : null;
                }
            } else {
                this.pattern = null;
                this.stringPattern = null;
            }
        }

        public boolean matches(IOlapBuilderDataColumnDef column) {
            if (this.pattern != null) {
                return this.pattern.matcher(column.getName()).matches();
            }
            return this.stringPattern != null;
        }

        public String group(IOlapBuilderDataColumnDef column, String defaultValue, String ... extraParameter) {
            if (this.pattern == null) {
                return this.evaluateStringPattern(defaultValue, extraParameter);
            }
            Matcher matcher = this.pattern.matcher(column.getName());
            try {
                return matcher.matches() ? matcher.group(1) : defaultValue;
            }
            catch (RuntimeException ex) {
                return defaultValue;
            }
        }

        private String evaluateStringPattern(String defaultValue, String ... extraParameters) {
            if (this.stringPattern == null) {
                return defaultValue;
            }
            if (this.stringPatterParameter == null) {
                return this.stringPattern;
            }
            int end = Math.min(this.stringPatterParameter.length, extraParameters != null ? extraParameters.length : 0);
            String ret = this.stringPattern;
            for (int i = 0; i < end; ++i) {
                String pattern = this.stringPatterParameter[i];
                String parameter = extraParameters[i];
                ret = ret.replace(pattern, parameter);
            }
            return ret;
        }
    }
}

