/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.dimension;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.impl.OlapBuilderNamedDefinitionHelper;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderBaseDimension;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderBaseHierarchy;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElementRef;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderBaseExDimension<T extends IOlapBuilderHierarchyDef>
extends OlapBuilderBaseDimension<T> {
    public static final CdProperty UNKNOWN_MEMBER_NAME = new CdReadWriteProperty(OlapBuilderBaseExDimension.class, "unknownMemberName");
    @XmlElementRef(type=OlapBuilderBaseHierarchy.class)
    protected final List<T> hierarchies = new ArrayList<T>();
    @XmlAttribute(required=false)
    private String unknownMemberName;

    protected OlapBuilderBaseExDimension() {
    }

    protected OlapBuilderBaseExDimension(String name, String id) {
        super(name, id);
    }

    protected OlapBuilderBaseExDimension(String name, String id, List<T> hierarchies) {
        this(name, id);
        this.hierarchies.addAll(hierarchies);
    }

    @Override
    protected void resetHierarchyUUIDs() {
        if (this.hierarchies != null) {
            for (IOlapBuilderHierarchyDef hierarchy : this.hierarchies) {
                hierarchy.resetUUID();
            }
        }
    }

    @Override
    public List<T> getHierarchies() {
        return this.hierarchies;
    }

    @Override
    public List<String> getHierarchyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IOlapBuilderHierarchyDef hierarchy : this.hierarchies) {
            String name = hierarchy.getName();
            if (!CdStringUtils.isNotNullAndNotBlank((String)name)) continue;
            names.add(name);
        }
        return names;
    }

    @Override
    @Nullable
    public IOlapBuilderHierarchyDef getHierarchy(String name) {
        for (IOlapBuilderHierarchyDef hierarchy : this.hierarchies) {
            if (!hierarchy.getName().equals(name)) continue;
            return hierarchy;
        }
        return null;
    }

    @Override
    public boolean orderHierarchies(List<String> orderedNames) {
        return OlapBuilderNamedDefinitionHelper.order(this.hierarchies, orderedNames);
    }

    @Override
    public boolean changesOnIncrementalLoad() {
        return true;
    }

    @Override
    public void addHierarchy(T hierarchy) {
        this.hierarchies.add(hierarchy);
    }

    @Override
    public boolean removeHierarchy(T hierarchy) {
        return this.hierarchies.remove(hierarchy);
    }

    @Override
    public String getUnknownMemberName() {
        return this.unknownMemberName;
    }

    public void setUnknownMemberName(String unknownMemberName) {
        this.unknownMemberName = unknownMemberName;
    }
}

