/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.colors;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.builders.OlapBuilderAbstractTableListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.olap.schema.colors.OlapSchemaColors;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderColorsBuilder
extends OlapBuilderAbstractTableListener {
    private final OlapSchemaColors colors;
    private volatile ResolvedColumns resolvedColumns;

    public OlapBuilderColorsBuilder(OlapSchemaColors colors) {
        this.colors = colors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTableProcessingStarted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        super.onTableProcessingStarted(context, tabularData);
        OlapSchemaColors olapSchemaColors = this.colors;
        synchronized (olapSchemaColors) {
            this.colors.onProcessingStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        super.onTableProcessingCompleted(context, tabularData);
        OlapSchemaColors olapSchemaColors = this.colors;
        synchronized (olapSchemaColors) {
            this.colors.onProcessingDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        ResolvedColumns resColumns = this.getResolvedColumns(columns);
        Comparable color = data.getJavaNativeDataValue(resColumns.color);
        Comparable name = resColumns.name != null ? data.getJavaNativeDataValue(resColumns.name) : null;
        Comparable level = resColumns.level != null ? data.getJavaNativeDataValue(resColumns.level) : null;
        Comparable hierarchy = resColumns.hierarchy != null ? data.getJavaNativeDataValue(resColumns.hierarchy) : null;
        Comparable dimension = resColumns.dimension != null ? data.getJavaNativeDataValue(resColumns.dimension) : null;
        Comparable uniqueName = resColumns.uniqueName != null ? data.getJavaNativeDataValue(resColumns.uniqueName) : null;
        OlapSchemaColors olapSchemaColors = this.colors;
        synchronized (olapSchemaColors) {
            this.colors.addColor(color, name, level, hierarchy, dimension, uniqueName);
        }
        return true;
    }

    private ResolvedColumns getResolvedColumns(List<IOlapBuilderDataColumnDef> columns) {
        ResolvedColumns resColumns = this.resolvedColumns;
        if (resColumns != null) {
            return resColumns;
        }
        IOlapBuilderDataColumnDef colColor = OlapBuilderColorsBuilder.getColumn(columns, "color");
        if (colColor == null) {
            throw new RuntimeException("internal error: unexpected missing 'color' column");
        }
        IOlapBuilderDataColumnDef colName = OlapBuilderColorsBuilder.getColumn(columns, "name");
        if (colName == null) {
            throw new RuntimeException("internal error: unexpected missing 'name' column");
        }
        IOlapBuilderDataColumnDef colLevel = OlapBuilderColorsBuilder.getColumn(columns, "level");
        IOlapBuilderDataColumnDef colHierarchy = OlapBuilderColorsBuilder.getColumn(columns, "hierarchy");
        IOlapBuilderDataColumnDef colDimension = OlapBuilderColorsBuilder.getColumn(columns, "dimension");
        IOlapBuilderDataColumnDef colUName = OlapBuilderColorsBuilder.getColumn(columns, "uniqueName");
        this.resolvedColumns = new ResolvedColumns(colColor, colUName, colName, colLevel, colHierarchy, colDimension);
        return this.resolvedColumns;
    }

    @Nullable
    private static IOlapBuilderDataColumnDef getColumn(List<IOlapBuilderDataColumnDef> columns, String name) {
        for (IOlapBuilderDataColumnDef column : columns) {
            if (!name.equalsIgnoreCase(column.getName())) continue;
            return column;
        }
        return null;
    }

    static class ResolvedColumns {
        final IOlapBuilderDataColumnDef color;
        final IOlapBuilderDataColumnDef uniqueName;
        final IOlapBuilderDataColumnDef name;
        @Nullable
        final IOlapBuilderDataColumnDef level;
        @Nullable
        final IOlapBuilderDataColumnDef hierarchy;
        @Nullable
        final IOlapBuilderDataColumnDef dimension;

        public ResolvedColumns(IOlapBuilderDataColumnDef color, IOlapBuilderDataColumnDef uniqueName, IOlapBuilderDataColumnDef name, @Nullable IOlapBuilderDataColumnDef level, @Nullable IOlapBuilderDataColumnDef hierarchy, @Nullable IOlapBuilderDataColumnDef dimension) {
            this.color = color;
            this.name = name;
            this.level = level;
            this.hierarchy = hierarchy;
            this.dimension = dimension;
            this.uniqueName = uniqueName;
        }
    }
}

