/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.browsing;

import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.browsing.IOlapBuilderBrowsingDataTableInfo;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTableRow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class OlapBuilderBrowsingDataTableInfoWithPredicate
implements IOlapBuilderBrowsingDataTableInfo,
Predicate<IOlapBuilderTableRow> {
    private final IOlapBuilderTabularDataDef tabularData;
    private final AtomicInteger rowCount = new AtomicInteger();
    private final Predicate<IOlapBuilderTableRow> visitor;
    private final int maxRows;
    private boolean done = false;

    public OlapBuilderBrowsingDataTableInfoWithPredicate(IOlapBuilderTabularDataDef tabularData, Predicate<IOlapBuilderTableRow> visitor, int maxRows) {
        this.tabularData = tabularData;
        this.visitor = visitor;
        this.maxRows = maxRows;
    }

    @Override
    public boolean isAttachedTo(IOlapBuilderTabularDataDef tabularData) {
        return this.tabularData == tabularData;
    }

    @Override
    public void onRowBrowsed(OlapBuilderBaseDataTableRow row) {
        if (this.rowCount.incrementAndGet() > this.maxRows && this.maxRows != -1) {
            this.done = true;
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public int getMaxRowCount() {
        return this.maxRows;
    }

    @Override
    public boolean test(IOlapBuilderTableRow row) {
        if (!this.visitor.test(row)) {
            this.done = true;
            return false;
        }
        return true;
    }
}

