/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl;

import crazydev.common.javacompiler.CompilationException;
import crazydev.common.javacompiler.CompiledCode;
import crazydev.common.javacompiler.DynamicClassLoader;
import crazydev.common.javacompiler.InMemoryJavaCompiler;
import crazydev.common.javacompiler.SourceCode;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderJavaCompilationError;
import crazydev.iccube.builder.model.def.IOlapBuilderScriptDef;
import crazydev.iccube.builder.model.impl.OlapBuilderScriptError;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionNativeBodyExpression;
import crazydev.iccube.mdx.parser.ast.expression.script.MdxScriptExpression;
import crazydev.iccube.mdx.parser.ast.statement.MdxStatementExpression;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.compiler.ast.function.MdxNativeFunctionExpressionCompiler;
import crazydev.iccube.olap.compiler.exception.OlapCompilationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.exception.OlapJavaNativeCompilationEvaluationException;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.eval.select.context.OlapCreateFunctionStatementExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="script")
public class OlapBuilderScript
implements IOlapBuilderScriptDef {
    public static final CdProperty CONTENT = new CdReadWriteProperty(OlapBuilderScript.class, "content");
    @XmlElement(name="content", required=true)
    private String content;
    @XmlElement(name="nativeFunctionByteCode", required=false)
    @Nullable
    private List<CompiledCode> nativeFunctionByteCode;

    public OlapBuilderScript() {
    }

    public OlapBuilderScript(String content) {
        this.content = content;
    }

    public OlapBuilderScript addSuffix(String suffix) {
        if (CdStringUtils.isNullOrBlank((String)suffix)) {
            return this;
        }
        this.content = CdStringUtils.isNotNullAndNotBlank((String)this.content) ? this.content + suffix : suffix;
        return this;
    }

    public void fixNativeFunctionsCode() {
        CompiledCode code = this.getExistingCompiledCode();
        if (code != null) {
            DynamicClassLoader cl = new DynamicClassLoader(this.getClass().getClassLoader(), 0);
            cl.addCode(code);
            if (cl.hasClass("icCube.nativeFunctions.Functions")) {
                OlapLoggers.BUILDER.warn((Object)"[builder] format of the existing native JAVA functions not supported anymore : recompile is required");
                this.nativeFunctionByteCode = null;
            }
        }
    }

    @Override
    public String getName() {
        return "script";
    }

    @Override
    public String getContextVisualId() {
        return this.getName();
    }

    @Override
    public String getContent() {
        return this.content == null ? "" : this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<CompiledCode> getCompiledCodes() {
        return this.nativeFunctionByteCode != null ? this.nativeFunctionByteCode : new ArrayList<CompiledCode>();
    }

    public void generateScriptNativeByteCode(OlapBuilderValidationContext context, MdxScriptExpression expression) throws OlapBuilderScriptError {
        CompiledCode compiledCode;
        List<MdxNativeFunctionExpressionCompiler.NativeInfo> functions = this.extractNativeFunctions(expression.getStatements());
        if (!functions.isEmpty()) {
            if (!context.isJavaMdxNativesActivated()) {
                throw new OlapBuilderScriptError(new OlapBuilderError(OlapBuilderErrorCode.NATIVE_FUNCTION_ERROR, new Serializable[]{"functions", "JAVA native functions are not available"}));
            }
            List<SourceCode> compilationUnits = OlapBuilderScript.generateCompilationUnits(functions);
            CompiledCode compiledCodePrev = this.getExistingCompiledCode();
            if (compiledCodePrev != null && compiledCodePrev.checkSourceCode(compilationUnits)) {
                OlapLoggers.BUILDER.info((Object)"[builder] native JAVA functions compilation not required");
                return;
            }
            OlapLoggers.BUILDER.debug((Object)("[builder] native JAVA functions compilation : \n" + OlapBuilderScript.sourceCodeForError(compilationUnits)));
            compiledCode = OlapBuilderScript.compileForScript(compilationUnits);
        } else {
            compiledCode = null;
        }
        if (compiledCode == null) {
            this.nativeFunctionByteCode = null;
        } else {
            if (this.nativeFunctionByteCode == null) {
                this.nativeFunctionByteCode = new ArrayList<CompiledCode>();
            }
            this.nativeFunctionByteCode.clear();
            this.nativeFunctionByteCode.add(compiledCode);
        }
    }

    public static CompiledCode generateNativeByteCode(OlapCreateFunctionStatementExecutionContext context, @Nullable DynamicClassLoader classpath, OlapDeclaredFunction function, MdxNativeFunctionExpressionCompiler.NativeInfo nativeFunction) throws OlapEvaluationException {
        OlapErrorLocation errorLocation = function.getLocationRange();
        if (!context.isJavaMdxNativesActivated()) {
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.NOT_AUTHORIZED, new Serializable[]{"JAVA native functions"});
        }
        if (classpath != null && classpath.hasClass("icCube.nativeFunctions." + function.getName())) {
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.DUPLICATED_FUNCTION, new Serializable[]{function.getName()});
        }
        List<MdxNativeFunctionExpressionCompiler.NativeInfo> functions = List.of(nativeFunction);
        List<SourceCode> compilationUnits = OlapBuilderScript.generateCompilationUnits(functions);
        OlapLoggers.MDX_EVALUATION.debug((Object)("[builder] native JAVA functions compilation : \n" + OlapBuilderScript.sourceCodeForError(compilationUnits)));
        try {
            return OlapBuilderScript.compile(classpath, compilationUnits);
        }
        catch (CompilationException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)"create JAVA native function error", (Throwable)ex);
            throw new OlapJavaNativeCompilationEvaluationException(errorLocation, function.getName(), ex.getMessage(), OlapBuilderScript.sourceCodeForError(compilationUnits), ex);
        }
    }

    private List<MdxNativeFunctionExpressionCompiler.NativeInfo> extractNativeFunctions(List<MdxStatementExpression> statements) throws OlapBuilderScriptError {
        ArrayList<MdxNativeFunctionExpressionCompiler.NativeInfo> functions = new ArrayList<MdxNativeFunctionExpressionCompiler.NativeInfo>();
        for (MdxStatementExpression statement : statements) {
            MdxFunctionNativeBodyExpression function = statement.getNativeFunctionSourceCode();
            if (function == null) continue;
            try {
                OlapCompilationExceptionContext errContext = () -> MdxEntityCompiler.createRange(function);
                MdxNativeFunctionExpressionCompiler.NativeInfo info = MdxNativeFunctionExpressionCompiler.extractNativeInfo(errContext, function);
                if (!"JAVA".equals(info.moduleName) && !"J".equals(info.moduleName)) continue;
                functions.add(info);
            }
            catch (IOException ex) {
                OlapLoggers.BUILDER.error((Object)("JAVA native function (" + function.getFunctionName() + ") error"), (Throwable)ex);
                throw new OlapBuilderScriptError(new OlapBuilderError(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{ex.getMessage(), "JAVA native function (" + function.getFunctionName() + ") error"}));
            }
        }
        return functions;
    }

    @Nullable
    private CompiledCode getExistingCompiledCode() {
        if (this.nativeFunctionByteCode == null || this.nativeFunctionByteCode.isEmpty()) {
            return null;
        }
        return this.nativeFunctionByteCode.get(0);
    }

    private static CompiledCode compile(@Nullable DynamicClassLoader classpath, List<SourceCode> compilationUnits) throws CompilationException {
        if (!InMemoryJavaCompiler.hasJavaCompilerInstalled()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.JDK_NOT_INSTALLED, new Serializable[]{"native functions"});
        }
        InMemoryJavaCompiler javaCompiler = InMemoryJavaCompiler.newDefaultInstance((int)0);
        CompiledCode byteCode = javaCompiler.compile(classpath, compilationUnits);
        byteCode.setSourceCode(compilationUnits);
        return byteCode;
    }

    private static CompiledCode compileForScript(List<SourceCode> compilationUnits) throws OlapBuilderScriptError {
        try {
            return OlapBuilderScript.compile(null, compilationUnits);
        }
        catch (CompilationException ex) {
            OlapLoggers.BUILDER.error((Object)"native functions error", (Throwable)ex);
            throw new OlapBuilderScriptError(new OlapBuilderJavaCompilationError(OlapBuilderScript.sourceCodeForError(compilationUnits), ex));
        }
    }

    private static List<SourceCode> generateCompilationUnits(List<MdxNativeFunctionExpressionCompiler.NativeInfo> functions) {
        ArrayList<SourceCode> compilationUnits = new ArrayList<SourceCode>();
        List<String> imports = OlapBuilderScript.generateCompilationUnitsImports(functions);
        List<String> methods = OlapBuilderScript.generateCompilationUnitsMethods(functions);
        for (int ff = 0; ff < functions.size(); ++ff) {
            MdxNativeFunctionExpressionCompiler.NativeInfo function = functions.get(ff);
            StringBuilder sourceCode = new StringBuilder();
            sourceCode.append("package ").append("icCube.nativeFunctions").append(";\n").append("\n").append("import java.lang.*;").append("\n").append("import java.util.*;").append("\n").append("import java.util.stream.*;").append("\n").append("\n").append("import org.joda.time.*;").append("\n").append("\n").append("import crazydev.iccube.pub.olap.*;").append("\n").append("import crazydev.iccube.pub.utils.*;").append("\n").append("\n").append(imports.get(ff)).append("\n").append("public class ").append(function.getFunctionName()).append("\n").append("{ \n").append(methods.get(ff)).append("} \n");
            compilationUnits.add(new SourceCode("icCube.nativeFunctions." + function.getFunctionName(), sourceCode.toString()));
        }
        return compilationUnits;
    }

    private static List<String> generateCompilationUnitsImports(List<MdxNativeFunctionExpressionCompiler.NativeInfo> functions) {
        ArrayList<String> compilationUnitsImports = new ArrayList<String>();
        for (MdxNativeFunctionExpressionCompiler.NativeInfo function : functions) {
            List<String> functionImports = OlapBuilderScript.extractImports(function.bodyLines);
            HashSet<String> imports = new HashSet<String>(functionImports);
            StringBuilder sourceCode = new StringBuilder();
            for (String import_ : imports) {
                sourceCode.append(import_).append("\n");
            }
            compilationUnitsImports.add(sourceCode.toString());
        }
        return compilationUnitsImports;
    }

    private static List<String> generateCompilationUnitsMethods(List<MdxNativeFunctionExpressionCompiler.NativeInfo> functions) {
        ArrayList<String> compilationUnitsMethods = new ArrayList<String>();
        for (MdxNativeFunctionExpressionCompiler.NativeInfo function : functions) {
            String annotation = OlapBuilderScript.extractAnnotation(function.mdx);
            String signature = OlapBuilderScript.extractSignature(function.extra, function.mdx);
            String body = OlapBuilderScript.extractBody(function.bodyLines);
            StringBuilder methods = new StringBuilder();
            methods.append("  ").append(annotation != null ? annotation : "").append("\n").append("  ").append(signature).append("\n").append("  {\n").append(body).append("  }\n").append("\n");
            compilationUnitsMethods.add(methods.toString());
        }
        return compilationUnitsMethods;
    }

    @Nullable
    private static String extractAnnotation(MdxFunctionNativeBodyExpression function) {
        int argCount = function.getFunctionArgCount();
        if (argCount == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder("@crazydev.common.lang.CdMethodParams({");
        for (int ii = 0; ii < argCount; ++ii) {
            if (ii > 0) {
                sb.append(",");
            }
            String argName = function.getFunctionArgName(ii);
            sb.append("\"").append(argName).append("\"");
        }
        sb.append("})");
        return sb.toString();
    }

    private static String extractSignature(@Nullable String extra, MdxFunctionNativeBodyExpression function) {
        String returnType = extra != null ? extra : "Object";
        StringBuilder sb = new StringBuilder("public static " + returnType + " " + function.getFunctionName() + "(");
        int argCount = function.getFunctionArgCount();
        for (int ii = 0; ii < argCount; ++ii) {
            if (ii > 0) {
                sb.append(",");
            }
            String argName = function.getFunctionArgName(ii);
            String argType = function.getFunctionArgType(ii);
            String javaType = argType == null ? "Object" : argType;
            sb.append(javaType).append(" ").append(argName);
        }
        sb.append(" )");
        return sb.toString();
    }

    private static List<String> extractImports(List<String> lines) {
        ArrayList<String> imports = new ArrayList<String>();
        for (int ii = 0; ii < lines.size(); ++ii) {
            String line = lines.get(ii);
            if (!line.trim().startsWith("import")) continue;
            imports.add(line.trim());
        }
        return imports;
    }

    private static String extractBody(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 1; ii < lines.size() - 1; ++ii) {
            String line = lines.get(ii);
            if (line.trim().startsWith("import")) continue;
            sb.append("    ").append(line.trim());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String sourceCodeForError(List<SourceCode> compilationUnits) {
        StringBuilder sb = new StringBuilder();
        for (SourceCode compilationUnit : compilationUnits) {
            sb.append(compilationUnit.getCharContent(true)).append("\n\n");
        }
        return sb.toString();
    }
}

