/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl;

import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdLocaleXmlAdapter;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.factory.schema.OlapBuilderBaseSchemaDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCalcMemberDef;
import crazydev.iccube.builder.model.def.IOlapBuilderColorsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDiagramTablePositionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderFunctionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderLocalizationDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedSetDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderValidationEnabled;
import crazydev.iccube.builder.model.def.OlapBuilderStoragePolicy;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.OlapBuilderCalcMember;
import crazydev.iccube.builder.model.impl.OlapBuilderCube;
import crazydev.iccube.builder.model.impl.OlapBuilderDataViewLinks;
import crazydev.iccube.builder.model.impl.OlapBuilderDiagramTablePosition;
import crazydev.iccube.builder.model.impl.OlapBuilderFunction;
import crazydev.iccube.builder.model.impl.OlapBuilderNamedDefinitionHelper;
import crazydev.iccube.builder.model.impl.OlapBuilderNamedSet;
import crazydev.iccube.builder.model.impl.OlapBuilderPerspective;
import crazydev.iccube.builder.model.impl.OlapBuilderScript;
import crazydev.iccube.builder.model.impl.colors.OlapBuilderColors;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderBaseDimension;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyUniqueNameStyle;
import crazydev.iccube.builder.model.impl.localization.OlapBuilderLocalization;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.builder.model.validation.OlapBuilderSchemaValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.BackupType;
import crazydev.iccube.builder.type.DistinctCountOptimType;
import crazydev.iccube.builder.type.MemberPropertyConsistencyCheckType;
import crazydev.iccube.builder.type.MembersUpperLowerStrategyType;
import crazydev.iccube.builder.type.NonEmptyCachePersistency;
import crazydev.iccube.builder.type.NonEmptyCachePolicy;
import crazydev.iccube.builder.type.NonEmptyCacheType;
import crazydev.iccube.builder.type.SchemaGarbageCollectorType;
import jakarta.xml.bind.annotation.XmlAccessOrder;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorOrder;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="schemaDefinition")
@XmlAccessorOrder(value=XmlAccessOrder.ALPHABETICAL)
public class OlapBuilderSchema
implements IOlapBuilderSchemaDef,
IOlapBuilderJaxbListener {
    public static boolean TEST_INCR_LOAD_ACTIVATED = true;
    @XmlElementRefs(value={@XmlElementRef(name="viewLinks", type=OlapBuilderDataViewLinks.class)})
    private final List<IOlapBuilderDataViewLinksDef> links = new ArrayList<IOlapBuilderDataViewLinksDef>();
    @XmlElementRefs(value={@XmlElementRef(name="dimension", type=OlapBuilderBaseDimension.class)})
    private final List<IOlapBuilderDimensionDef> dimensions = new ArrayList<IOlapBuilderDimensionDef>();
    @XmlElementRefs(value={@XmlElementRef(name="cube", type=OlapBuilderCube.class)})
    private final List<IOlapBuilderCubeDef> cubes = new ArrayList<IOlapBuilderCubeDef>();
    @XmlElementRefs(value={@XmlElementRef(name="perspectives", type=OlapBuilderPerspective.class)})
    private final List<IOlapBuilderPerspectiveDef> perspectives = new ArrayList<IOlapBuilderPerspectiveDef>();
    @XmlAnyElement
    private Object fallback;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute(required=true)
    private String description;
    @XmlAttribute
    private String group;
    @XmlAttribute(name="loadOnStartup")
    private Boolean loadOnStartup;
    @XmlElement(name="activateIncrementalLoad")
    private boolean activateIncrementalLoad;
    @XmlElement(name="useUnknownMembersInFacts")
    private boolean useUnknownMembersInFacts = true;
    @XmlElement(name="distinctCountOptim")
    private DistinctCountOptimType distinctCountOptim;
    @XmlElement(name="autoCleanUpTableColumns")
    private boolean autoCleanUpTableColumns;
    @XmlElement(name="acceptSpaceAsMemberName")
    private Boolean acceptSpaceAsMemberName;
    @XmlElement(name="useFactPartitioning")
    private boolean useFactPartitioning;
    @XmlElement(name="callGarbageCollector")
    private SchemaGarbageCollectorType callGarbageCollector;
    @XmlElement(name="memberPropertyConsistencyCheck", required=false)
    @Nullable
    private MemberPropertyConsistencyCheckType memberPropertyConsistencyCheck;
    @XmlElement(name="backup")
    private BackupType backup;
    @XmlElement(name="disableAutoAttributes")
    private Boolean disableAutoAttributes;
    @XmlElement(name="nonEmptyCachePolicy")
    private NonEmptyCachePolicy nonEmptyCachePolicy;
    @XmlElement(name="nonEmptyCacheType")
    private NonEmptyCacheType nonEmptyCacheType;
    @XmlElement(name="nonEmptyCachePersistency")
    private NonEmptyCachePersistency nonEmptyCachePersistency;
    @XmlJavaTypeAdapter(value=CdLocaleXmlAdapter.class)
    @XmlElement(name="schemaLocalizationFallbackLocale", required=false)
    @Nullable
    private Locale schemaLocalizationFallbackLocale;
    @XmlJavaTypeAdapter(value=CdLocaleXmlAdapter.class)
    @XmlElement(name="localeForStringCompare", required=false)
    @Nullable
    private Locale localeForStringCompare;
    @XmlElement(name="mmapFacts", required=false)
    @Nullable
    private Boolean _mmapFacts;
    @XmlElement(name="storagePolicy")
    private OlapBuilderStoragePolicy storagePolicy;
    @XmlElement(name="cacheTable", required=false)
    @Nullable
    private Boolean cacheTable;
    @XmlElement(name="hierarchyUniqueNameStyle")
    private OlapBuilderHierarchyUniqueNameStyle hierarchyUniqueNameStyle;
    @XmlElement(name="mergeToSchema", required=false)
    @Nullable
    private String _mergeToSchema;
    @XmlElement(name="reverseLink", required=false)
    @Nullable
    private Boolean reverseLink;
    @XmlElementRef(type=OlapBuilderBaseDataSource.class)
    private List<IOlapBuilderDataSource> datasources = new ArrayList<IOlapBuilderDataSource>();
    @XmlElementRefs(value={@XmlElementRef(name="views", type=OlapBuilderBaseDataView.class)})
    private List<IOlapBuilderDataViewDef> views = new ArrayList<IOlapBuilderDataViewDef>();
    @XmlElementRefs(value={@XmlElementRef(name="diagramPosition", type=OlapBuilderDiagramTablePosition.class)})
    private List<IOlapBuilderDiagramTablePositionDef> diagramTablePositions = new ArrayList<IOlapBuilderDiagramTablePositionDef>();
    @XmlElementRef(name="localization", type=OlapBuilderLocalization.class)
    private IOlapBuilderLocalizationDef localization;
    @XmlElementRef(name="colors", type=OlapBuilderColors.class)
    private IOlapBuilderColorsDef colors;
    @XmlElementRef(name="script", type=OlapBuilderScript.class)
    private OlapBuilderScript script;
    @XmlElement(name="loadOnStartup")
    private Boolean _loadOnStartup;
    @XmlElement(name="membersUpperLowerCaseStrategy")
    private MembersUpperLowerStrategyType membersUpperLowerCaseStrategy;
    @XmlElementRefs(value={@XmlElementRef(name="calculatedMember", type=OlapBuilderCalcMember.class)})
    private List<IOlapBuilderCalcMemberDef> _calcMembers = new ArrayList<IOlapBuilderCalcMemberDef>();
    @XmlElementRefs(value={@XmlElementRef(name="function", type=OlapBuilderFunction.class)})
    private List<IOlapBuilderFunctionDef> _functions = new ArrayList<IOlapBuilderFunctionDef>();
    @XmlElementRefs(value={@XmlElementRef(name="namedSet", type=OlapBuilderNamedSet.class)})
    private List<IOlapBuilderNamedSetDef> _namedSets = new ArrayList<IOlapBuilderNamedSetDef>();
    @XmlTransient
    private File xmlFile;

    public OlapBuilderSchema() {
    }

    public OlapBuilderSchema(String name, String description, String group) {
        this(name, description, group, false, false);
    }

    public OlapBuilderSchema(String name, String description, String group, boolean autoCleanUpTableColumns, boolean activateIncrementalLoad) {
        this.name = name;
        this.description = description;
        this.group = group;
        this.autoCleanUpTableColumns = autoCleanUpTableColumns;
        this.activateIncrementalLoad = activateIncrementalLoad;
    }

    @Nullable
    public File getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public String name_() {
        return this.name;
    }

    public String name_(String name) {
        this.name = name;
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String description_() {
        return this.description;
    }

    public String description_(String description) {
        this.description = description;
        return this.description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String group_() {
        return this.group;
    }

    public String group_(String group) {
        this.group = group;
        return this.group;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean activateIncrementalLoad_() {
        return this.activateIncrementalLoad && TEST_INCR_LOAD_ACTIVATED;
    }

    public boolean activateIncrementalLoad_(boolean activateIncrementalLoad) {
        this.activateIncrementalLoad = activateIncrementalLoad;
        return this.activateIncrementalLoad;
    }

    @Override
    public boolean activateIncrementalLoad() {
        return this.activateIncrementalLoad && TEST_INCR_LOAD_ACTIVATED;
    }

    public void setActivateIncrementalLoad(boolean activateIncrementalLoad) {
        this.activateIncrementalLoad = activateIncrementalLoad;
    }

    public boolean autoCleanUpTableColumns_() {
        return this.autoCleanUpTableColumns;
    }

    public boolean autoCleanUpTableColumns_(boolean autoCleanUpTableColumns) {
        this.autoCleanUpTableColumns = autoCleanUpTableColumns;
        return this.autoCleanUpTableColumns;
    }

    @Override
    public boolean autoCleanUpTableColumns() {
        return this.autoCleanUpTableColumns;
    }

    public void setAutoCleanUpTableColumns(boolean autoCleanUpTableColumns) {
        this.autoCleanUpTableColumns = autoCleanUpTableColumns;
    }

    public boolean useUnknownMembersInFacts_() {
        return this.useUnknownMembersInFacts;
    }

    public boolean useUnknownMembersInFacts_(boolean useUnknownMembersInFacts) {
        this.useUnknownMembersInFacts = useUnknownMembersInFacts;
        return this.useUnknownMembersInFacts;
    }

    public boolean isUseUnknownMembersInFacts() {
        return this.useUnknownMembersInFacts;
    }

    public void setUseUnknownMembersInFacts(boolean useUnknownMembersInFacts) {
        this.useUnknownMembersInFacts = useUnknownMembersInFacts;
    }

    public OlapBuilderStoragePolicy storagePolicy_() {
        return this.storagePolicy;
    }

    public OlapBuilderStoragePolicy storagePolicy_(OlapBuilderStoragePolicy storagePolicy) {
        this.storagePolicy = storagePolicy;
        return this.storagePolicy;
    }

    @Override
    public OlapBuilderStoragePolicy getStoragePolicy() {
        return this.storagePolicy == null ? OlapBuilderStoragePolicy.DEFAULT : this.storagePolicy;
    }

    public void setStoragePolicy(OlapBuilderStoragePolicy storagePolicy) {
        this.storagePolicy = storagePolicy;
    }

    public Boolean cacheTable_() {
        return this.cacheTable;
    }

    public Boolean cacheTable_(Boolean cacheTable) {
        this.cacheTable = cacheTable;
        return this.cacheTable;
    }

    @Override
    public boolean isCacheTable() {
        return this.cacheTable != null ? this.cacheTable : false;
    }

    public void setCacheTable(boolean cacheTable) {
        this.cacheTable = cacheTable;
    }

    public OlapBuilderHierarchyUniqueNameStyle hierarchyUniqueNameStyle_() {
        return this.hierarchyUniqueNameStyle;
    }

    public OlapBuilderHierarchyUniqueNameStyle hierarchyUniqueNameStyle_(OlapBuilderHierarchyUniqueNameStyle hierarchyUniqueNameStyle) {
        this.hierarchyUniqueNameStyle = hierarchyUniqueNameStyle;
        return this.hierarchyUniqueNameStyle;
    }

    public OlapBuilderHierarchyUniqueNameStyle getHierarchyUniqueNameStyle() {
        return this.hierarchyUniqueNameStyle == null ? OlapBuilderHierarchyUniqueNameStyle.IncludeDimensionName : this.hierarchyUniqueNameStyle;
    }

    public void setHierarchyUniqueNameStyle(OlapBuilderHierarchyUniqueNameStyle hierarchyUniqueNameStyle) {
        this.hierarchyUniqueNameStyle = hierarchyUniqueNameStyle;
    }

    public DistinctCountOptimType distinctCountOptim_() {
        return this.distinctCountOptim;
    }

    public DistinctCountOptimType distinctCountOptim_(DistinctCountOptimType distinctCountOptim) {
        this.distinctCountOptim = distinctCountOptim;
        return this.distinctCountOptim;
    }

    public DistinctCountOptimType getDistinctCountOptim() {
        return this.distinctCountOptim;
    }

    public void setDistinctCountOptim(DistinctCountOptimType distinctCountOptim) {
        this.distinctCountOptim = distinctCountOptim;
    }

    public Boolean loadOnStartup_() {
        return this.loadOnStartup;
    }

    public Boolean loadOnStartup_(Boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
        return this.loadOnStartup;
    }

    public boolean isLoadOnStartup() {
        return this.loadOnStartup != null && this.loadOnStartup != false;
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public void setUseFactPartitioning(boolean useFactPartitioning) {
        this.useFactPartitioning = useFactPartitioning;
    }

    public boolean useFactPartitioning_() {
        return this.useFactPartitioning;
    }

    public boolean useFactPartitioning_(boolean useFactPartitioning) {
        this.useFactPartitioning = useFactPartitioning;
        return this.useFactPartitioning;
    }

    @Override
    public boolean useFactPartitioning() {
        return this.useFactPartitioning;
    }

    public SchemaGarbageCollectorType callGarbageCollector_() {
        return this.callGarbageCollector;
    }

    public SchemaGarbageCollectorType callGarbageCollector_(SchemaGarbageCollectorType callGarbageCollector) {
        this.callGarbageCollector = callGarbageCollector;
        return this.callGarbageCollector;
    }

    public SchemaGarbageCollectorType callGarbageCollector() {
        return this.callGarbageCollector == null ? SchemaGarbageCollectorType.NONE : this.callGarbageCollector;
    }

    public void setCallGarbageCollector(SchemaGarbageCollectorType callGarbageCollector) {
        this.callGarbageCollector = callGarbageCollector;
    }

    @Nullable
    public MemberPropertyConsistencyCheckType memberPropertyConsistencyCheck_() {
        return this.memberPropertyConsistencyCheck;
    }

    public MemberPropertyConsistencyCheckType memberPropertyConsistencyCheck_(MemberPropertyConsistencyCheckType memberPropertyConsistencyCheck) {
        this.memberPropertyConsistencyCheck = memberPropertyConsistencyCheck;
        return this.memberPropertyConsistencyCheck;
    }

    public MemberPropertyConsistencyCheckType memberPropertyConsistencyCheck() {
        return this.memberPropertyConsistencyCheck == null ? MemberPropertyConsistencyCheckType.NONE : this.memberPropertyConsistencyCheck;
    }

    public void setMemberPropertyConsistencyCheck(MemberPropertyConsistencyCheckType memberPropertyConsistencyCheck) {
        this.memberPropertyConsistencyCheck = memberPropertyConsistencyCheck;
    }

    public void setBackup(BackupType backup) {
        this.backup = backup;
    }

    public BackupType backup_() {
        return this.backup;
    }

    public BackupType backup_(BackupType backup) {
        this.backup = backup;
        return this.backup;
    }

    public BackupType backup() {
        return this.backup == null ? BackupType.NONE : this.backup;
    }

    public void setDisableAutoAttributes(boolean disableAttributes) {
        this.disableAutoAttributes = disableAttributes;
    }

    public boolean disableAutoAttributes() {
        return this.disableAutoAttributes != null && this.disableAutoAttributes != false;
    }

    public void schemaLocalizationFallbackLocale_(Locale fallback) {
        this.schemaLocalizationFallbackLocale = fallback;
    }

    public void disableAutoAttributes_(boolean disableAutoAttributes) {
        this.disableAutoAttributes = disableAutoAttributes;
    }

    public void setNonEmptyCachePolicy(NonEmptyCachePolicy nonEmptyCachePolicy) {
        this.nonEmptyCachePolicy = nonEmptyCachePolicy;
    }

    public NonEmptyCachePolicy nonEmptyCachePolicy_() {
        return this.nonEmptyCachePolicy;
    }

    public NonEmptyCachePolicy nonEmptyCachePolicy_(NonEmptyCachePolicy nonEmptyCachePolicy) {
        this.nonEmptyCachePolicy = nonEmptyCachePolicy;
        return this.nonEmptyCachePolicy;
    }

    public NonEmptyCachePolicy nonEmptyCachePolicy() {
        return this.nonEmptyCachePolicy == null ? NonEmptyCachePolicy.NONE : this.nonEmptyCachePolicy;
    }

    public NonEmptyCacheType nonEmptyCacheType_() {
        return this.nonEmptyCacheType;
    }

    public NonEmptyCacheType nonEmptyCacheType_(NonEmptyCacheType nonEmptyCacheType) {
        this.nonEmptyCacheType = nonEmptyCacheType;
        return this.nonEmptyCacheType;
    }

    public NonEmptyCacheType nonEmptyCacheType() {
        return this.nonEmptyCacheType == null ? NonEmptyCacheType.REGULAR : this.nonEmptyCacheType;
    }

    public void setNonEmptyCacheType(NonEmptyCacheType nonEmptyCacheType) {
        this.nonEmptyCacheType = nonEmptyCacheType;
    }

    public void setNonEmptyCachePersistency(NonEmptyCachePersistency nonEmptyCachePersistency) {
        this.nonEmptyCachePersistency = nonEmptyCachePersistency;
    }

    public NonEmptyCachePersistency nonEmptyCachePersistency_() {
        return this.nonEmptyCachePersistency;
    }

    public NonEmptyCachePersistency nonEmptyCachePersistency_(NonEmptyCachePersistency nonEmptyCachePersistency) {
        this.nonEmptyCachePersistency = nonEmptyCachePersistency;
        return this.nonEmptyCachePersistency;
    }

    public NonEmptyCachePersistency nonEmptyCachePersistency() {
        return this.nonEmptyCachePersistency == null ? NonEmptyCachePersistency.MEMORY : this.nonEmptyCachePersistency;
    }

    public Boolean mmapFacts_() {
        return this._mmapFacts;
    }

    public Boolean mmapFacts_(Boolean _mmapFacts) {
        this._mmapFacts = _mmapFacts;
        return this._mmapFacts;
    }

    @Override
    public List<IOlapBuilderDataViewDef> getViews() {
        return this.views;
    }

    public void setViews(Set<IOlapBuilderDataViewDef> views) {
        this.views = new ArrayList<IOlapBuilderDataViewDef>();
        this.views.addAll(views);
    }

    @Nullable
    public IOlapBuilderDataViewDef getView(String name) {
        for (IOlapBuilderDataViewDef view : this.views) {
            if (!view.getName().equals(name)) continue;
            return view;
        }
        return null;
    }

    @Override
    public List<IOlapBuilderCubeDef> getCubes() {
        return this.cubes;
    }

    @Override
    @Nullable
    public IOlapBuilderCubeDef getCube(IOlapBuilderBaseFactsDef facts) {
        for (IOlapBuilderCubeDef cube : this.cubes) {
            if (!cube.hasFacts(facts)) continue;
            return cube;
        }
        return null;
    }

    @Nullable
    public IOlapBuilderCubeDef getCube(String name) {
        for (IOlapBuilderCubeDef cube : this.cubes) {
            if (!cube.getName().equals(name)) continue;
            return cube;
        }
        return null;
    }

    @Override
    public List<IOlapBuilderPerspectiveDef> getPerspectives() {
        return this.perspectives;
    }

    public boolean orderPerspectives(List<String> orderedNames) {
        return OlapBuilderNamedDefinitionHelper.order(this.perspectives, orderedNames);
    }

    public boolean hasDimension(String name) {
        List<IOlapBuilderDimensionDef> dims = this.getDimensions();
        if (dims != null) {
            for (IOlapBuilderDimensionDef dim : dims) {
                if (!name.equals(dim.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<IOlapBuilderDimensionDef> getDimensions() {
        return this.dimensions;
    }

    @Nullable
    public IOlapBuilderDimensionDef getDimensionByUUID(String uuid) {
        for (IOlapBuilderDimensionDef dimension : this.dimensions) {
            if (!dimension.getUUID().equals(uuid)) continue;
            return dimension;
        }
        return null;
    }

    @Nullable
    public IOlapBuilderDimensionDef getDimensionByName(String name) {
        for (IOlapBuilderDimensionDef dimension : this.dimensions) {
            if (!dimension.getName().equals(name)) continue;
            return dimension;
        }
        return null;
    }

    public void addDimension(IOlapBuilderDimensionDef dimension) {
        this.dimensions.add(dimension);
    }

    public void addDimensions(List<IOlapBuilderDimensionDef> dimensions) {
        if (dimensions != null) {
            this.dimensions.addAll(dimensions);
        }
    }

    public boolean removeDimension(IOlapBuilderDimensionDef dimension) {
        return this.dimensions.remove(dimension);
    }

    public void removeAllDimensions() {
        this.dimensions.clear();
    }

    public void addCube(IOlapBuilderCubeDef cube) {
        this.cubes.add(cube);
    }

    public boolean removeCube(IOlapBuilderCubeDef cube) {
        return this.cubes.remove(cube);
    }

    @Override
    public List<IOlapBuilderDataSource> getDataSources() {
        return this.datasources;
    }

    @Nullable
    public IOlapBuilderDataSource getDataSource(String name) {
        for (IOlapBuilderDataSource datasource : this.datasources) {
            if (!datasource.getName().equals(name)) continue;
            return datasource;
        }
        return null;
    }

    public void addDataSource(IOlapBuilderDataSource dataSource) {
        this.datasources.add(dataSource);
    }

    public boolean removeDataSource(IOlapBuilderDataSource dataSource) {
        return this.datasources.remove(dataSource);
    }

    public void addDataView(IOlapBuilderDataViewDef dataView) {
        this.views.add(dataView);
    }

    public boolean removeDataView(IOlapBuilderDataViewDef dataView) {
        return this.views.remove(dataView);
    }

    public boolean removePerspective(IOlapBuilderPerspectiveDef perspective) {
        return this.perspectives.remove(perspective);
    }

    public OlapBuilderValidator<IOlapBuilderValidationEnabled, IOlapBuilderSchemaDef> getValidator() {
        return new OlapBuilderSchemaValidator();
    }

    @Override
    public String getContextVisualId() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Nullable
    public IOlapBuilderPerspectiveDef getPerspective(String name) {
        for (IOlapBuilderPerspectiveDef perspective : this.perspectives) {
            if (!perspective.getName().equals(name)) continue;
            return perspective;
        }
        return null;
    }

    public void addPerspective(IOlapBuilderPerspectiveDef perspectives) {
        this.perspectives.add(perspectives);
    }

    @Override
    public IOlapBuilderLocalizationDef getLocalization() {
        if (this.localization == null) {
            this.localization = new OlapBuilderLocalization();
        }
        return this.localization;
    }

    public void setLocalization(IOlapBuilderLocalizationDef localization) {
        this.localization = localization;
    }

    @Override
    public IOlapBuilderColorsDef getColors() {
        if (this.colors == null) {
            this.colors = new OlapBuilderColors();
        }
        return this.colors;
    }

    public void setColors(IOlapBuilderColorsDef colors) {
        this.colors = colors;
    }

    @Override
    public OlapBuilderScript getScript() {
        if (this.script == null) {
            this.script = new OlapBuilderScript("-- \n-- Drop all calc. members, sets and functions declared at schema/cube levels. \n-- \n\nDROP *\n\n");
        }
        return this.script;
    }

    public void setScript(String script) {
        this.script = new OlapBuilderScript(script);
    }

    public void setScript(OlapBuilderScript script) {
        this.setScript(script, false);
    }

    public String migrateCalcMeasures() {
        StringBuilder sb = new StringBuilder();
        for (IOlapBuilderCubeDef cube : this.cubes) {
            OlapBuilderSchema.migrateCalcMeasures(sb, cube.getName(), cube.getCalcMeasures());
        }
        for (IOlapBuilderCubeDef cube : this.cubes) {
            cube.clearCalcMeasures();
        }
        return sb.toString();
    }

    private static void migrateCalcMeasures(StringBuilder sb, String cube, List<IOlapBuilderCalcMemberDef> calcMeasures) {
        if (calcMeasures.isEmpty()) {
            return;
        }
        for (IOlapBuilderCalcMemberDef calcMeasure : calcMeasures) {
            if (sb.length() == 0) {
                sb.append("\n-- \n-- Calculated measures defined in cubes (deprecated) moved to this script. \n-- \n\n");
            }
            OlapBuilderSchema.migrateCalcMeasure(sb, cube, calcMeasure);
            sb.append("\n");
        }
    }

    private static void migrateCalcMeasure(StringBuilder sb, String cube, IOlapBuilderCalcMemberDef calcMeasure) {
        String cubeName = "[" + CdMdxUtils.escape((String)cube) + "]";
        String name = calcMeasure.getName().trim();
        String uniqueName = name.startsWith("[") ? cubeName + "." + name : cubeName + ".[" + CdMdxUtils.escape((String)name) + "]";
        String formula = calcMeasure.getFormula();
        sb.append("CREATE CALCULATED MEMBER ").append(uniqueName).append(" AS ").append(formula);
        String cellProperties = calcMeasure.getCellProperties();
        if (CdStringUtils.isNotNullAndNotBlank((String)cellProperties)) {
            sb.append(", ").append(cellProperties);
        }
    }

    public void setScript(OlapBuilderScript script, boolean calcMeasuresMigrated) {
        if (calcMeasuresMigrated) {
            for (IOlapBuilderCubeDef cube : this.cubes) {
                cube.clearCalcMeasures();
            }
        }
        this.script = script;
    }

    @Override
    public void beforeMarshal() {
        this._calcMembers = null;
        this._namedSets = null;
        this._functions = null;
        this._loadOnStartup = null;
        if (this.cacheTable != null && !this.cacheTable.booleanValue()) {
            this.cacheTable = null;
        }
        this._mmapFacts = null;
        for (IOlapBuilderCubeDef cube : this.cubes) {
            cube.beforeMarshal(this.dimensions);
        }
    }

    @Override
    public void afterUnmarshal() {
        if (this.loadOnStartup == null) {
            this.loadOnStartup = this._loadOnStartup != null && this._loadOnStartup != false;
        }
        Boolean bl = this.reverseLink = this.reverseLink == null ? Boolean.FALSE : this.reverseLink;
        if (this.script == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("-- \n");
            sb.append("-- Drop all calc. members, sets and functions declared at schema/cube levels. \n");
            sb.append("-- \n");
            sb.append("\n");
            sb.append("DROP *\n");
            sb.append("\n");
            sb.append("\n");
            sb.append("-- \n");
            sb.append("-- Functions \n");
            sb.append("-- \n");
            sb.append("\n");
            if (this._functions != null) {
                for (IOlapBuilderFunctionDef function : this._functions) {
                    function.asCreateStatement(sb);
                    sb.append("\n");
                }
            }
            sb.append("-- \n");
            sb.append("-- Sets. \n");
            sb.append("-- \n");
            sb.append("\n");
            if (this._namedSets != null) {
                for (IOlapBuilderNamedSetDef namedSet : this._namedSets) {
                    namedSet.asCreateStatement(sb);
                    sb.append("\n");
                }
            }
            sb.append("-- \n");
            sb.append("-- Calculated Measures/Members. \n");
            sb.append("-- \n");
            sb.append("\n");
            if (this._calcMembers != null) {
                for (IOlapBuilderCalcMemberDef calcMember : this._calcMembers) {
                    calcMember.asCreateStatement(sb, null);
                    sb.append("\n");
                }
            }
            this.script = new OlapBuilderScript(sb.toString());
        }
        this._functions = null;
        this._namedSets = null;
        this._calcMembers = null;
        if (this.storagePolicy == null && this._mmapFacts != null && this._mmapFacts.booleanValue()) {
            this.storagePolicy = OlapBuilderStoragePolicy.FACTS_IN_FILES;
        }
        this.datasources = this.datasources.stream().map(IOlapBuilderDataSource::tranformAfterUnMarshall).collect(Collectors.toList());
        this.views = this.views.stream().map(IOlapBuilderDataViewDef::tranformAfterUnMarshall).collect(Collectors.toList());
        this._mmapFacts = null;
        String calcMeasures = this.migrateCalcMeasures();
        if (CdStringUtils.isNotNullAndNotBlank((String)calcMeasures)) {
            this.script.addSuffix(calcMeasures);
        }
        if (this.script != null) {
            this.script.fixNativeFunctionsCode();
        }
    }

    @Override
    @Nullable
    public Locale getSchemaLocalizationFallbackLocale() {
        return this.schemaLocalizationFallbackLocale;
    }

    public void setSchemaLocalizationFallbackLocale(@Nullable Locale fallback) {
        this.schemaLocalizationFallbackLocale = fallback;
    }

    @Override
    @Nullable
    public Locale getLocaleForStringCompare() {
        return this.localeForStringCompare;
    }

    public void setLocaleForStringCompare(Locale localeForStringCompare) {
        this.localeForStringCompare = localeForStringCompare;
    }

    @Override
    public boolean acceptSpaceAsMemberName() {
        return this.acceptSpaceAsMemberName == Boolean.TRUE;
    }

    @Nullable
    public IOlapBuilderDataColumnDef getColumnDef(String tableOfViewId, String columnName) {
        for (IOlapBuilderDataSource datasource : this.datasources) {
            List tables = datasource.getTables();
            for (IOlapBuilderDataTableDef table : tables) {
                if (!table.getId().equals(tableOfViewId)) continue;
                return table.lookupSelectedColumn(columnName);
            }
            for (IOlapBuilderDataViewDef view : this.views) {
                if (!view.getId().equals(tableOfViewId)) continue;
                return view.lookupSelectedColumn(columnName);
            }
        }
        return null;
    }

    public void setAcceptSpaceAsMemberName(boolean acceptSpaceAsMemberName) {
        this.acceptSpaceAsMemberName = acceptSpaceAsMemberName;
    }

    public void setForFakeSchema(OlapBuilderBaseSchemaDefFactory factory, IOlapBuilderDimensionDef dimensionDef) {
        this.addDimension(dimensionDef);
        this.setMemberPropertyConsistencyCheck(factory.memberPropertyConsistencyCheck());
        this.setDisableAutoAttributes(factory.disableAutoAttributes());
        this.setAcceptSpaceAsMemberName(factory.isAcceptSpaceAsMemberName());
        this.setMembersUpperLowerCaseStrategy(factory.membersUpperLowerCaseStrategy());
    }

    public boolean enableReverseLink() {
        return this.reverseLink == Boolean.TRUE;
    }

    public void setReverseLink(Boolean reverseLink) {
        this.reverseLink = reverseLink;
    }

    @Override
    public MembersUpperLowerStrategyType membersUpperLowerCaseStrategy() {
        return this.membersUpperLowerCaseStrategy;
    }

    public void setMembersUpperLowerCaseStrategy(MembersUpperLowerStrategyType strat) {
        this.membersUpperLowerCaseStrategy = strat;
    }
}

