/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.datasource.facts.OlapBuilderBaseFacts;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCalcMemberDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.impl.OlapBuilderCalcMember;
import crazydev.iccube.builder.model.impl.OlapBuilderDataViewLinks;
import crazydev.iccube.builder.model.validation.OlapBuilderCubeValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import jakarta.xml.bind.annotation.XmlAccessOrder;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorOrder;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="cube")
@XmlAccessorOrder(value=XmlAccessOrder.ALPHABETICAL)
public class OlapBuilderCube
implements IOlapBuilderCubeDef,
IOlapBuilderJaxbListener {
    public static final CdProperty UUID = new CdReadWriteProperty(OlapBuilderCube.class, "id");
    public static final CdProperty NAME = new CdReadWriteProperty(OlapBuilderCube.class, "name");
    public static final CdProperty DESCRIPTION = new CdReadWriteProperty(OlapBuilderCube.class, "description");
    @XmlAttribute(name="id", required=true)
    private String id;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="description", required=true)
    private String description;
    @XmlElementRefs(value={@XmlElementRef(name="calculatedMember", type=OlapBuilderCalcMember.class)})
    private List<IOlapBuilderCalcMemberDef> calcMeasures = new ArrayList<IOlapBuilderCalcMemberDef>();
    @XmlElementRefs(value={@XmlElementRef(name="defaultFacts", type=OlapBuilderBaseFacts.class)})
    private List<IOlapBuilderBaseFactsDef> facts = new ArrayList<IOlapBuilderBaseFactsDef>();

    public OlapBuilderCube() {
        this.id = java.util.UUID.randomUUID().toString();
    }

    public OlapBuilderCube(String name, IOlapBuilderBaseFactsDef facts) {
        this(name, "...", OlapBuilderCube.asList(facts), new ArrayList<IOlapBuilderCalcMemberDef>());
    }

    public OlapBuilderCube(String name, String description, IOlapBuilderBaseFactsDef facts, List<IOlapBuilderCalcMemberDef> calcMeasures) {
        this(name, description, OlapBuilderCube.asList(facts), calcMeasures);
    }

    public OlapBuilderCube(String name, String description, OlapBuilderBaseFacts ... facts) {
        this(name, description, OlapBuilderCube.asList(facts), new ArrayList<IOlapBuilderCalcMemberDef>());
    }

    public OlapBuilderCube(String name, String description, List<IOlapBuilderBaseFactsDef> facts, List<IOlapBuilderCalcMemberDef> calcMeasures) {
        this.name = name;
        this.description = description;
        this.facts = facts;
        this.calcMeasures = calcMeasures;
        this.id = java.util.UUID.randomUUID().toString();
    }

    @Override
    public void beforeMarshal(List<IOlapBuilderDimensionDef> dimensions) {
        for (IOlapBuilderBaseFactsDef fact : this.facts) {
            fact.beforeMarshal(dimensions);
        }
    }

    public static OlapBuilderCube createCubeAndLinks(String name, String description, OlapBuilderFacts facts, IOlapBuilderDimensionDef ... dimensions) {
        ArrayList<IOlapBuilderCalcMemberDef> calcMembers = new ArrayList<IOlapBuilderCalcMemberDef>();
        OlapBuilderCube cube = new OlapBuilderCube(name, description, OlapBuilderCube.asList(facts), calcMembers);
        OlapBuilderCube.buildLinks(facts, Arrays.asList(dimensions));
        return cube;
    }

    public static OlapBuilderCube createCubeAndLinks(String name, String description, List<IOlapBuilderBaseFactsDef> facts, IOlapBuilderDimensionDef ... dimensions) {
        ArrayList<IOlapBuilderCalcMemberDef> calcMembers = new ArrayList<IOlapBuilderCalcMemberDef>();
        OlapBuilderCube cube = new OlapBuilderCube(name, description, facts, calcMembers);
        for (IOlapBuilderBaseFactsDef fact : facts) {
            OlapBuilderCube.buildLinks((OlapBuilderFacts)fact, Arrays.asList(dimensions));
        }
        return cube;
    }

    protected static void buildLinks(OlapBuilderFacts singleFact, List<IOlapBuilderDimensionDef> cubeDimensions) {
        for (IOlapBuilderDimensionDef dimDef : cubeDimensions) {
            if (!dimDef.isFactIndexing()) continue;
            List<IOlapBuilderDataColumnDef> factColumns = singleFact.getDataView().getSelectedColumns();
            List<IOlapBuilderDataColumnDef> dimColumns = dimDef.getDataView().getSelectedColumns();
            boolean found = false;
            for (IOlapBuilderDataColumnDef dimColumn : dimColumns) {
                for (IOlapBuilderDataColumnDef factColumn : factColumns) {
                    if (!factColumn.isLinkedTo(dimColumn)) continue;
                    if (found) {
                        throw new OlapBuilderErrorException(OlapBuilderErrorCode.DUPLICATE_COLUMNS_IN_THE_DIMENSION_TABLE, new Serializable[]{dimColumn.getName()});
                    }
                    singleFact.addLink(dimDef, OlapBuilderDataViewLinks.createSymmetricalLink(factColumn));
                    found = true;
                }
            }
        }
    }

    protected static List<IOlapBuilderBaseFactsDef> asList(IOlapBuilderBaseFactsDef ... allFacts) {
        ArrayList<IOlapBuilderBaseFactsDef> asList = new ArrayList<IOlapBuilderBaseFactsDef>();
        if (allFacts != null) {
            for (IOlapBuilderBaseFactsDef facts : allFacts) {
                if (facts == null) continue;
                asList.add(facts);
            }
        }
        return asList;
    }

    @Override
    public String getUUID() {
        return this.id;
    }

    @Override
    public void beforeMarshal() {
    }

    @Override
    public void afterUnmarshal() {
        if (StringUtils.isBlank((CharSequence)this.id)) {
            this.id = java.util.UUID.randomUUID().toString();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<IOlapBuilderBaseFactsDef> getFacts() {
        return this.facts;
    }

    @Override
    public List<IOlapBuilderCalcMemberDef> getCalcMeasures() {
        return this.calcMeasures;
    }

    @Override
    public void clearCalcMeasures() {
        this.calcMeasures.clear();
    }

    public void addCalcMeasure(String uniqueName, String formula, @Nullable String cellProperties) {
        this.calcMeasures.add(new OlapBuilderCalcMember(uniqueName, formula, cellProperties));
    }

    public OlapBuilderValidator<IOlapBuilderSchemaDef, IOlapBuilderCubeDef> getValidator() {
        return new OlapBuilderCubeValidator();
    }

    @Override
    @Nullable
    public IOlapBuilderBaseFactsDef getFacts(String name) {
        for (IOlapBuilderBaseFactsDef fact : this.facts) {
            if (!fact.getMeasureGroupName().equals(name)) continue;
            return fact;
        }
        return null;
    }

    @Override
    public boolean hasFacts(IOlapBuilderBaseFactsDef factsDef) {
        for (IOlapBuilderBaseFactsDef fact : this.facts) {
            if (fact != factsDef) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addFact(OlapBuilderFacts fact) {
        if (this.getFacts(fact.getMeasureGroupName()) != null) {
            throw new CdRuntimeException("Duplicated fact name " + fact.getMeasureGroupName());
        }
        this.facts.add(fact);
    }

    public void addFacts(IOlapBuilderBaseFactsDef factsDef) {
        this.facts.add(factsDef);
    }

    public boolean removeFacts(IOlapBuilderBaseFactsDef factsDef) {
        return this.facts.remove(factsDef);
    }

    @Override
    public String getContextVisualId() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

