/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.IMMUTABLE)
@XmlRootElement(name="linkBridge")
public class OlapBuilderBridgeRef {
    @XmlElement(name="bridgeTableId")
    @Nullable
    private String bridgeTableId;
    @XmlElements(value={@XmlElement(name="factJoin")})
    private List<OlapBuilderDataColumnRef> factJoin = new ArrayList<OlapBuilderDataColumnRef>();
    @XmlElements(value={@XmlElement(name="bridgeJoin")})
    private List<OlapBuilderDataColumnRef> bridgeJoin = new ArrayList<OlapBuilderDataColumnRef>();
    @XmlElements(value={@XmlElement(name="bridgeKey")})
    private List<OlapBuilderDataColumnRef> bridgeKey = new ArrayList<OlapBuilderDataColumnRef>();
    @XmlElement(name="one2one")
    @Nullable
    private Boolean one2one;
    @XmlTransient
    @Nullable
    private IOlapBuilderTabularDataDef bridgeTable;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> factJoinDef;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> bridgeJoinDef;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> bridgeKeyDef;

    OlapBuilderBridgeRef() {
    }

    OlapBuilderBridgeRef(String bridgeTableId, List<OlapBuilderDataColumnRef> factJoin, List<OlapBuilderDataColumnRef> bridgeJoin, List<OlapBuilderDataColumnRef> bridgeKey, boolean one2one) {
        this.bridgeTableId = bridgeTableId;
        this.factJoin = factJoin;
        this.bridgeJoin = bridgeJoin;
        this.bridgeKey = bridgeKey;
        this.one2one = one2one;
    }

    public IOlapBuilderTabularDataDef solveReference(OlapBuilderReferenceSolver referenceSolver, IOlapBuilderTabularDataDef factTable) {
        this.bridgeTable = referenceSolver.getTabularData(this.bridgeTableId);
        this.factJoinDef = referenceSolver.getColumns(factTable, this.factJoin);
        this.bridgeJoinDef = referenceSolver.getColumns(this.bridgeTable, this.bridgeJoin);
        this.bridgeKeyDef = referenceSolver.getColumns(this.bridgeTable, this.bridgeKey);
        return this.bridgeTable;
    }

    public static OlapBuilderBridgeRef createFromUX(String bridgeTableId, List<OlapBuilderDataColumnRef> keyBridgeColumnsRefs, List<OlapBuilderDataColumnRef> joinFactColumnsRefs, List<OlapBuilderDataColumnRef> joinBridgeColumnRefs, boolean one2one) {
        return new OlapBuilderBridgeRef(bridgeTableId, joinFactColumnsRefs, joinBridgeColumnRefs, keyBridgeColumnsRefs, one2one);
    }

    public String getBridgeTableId() {
        return this.bridgeTableId;
    }

    public List<OlapBuilderDataColumnRef> getFactJoin() {
        return this.factJoin;
    }

    public List<OlapBuilderDataColumnRef> getBridgeJoin() {
        return this.bridgeJoin;
    }

    public List<OlapBuilderDataColumnRef> getBridgeKey() {
        return this.bridgeKey;
    }

    public IOlapBuilderTabularDataDef getBridgeTable() {
        return this.bridgeTable;
    }

    public boolean isOneToOne() {
        return this.one2one != null && this.one2one != false;
    }

    public List<IOlapBuilderDataColumnDef> getFactJoinDef() {
        return this.factJoinDef;
    }

    public List<IOlapBuilderDataColumnDef> getBridgeJoinDef() {
        return this.bridgeJoinDef;
    }

    public List<IOlapBuilderDataColumnDef> getBridgeKeyDef() {
        return this.bridgeKeyDef;
    }
}

