/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdClassUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlSerializable;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.IOlapBuilderValidationEnabled;
import crazydev.iccube.builder.model.impl.OlapBuilderDataSourceVisibility;
import crazydev.iccube.builder.model.impl.reportquery.OlapReportDataSourceMeta;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.builder.model.validation.OlapBuilderBaseDataSourceValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceTypeGroup;
import crazydev.iccube.builder.ux.meta.datasource.UxImage;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateDataSourceWizardSteps;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateTypedDataSourceWizard;
import crazydev.iccube.builder.ux.meta.datatable.wizard.UxBuilderCreateDataTableWizardSteps;
import crazydev.iccube.builder.ux.meta.datatable.wizard.UxBuilderCreateTypedDataTableWizard;
import crazydev.iccube.builder.ux.meta.datatable.wizard.UxBuilderDataSourceTableTypeForm;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAccessOrder;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorOrder;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlAccessorOrder(value=XmlAccessOrder.ALPHABETICAL)
public abstract class OlapBuilderBaseDataSource<CONNECTION extends IOlapBuilderConnection>
implements IOlapBuilderDataSource<CONNECTION>,
CdXmlSerializable,
Cloneable {
    public static final CdProperty NAME = new CdReadWriteProperty(OlapBuilderBaseDataSource.class, "name");
    public static final CdProperty DESCRIPTION = new CdReadWriteProperty(OlapBuilderBaseDataSource.class, "description");
    public static final CdProperty VISIBILITY = new CdReadWriteProperty(OlapBuilderBaseDataSource.class, "visibility");
    public static final CdProperty INCLUDE_SYNONYMS = new CdReadWriteProperty(OlapBuilderBaseDataSource.class, "includeSynonyms");
    public static final CdProperty DISABLE_READ_ONLY_MODE = new CdReadWriteProperty(OlapBuilderBaseDataSource.class, "disableReadOnlyMode");
    public static final CdProperty DISABLE_AUTO_COMMIT_FALSE = new CdReadWriteProperty(OlapBuilderBaseDataSource.class, "disableAutoCommitFalse");
    public static final CdProperty CREATED_TABLE_TYPES = new CdReadProperty(OlapBuilderBaseDataSource.class, "createdTableTypes");
    @XmlTransient
    @Nullable
    private File xmlFile;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute(required=false)
    @Nullable
    private String description;
    @XmlAttribute(name="visibility", required=false)
    @Nullable
    private OlapBuilderDataSourceVisibility visibility;
    @XmlAttribute(name="includeSynonyms", required=false)
    private boolean includeSynonyms;
    @XmlAttribute(name="disableReadOnlyMode", required=false)
    private boolean disableReadOnlyMode;
    @XmlAttribute(name="disableAutoCommitFalse", required=false)
    private boolean disableAutoCommitFalse;
    @XmlElementRef
    private List<OlapBuilderBaseDataTable<CONNECTION>> tables = new ArrayList<OlapBuilderBaseDataTable<CONNECTION>>();
    @XmlTransient
    private List<IOlapBuilderDataViewDef> transientViews = new ArrayList<IOlapBuilderDataViewDef>();

    protected OlapBuilderBaseDataSource() {
        this(null);
    }

    public OlapBuilderBaseDataSource(String name) {
        this.name = name;
    }

    public OlapBuilderBaseDataSource(String name, @Nullable String description) {
        this.name = name;
        this.description = description;
    }

    protected OlapBuilderBaseDataSource(String name, @Nullable String description, @Nullable OlapBuilderDataSourceVisibility visibility, boolean includeSynonyms, boolean disableReadOnlyMode, boolean disableAutoCommitFalse) {
        this.name = name;
        this.description = description;
        this.visibility = visibility;
        this.includeSynonyms = includeSynonyms;
        this.disableReadOnlyMode = disableReadOnlyMode;
        this.disableAutoCommitFalse = disableAutoCommitFalse;
    }

    @Nullable
    public OlapBuilderDataSourceVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(@Nullable OlapBuilderDataSourceVisibility visibility) {
        this.visibility = visibility;
    }

    protected abstract String getReportDataSourceType();

    protected abstract String getReportDataSourceTypeCaption();

    public OlapReportDataSourceMeta getReportDataSourceMeta() {
        String type = this.getReportDataSourceType();
        String typeCaption = this.getReportDataSourceTypeCaption();
        return new OlapReportDataSourceMeta(type, typeCaption);
    }

    public boolean isR() {
        return false;
    }

    public boolean isMongoDB() {
        return false;
    }

    public void link(IOlapBuilderTabularDataDef dataView) {
        if (dataView instanceof OlapBuilderBaseDataTable) {
            OlapBuilderBaseDataTable table = (OlapBuilderBaseDataTable)dataView;
            table.setDataSource(this);
            this.addTable(table);
        } else if (dataView instanceof OlapBuilderBaseDataView) {
            OlapBuilderBaseDataView view = (OlapBuilderBaseDataView)dataView;
            this.transientViews.add(view);
        } else {
            throw new RuntimeException("internal error: inconsistent data view usage (" + String.valueOf(dataView != null ? dataView.getClass() : "<null>") + ")");
        }
    }

    @Nullable
    public File getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public void addTable(IOlapBuilderDataTableDef table) {
        this.tables.add((OlapBuilderBaseDataTable)table);
        table.setDataSource(this);
    }

    @Override
    public void removeAllTable() {
        this.tables.clear();
    }

    public boolean removeTable(@Nullable IOlapBuilderDataTableDef table) {
        if (table == null) {
            return false;
        }
        int index = -1;
        for (int idx = 0; idx < this.tables.size(); ++idx) {
            IOlapBuilderDataTableDef dataTable = this.tables.get(idx);
            if (dataTable != table) continue;
            index = idx;
            break;
        }
        if (index != -1) {
            this.tables.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public List<? extends IOlapBuilderDataTableDef<CONNECTION>> getTables() {
        return this.tables;
    }

    public void setTables(List<OlapBuilderBaseDataTable<CONNECTION>> tables) {
        this.tables = tables;
    }

    protected List<? extends IOlapBuilderDataTableDef<CONNECTION>> getDiscoveredTables() {
        ArrayList<IOlapBuilderDataTableDef> dTables = new ArrayList<IOlapBuilderDataTableDef>();
        for (IOlapBuilderDataTableDef iOlapBuilderDataTableDef : this.tables) {
            if (!iOlapBuilderDataTableDef.isDiscoveredInDataSource()) continue;
            dTables.add(iOlapBuilderDataTableDef);
        }
        return dTables;
    }

    protected List<String> getDiscoveredTableNames() {
        List<IOlapBuilderDataTableDef<CONNECTION>> dTables = this.getDiscoveredTables();
        ArrayList<String> names = new ArrayList<String>();
        for (IOlapBuilderDataTableDef<CONNECTION> dTable : dTables) {
            names.add(dTable.getName());
        }
        return names;
    }

    @Override
    public List<IOlapBuilderDataViewDef> getTransientViews() {
        return this.transientViews;
    }

    public boolean containsTableOnFileName(String tableFileName) {
        for (IOlapBuilderDataTableDef<CONNECTION> table : this.getTables()) {
            if (!this.isDataTableNameEquals(table.getFileName(), tableFileName)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public IOlapBuilderDataTableDef<CONNECTION> lookupTable(String tableName) {
        for (IOlapBuilderDataTableDef<CONNECTION> table : this.getTables()) {
            if (!this.isDataTableNameEquals(table.getName(), tableName)) continue;
            return table;
        }
        return null;
    }

    public boolean isDataTableNameEquals(String left, String right) {
        return left.equalsIgnoreCase(right);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setNameAndDescription(String name, @Nullable String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public String getContextVisualId() {
        return this.name;
    }

    public OlapBuilderValidator<IOlapBuilderValidationEnabled, IOlapBuilderDataSource> getValidator() {
        return new OlapBuilderBaseDataSourceValidator();
    }

    protected boolean acceptTableNameForDiscoverTableNames(@Nullable String filter, String tableName) {
        return this.doAcceptTableNameForDiscoverTableNames(filter, tableName);
    }

    protected boolean doAcceptTableNameForDiscoverTableNames(@Nullable String filter, String tableName) {
        if (CdStringUtils.isNullOrBlank((String)filter)) {
            return true;
        }
        String filterU = filter.toUpperCase();
        String tableNameU = tableName.toUpperCase();
        return tableNameU.contains(filterU);
    }

    public abstract boolean isDiscoverTablesSupported();

    public List<String> discoverAllTablesNames(CONNECTION openedConnection, boolean filterSystemSchemas, @Nullable String filter) {
        throw new CdProgrammingException("Not supported");
    }

    @Override
    public OlapBuilderBaseDataTable<CONNECTION> createEmptyDiscoverTable(String tableName) {
        throw new CdProgrammingException("Not supported");
    }

    @Override
    @Nullable
    public abstract List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes();

    public final boolean isCreateTableSupported() {
        List<Class<IOlapBuilderTabularDataDef>> types = this.getCreatedTableTypes();
        return types != null && !types.isEmpty();
    }

    public OlapBuilderBaseDataTable<CONNECTION> createEmptyCreateTable(@Nullable Class<IOlapBuilderTabularDataDef> tableType) {
        throw new CdProgrammingException("Not supported");
    }

    @Override
    public void onUpdated() {
    }

    @Override
    @Nullable
    public IOlapBuilderDataTableDef getTableByName(String name) {
        for (OlapBuilderBaseDataTable<CONNECTION> table : this.tables) {
            if (!table.getName().equals(name)) continue;
            return table;
        }
        return null;
    }

    @Override
    @Nullable
    public IOlapBuilderDataTableDef getTableById(String id) {
        for (OlapBuilderBaseDataTable<CONNECTION> table : this.tables) {
            if (!table.getId().equals(id)) continue;
            return table;
        }
        return null;
    }

    @Override
    public OlapBuilderBaseDataSource cloneForDimensionBrowsing(Set<IOlapBuilderDataTableDef> tables) {
        try {
            OlapBuilderBaseDataSource clone = (OlapBuilderBaseDataSource)this.clone();
            clone.tables = new ArrayList<OlapBuilderBaseDataTable<CONNECTION>>();
            clone.transientViews = new ArrayList<IOlapBuilderDataViewDef>();
            if (tables != null) {
                for (IOlapBuilderDataTableDef dataTable : tables) {
                    OlapBuilderBaseDataTable dt;
                    if (dataTable == null || !this.tables.contains(dt = (OlapBuilderBaseDataTable)dataTable)) continue;
                    clone.tables.add(dt);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            OlapLoggers.BUILDER.error((Object)"Dimension browse error", (Throwable)ex);
            throw new RuntimeException("internal error : could not copy the datasource definition");
        }
    }

    @Override
    public boolean acceptCachedTable() {
        return true;
    }

    @Override
    public boolean refreshCachedEntities(CONNECTION connection) {
        return false;
    }

    @Override
    public boolean hasNoTyping() {
        return false;
    }

    @Override
    public void moveAllTablesTo(IOlapBuilderDataSource targetDS) {
        if (this.getClass() != targetDS.getClass()) {
            throw new RuntimeException("Incompatible Data sources ");
        }
        OlapBuilderBaseDataSource ds = (OlapBuilderBaseDataSource)targetDS;
        this.transientViews.clear();
        this.tables.forEach(ds::addTable);
        this.tables.clear();
    }

    public void setupUxType(UxBuilderDataSourceTypeGroup group) {
        List<UxBuilderDataSourceType> others = this.createUxTypes();
        if (others != null) {
            for (UxBuilderDataSourceType other : others) {
                group.add(other);
            }
        } else {
            UxBuilderDataSourceType type = this.createUxType();
            group.add(type);
        }
    }

    public boolean isIncludeSynonyms() {
        return this.includeSynonyms;
    }

    @Override
    @Nullable
    public String getTypeId() {
        return this.getClass().getSimpleName();
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    protected UxBuilderDataSourceType createUxType() {
        String id = this.getTypeId();
        return new UxBuilderDataSourceType(id, this.getUxTypeImage(), () -> new UxBuilderCreateTypedDataSourceWizard(id, this.createUxCreateWizardSteps()));
    }

    @Nullable
    protected UxImage getUxTypeImage() {
        return new UxImage(this.getClass(), this.getClass().getSimpleName() + ".svg");
    }

    @Nullable
    protected List<UxBuilderDataSourceType> createUxTypes() {
        return null;
    }

    protected List<UxBuilderWizardStep> createUxCreateWizardSteps() {
        ArrayList<UxBuilderWizardStep> steps = new ArrayList<UxBuilderWizardStep>();
        steps.add(UxBuilderCreateDataSourceWizardSteps.name());
        steps.add(UxBuilderCreateDataSourceWizardSteps.propsExclude(true, this.createEmptyDataSource(), NAME, DESCRIPTION));
        return steps;
    }

    protected OlapBuilderBaseDataSource createEmptyDataSource() {
        try {
            Constructor<?> ctor = this.getClass().getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return (OlapBuilderBaseDataSource)ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            OlapLoggers.BUILDER.error((Object)"datasource setup error", (Throwable)ex);
            throw new RuntimeException("internal error: could not create datasource [" + this.getClass().getSimpleName() + "]", ex);
        }
    }

    @Override
    public UxBuilderCreateTypedDataTableWizard setupCreateDataTableWizard() {
        ArrayList<UxBuilderWizardStep> steps = new ArrayList<UxBuilderWizardStep>();
        boolean withDiscoverTables = this.isDiscoverTablesSupported();
        List<Class<IOlapBuilderTabularDataDef>> createdTableTypes = this.getCreatedTableTypes();
        int createTableTypesCount = createdTableTypes != null ? createdTableTypes.size() : 0;
        int tableTypesCount = createTableTypesCount + (withDiscoverTables ? 1 : 0);
        if (tableTypesCount > 1) {
            String discoverType = withDiscoverTables ? OlapBuilderBaseDataSource.getDiscoverTableTypeName(this.getClass()) : null;
            ArrayList<String> createTypes = new ArrayList<String>();
            for (Class<IOlapBuilderTabularDataDef> createdTableType : createdTableTypes) {
                createTypes.add(OlapBuilderBaseDataSource.getCreateTableTypeName(createdTableType));
            }
            steps.add(UxBuilderCreateDataTableWizardSteps.tableTypes(discoverType, createTypes));
            steps.add(UxBuilderCreateDataTableWizardSteps.more());
        } else if (withDiscoverTables) {
            steps.add(UxBuilderCreateDataTableWizardSteps.discoverTables(this.getName(), this.getDiscoveredTableNames()));
        } else if (createTableTypesCount > 0) {
            Class<IOlapBuilderTabularDataDef> type = createdTableTypes.get(0);
            OlapBuilderBaseDataTable<CONNECTION> emptyTable = this.createEmptyCreateTable(type);
            steps.add(UxBuilderCreateDataTableWizardSteps.createTable(this.getName(), emptyTable));
        }
        return new UxBuilderCreateTypedDataTableWizard(this, steps){
            final /* synthetic */ OlapBuilderBaseDataSource this$0;
            {
                OlapBuilderBaseDataSource olapBuilderBaseDataSource = this$0;
                Objects.requireNonNull(olapBuilderBaseDataSource);
                this.this$0 = olapBuilderBaseDataSource;
                super(steps);
            }

            @Override
            public UxBuilderWizardValidation validate(OlapRuntimeContext context, int activeStep) {
                UxBuilderDataSourceTableTypeForm typeFORM = (UxBuilderDataSourceTableTypeForm)((UxBuilderWizardStep)this.steps.get(0)).getModel();
                String tableType = typeFORM.getTableType();
                ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
                if (tableType.equals(OlapBuilderBaseDataSource.getDiscoverTableTypeName(this.this$0.getClass()))) {
                    newSteps.add(UxBuilderCreateDataTableWizardSteps.discoverTables(this.this$0.getName(), this.this$0.getDiscoveredTableNames()));
                } else {
                    try {
                        Class<IOlapBuilderTabularDataDef> type = OlapBuilderBaseDataSource.getCreatedTableType(this.this$0.getCreatedTableTypes(), tableType);
                        OlapBuilderBaseDataTable emptyTable = this.this$0.createEmptyCreateTable(type);
                        newSteps.add(UxBuilderCreateDataTableWizardSteps.createTable(this.this$0.getName(), emptyTable));
                    }
                    catch (ClassNotFoundException ex) {
                        OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] unexpected data-table type [" + tableType + "]"), (Throwable)ex);
                        throw new RuntimeException("unexpected data-table type [" + tableType + "]", ex);
                    }
                }
                return new UxBuilderWizardValidation(activeStep, newSteps);
            }
        };
    }

    private static String getDiscoverTableTypeName(Class<? extends OlapBuilderBaseDataSource> ds) {
        return "tableType.discover." + ds.getSimpleName();
    }

    private static String getCreateTableTypeName(Class<? extends IOlapBuilderTabularDataDef> dt) {
        return "tableType.create." + dt.getSimpleName();
    }

    private static Class<IOlapBuilderTabularDataDef> getCreatedTableType(@Nullable List<Class<? extends IOlapBuilderTabularDataDef>> types, String createTableType) throws ClassNotFoundException {
        if (types != null) {
            for (Class<IOlapBuilderTabularDataDef> clazz : types) {
                String createTypeSN;
                String typeSN = clazz.getSimpleName();
                if (!typeSN.equals(createTypeSN = CdClassUtils.getSimpleName((String)createTableType))) continue;
                return clazz;
            }
        }
        throw new ClassNotFoundException(createTableType);
    }

    public boolean disableReadOnlyMode() {
        return this.disableReadOnlyMode;
    }

    public boolean disableAutoCommitFalse() {
        return this.disableAutoCommitFalse;
    }
}

