/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.model.def.IOlapBuilderAttributeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.validation.OlapBuilderAttributeValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapAttributeOrderByType;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.enums.OlapMemberOrderKind;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="attribute")
public class OlapBuilderAttribute
implements IOlapBuilderAttributeDef {
    public static final CdProperty NAME = new CdReadWriteProperty(OlapBuilderAttribute.class, "name");
    public static final CdProperty COLUMN = new CdReadWriteProperty(OlapBuilderAttribute.class, "attributeColumnRef");
    public static final CdProperty NAME_IF_NULL = new CdReadWriteProperty(OlapBuilderAttribute.class, "nameIfNull");
    public static final CdProperty ORDER_BY_TYPE = new CdReadWriteProperty(OlapBuilderAttribute.class, "orderMembersByType");
    public static final CdProperty ORDER_KIND = new CdReadWriteProperty(OlapBuilderAttribute.class, "orderKind");
    @XmlAttribute(required=true, name="name")
    private String name;
    @XmlAttribute(name="nameIfNull")
    private String nameIfNull;
    @XmlElement(name="column", required=true)
    private OlapBuilderDataColumnRef attributeColumnRef;
    @XmlElement(name="orderType", required=true)
    private OlapAttributeOrderByType orderMembersByType = OlapAttributeOrderByType.NONE;
    @XmlElement(name="orderKind", required=false)
    private OlapMemberOrderKind orderKind;
    @XmlTransient
    private IOlapBuilderDataColumnDef attributeColumn;
    @XmlTransient
    private int tupleDimensionalityIndex = -1;

    public OlapBuilderAttribute() {
    }

    @Override
    public OlapMemberOrderByType getOrderMembersByType() {
        switch (this.orderMembersByType) {
            case NONE: {
                return OlapMemberOrderByType.NONE;
            }
            case BY_KEY: {
                return OlapMemberOrderByType.BY_KEY;
            }
        }
        return OlapMemberOrderByType.BY_NAME;
    }

    @Override
    public OlapMemberOrderKind getOrderKind() {
        return this.orderKind;
    }

    public OlapBuilderAttribute(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getNameIfNull() {
        return this.nameIfNull;
    }

    @Override
    public IOlapBuilderDataColumnDef getAttributeColumn() {
        return this.attributeColumn;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getContextVisualId() {
        return this.name;
    }

    @Override
    public void solveReference(OlapBuilderReferenceSolver referenceSolver, IOlapBuilderTabularDataDef dataView) {
        this.attributeColumn = referenceSolver.getColumn(dataView, this.attributeColumnRef);
    }

    @Override
    public int getTupleDimensionalityIndex() {
        return this.tupleDimensionalityIndex;
    }

    @Override
    public void setTupleDimensionalityIndex(int tupleDimensionalityIndex) {
        this.tupleDimensionalityIndex = tupleDimensionalityIndex;
    }

    @Override
    public OlapBuilderInputType getType() {
        return this.attributeColumn.getType();
    }

    public OlapBuilderValidator getValidator() {
        return new OlapBuilderAttributeValidator();
    }
}

