/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.entityfactory;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.shared.schema.S_FactsMeasureColumns;
import crazydev.iccube.cluster.shared.schema.S_MeasureColumn;
import crazydev.iccube.cluster.shared.schema.S_MeasureIndex;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberFactory;
import java.util.List;

@CdThreadSupport(value=CdThreadSupportLevel.IMMUTABLE)
public abstract class OlapMeasuresDimensionFactory {
    private OlapMeasuresDimensionFactory() {
    }

    public static void createMeasureMembers(OlapMeasuresDimension measuresDimension, List<IOlapBuilderBaseFactsDef> facts) {
        for (IOlapBuilderBaseFactsDef fact : facts) {
            List<IOlapBuilderMeasureDef> measureDefs = fact.getMeasures();
            S_FactsMeasureColumns measureColumnInfos = S_FactsMeasureColumns.create(fact);
            for (int measureDefIndex = 0; measureDefIndex < measureDefs.size(); ++measureDefIndex) {
                IOlapBuilderMeasureDef measureDef = measureDefs.get(measureDefIndex);
                S_MeasureColumn columnInfo = measureColumnInfos.getColumn(measureDef);
                S_MeasureIndex index = new S_MeasureIndex(measureDefIndex, columnInfo.getFactsColumnIndex());
                String name = measureDef.getName();
                OlapBuilderInputType factDataType = measureDef.getFactDataType();
                OlapAggregationType aggregationType = measureDef.getAggregationType();
                boolean emptyIsZero = measureDef.emptyIsZero();
                OlapMeasuresDimensionFactory.createMeasure(measuresDimension, index, name, fact, factDataType, aggregationType, emptyIsZero);
            }
        }
    }

    private static OlapMember createMeasure(OlapMeasuresDimension measuresDimension, S_MeasureIndex index, String name, IOlapBuilderBaseFactsDef measureGroup, OlapBuilderInputType factDataType, OlapAggregationType aggregationType, boolean emptyIsZero) {
        OlapMeasureMember measure = OlapMemberFactory.createOlapMeasureMember(measuresDimension.getLevel(), index, name, measureGroup, factDataType, aggregationType, emptyIsZero);
        return measuresDimension.getLevel().addMember(measure, false);
    }
}

