/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.def;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdIComparableList;
import crazydev.common.collection.CdMultiColumnValue;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.olap.entity.OlapScalarEntityFactory;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface IOlapBuilderTableRow {
    default public boolean isEmpty() {
        return false;
    }

    @Nullable
    public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef var1);

    default public OlapScalarEntity getJavaNativeDataValueAsScalarEntity(IOlapBuilderDataColumnDef columnDef) {
        Comparable value = this.getJavaNativeDataValue(columnDef);
        return OlapScalarEntityFactory.create(value);
    }

    @Nullable
    default public <T extends Comparable> T getJavaNativeDataValues(List<IOlapBuilderDataColumnDef> cols) {
        if (cols.size() == 1) {
            return (T)this.getJavaNativeDataValue(cols.get(0));
        }
        Comparable[] val = new Comparable[cols.size()];
        boolean allValuesNull = true;
        for (int i = 0; i < cols.size(); ++i) {
            Comparable rowValue = this.getJavaNativeDataValue(cols.get(i));
            if (rowValue instanceof CdIComparableList) {
                return this.__internalValuesMulti(cols);
            }
            allValuesNull &= rowValue == null;
            val[i] = rowValue;
        }
        return (T)(allValuesNull ? null : new CdMultiColumnValue(val));
    }

    @Nullable
    default public Comparable getJavaNativeDataValueForResolveMembers(int lookup, List<IOlapBuilderDataColumnDef> columnDef) {
        return this.getJavaNativeDataValues(columnDef);
    }

    default public <T extends Comparable> T __internalValuesMulti(List<IOlapBuilderDataColumnDef> cols) {
        CdIComparableList[] input = new CdIComparableList[cols.size()];
        int maxSize = 0;
        for (int i = 0; i < cols.size(); ++i) {
            Comparable rowValue = this.getJavaNativeDataValue(cols.get(i));
            if (rowValue == null) {
                return null;
            }
            input[i] = rowValue instanceof CdIComparableList ? (CdIComparableList)rowValue : new CdComparableArray(new Comparable[]{rowValue});
            maxSize = Math.max(maxSize, input[i].size());
        }
        Comparable[] outArray = new Comparable[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            Comparable[] val = new Comparable[cols.size()];
            for (int c = 0; c < cols.size(); ++c) {
                CdIComparableList list = input[c];
                val[c] = list.get(Math.min(i, list.size() - 1));
            }
            outArray[i] = new CdMultiColumnValue(val);
        }
        return (T)new CdComparableArray(outArray);
    }
}

