/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.lookuptable;

import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapFactsLookupTableRowMT
implements IOlapBuilderTableRow {
    private final OlapDimension[] dimensionNames;
    private final int[] lookupTablesPos;
    private final int[] relationsPos;
    private final int[][] relations;
    private final IOlapBuilderTableRow row;

    public OlapFactsLookupTableRowMT(OlapDimension[] dimensionNames, int[] lookupTablesPos, int[] relationsPos, int[][] relations, IOlapBuilderTableRow row) {
        this.dimensionNames = dimensionNames;
        this.lookupTablesPos = lookupTablesPos;
        this.relations = relations;
        this.relationsPos = relationsPos;
        this.row = row;
    }

    @Override
    @Nullable
    public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
        return this.row.getJavaNativeDataValue(columnDef);
    }

    @Override
    @Nullable
    public Comparable getJavaNativeDataValueForResolveMembers(int dimensionIndex, List<IOlapBuilderDataColumnDef> columnDef) {
        int tableIndex = this.lookupTablesPos[dimensionIndex];
        if (tableIndex == -1) {
            return this.row.getJavaNativeDataValues(columnDef);
        }
        int[] values = this.relations[tableIndex];
        if (values == null) {
            return null;
        }
        int pos = this.relationsPos[dimensionIndex];
        if (pos == -1) {
            return this.row.getJavaNativeDataValues(columnDef);
        }
        int value = values[pos];
        return Integer.valueOf(value);
    }
}

