/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.hierarchy;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaPermissions;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.builders.IOlapBuilderDimensionListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.entityfactory.OlapMultiLevelHierarchyFactory;
import crazydev.iccube.builder.type.OlapBuilderColumnDecorationType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapMultiLevelHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberFactory;
import crazydev.iccube.olap.entity.member.OlapNoValueMemberKey;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.goodies.incrload.IncrLoadPhase;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderHierarchyBuilder<T extends IOlapBuilderHierarchyDef>
implements IOlapBuilderDimensionListener {
    protected final OlapBuilderContext context;
    protected final OlapDimension olapDimension;
    protected final T hierarchyDef;
    protected final OlapNameContext nameContext;
    protected OlapMultiLevelHierarchy olapHierarchy;

    public OlapBuilderHierarchyBuilder(OlapBuilderContext context, OlapDimension olapDimension, T hierarchyDef) {
        this.context = context;
        this.nameContext = context.getNameContext();
        this.olapDimension = olapDimension;
        this.hierarchyDef = hierarchyDef;
    }

    @Override
    public String getHierarchyName() {
        return this.hierarchyDef.getName();
    }

    @Override
    public boolean isAttributeHierarchy() {
        return this.hierarchyDef.isAttributeHierarchy();
    }

    @Override
    public OlapMember addMissingAttributeMember() {
        if (!this.isAttributeHierarchy()) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        if (this.olapHierarchy.getLevels().size() != 2) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        OlapLevel lastLevel = this.olapHierarchy.getLastLevel();
        String missingAttributeName = lastLevel.getMissingAttributeMemberName();
        return this.addMember(lastLevel, this.olapHierarchy.getAllMember(), missingAttributeName, false);
    }

    @Override
    public OlapMember addMissingNoBaseHierarchyMember() {
        boolean hasMissingAttributeName = false;
        OlapMember member = this.olapHierarchy.getAllMember();
        for (int i = 0; i < this.olapHierarchy.getLevels().size(); ++i) {
            OlapLevel level = this.olapHierarchy.getLevels().get(i);
            if (level.isAll()) continue;
            String missingAttributeName = level.getMissingAttributeMemberName();
            if (!CdStringUtils.isNotNullAndNotBlank((String)missingAttributeName)) break;
            member = this.addMember(level, member, missingAttributeName, false);
            hasMissingAttributeName = true;
        }
        return hasMissingAttributeName ? member : null;
    }

    @Nullable
    private OlapMember addMember(OlapLevel level, @Nullable OlapMember parentMember, String memberName, boolean isUnknown) {
        OlapMember member = null;
        if (CdStringUtils.isNotNullAndNotBlank((String)memberName)) {
            OlapMember olapMember = level.lookupMemberByName(memberName);
            if (olapMember != null) {
                return olapMember;
            }
            member = OlapMemberFactory.createMember(this.context, false, level, parentMember, memberName, OlapNoValueMemberKey.INSTANCE, new OlapMemberPropertiesValues());
            level.addMember(member, isUnknown);
        }
        return member;
    }

    @Override
    public void addNoBaseBaseLink(OlapMember noBaseMember, OlapMember baseMember) {
        this.context.addNoBaseBaseLink(noBaseMember, baseMember);
    }

    @Override
    public void onProcessingDataCompleted(OlapBuilderContext context) {
        if (this.olapHierarchy == null) {
            return;
        }
        this.olapHierarchy.getLevels().forEach(level -> level.getDataHandler().onProcessingDataCompleted(context));
    }

    @Override
    public void init(IOlapBuilderHierarchyDef defaultHierarchy) {
        if (this.context.incrLoadPhase() == IncrLoadPhase.BUILDING_SCHEMA) {
            this.olapHierarchy = (OlapMultiLevelHierarchy)this.olapDimension.lookupHierarchyByName(this.nameContext, this.hierarchyDef.getName());
            if (this.olapHierarchy != null) {
                return;
            }
        }
        boolean hasAllLevel = this.getHasAllLevel(this.hierarchyDef);
        String allLevelName = this.getAllLevelName(this.hierarchyDef);
        String allName = this.getAllMemberName(this.hierarchyDef);
        this.olapHierarchy = this.createHierarchy(hasAllLevel, allLevelName);
        this.olapHierarchy.setCaption(this.hierarchyDef.getCaption());
        this.registerHierarchy(this.olapHierarchy);
        OlapLevel allLevel = this.olapHierarchy.getAllLevel();
        int allPos = allLevel == null ? 0 : 1;
        List<IOlapBuilderHierarchyLevelDef> levels = this.hierarchyDef.getLevels();
        for (int i = 0; i < levels.size(); ++i) {
            IOlapBuilderHierarchyLevelDef levelDef = levels.get(i);
            OlapLevel level = new OlapLevel(this.olapHierarchy, i + allPos, levelDef, this.isLevelStructureFixed() && i == levels.size() - 1);
            this.registerLevel(this.olapHierarchy, level);
        }
        if (allLevel != null) {
            OlapMember member = OlapMemberFactory.createOlapAllMember(this.context, allLevel, allName);
            this.context.addMember(allLevel, member);
        }
    }

    protected boolean isLevelStructureFixed() {
        return false;
    }

    protected OlapMultiLevelHierarchy createHierarchy(boolean hasAllLevel, String allLevelName) {
        return OlapMultiLevelHierarchyFactory.getInstance().create(this.olapDimension, (IOlapBuilderHierarchyDef)this.hierarchyDef, hasAllLevel, allLevelName);
    }

    @Nullable
    protected String getAllMemberName(T hierarchyDef) {
        return hierarchyDef.getAllMemberName();
    }

    @Nullable
    protected String getAllLevelName(T hierarchyDef) {
        return hierarchyDef.getAllLevelName();
    }

    protected boolean getHasAllLevel(T hierarchyDef) {
        return hierarchyDef.hasAll();
    }

    protected void registerHierarchy(OlapMultiLevelHierarchy hierarchy) {
        this.olapDimension.addHierarchy(hierarchy);
    }

    protected void registerMember(OlapLevel level, OlapMember member) {
        this.context.addMember(level, member);
    }

    protected void registerLevel(OlapMultiLevelHierarchy hierarchy, OlapLevel level) {
        this.addPropertiesDefToLevel((IOlapBuilderHierarchyDef)this.hierarchyDef, level);
        hierarchy.addLevel(level);
    }

    private void addPropertiesDefToLevel(IOlapBuilderHierarchyDef hierarchyDef, OlapLevel level) {
        String levelName = level.getName(this.nameContext);
        List<IOlapBuilderPropertyDef> properties = hierarchyDef.getPropertiesForBuilder(levelName);
        for (IOlapBuilderPropertyDef propertyDef : properties) {
            OlapBuilderInputType type = propertyDef.getPropertyType();
            boolean autoExportedToReportingMF = propertyDef.isAutoExportedToReportingMF();
            OlapUserDefinedMemberProperty levelProperty = new OlapUserDefinedMemberProperty(level, propertyDef.getName(), type, autoExportedToReportingMF, propertyDef.isAttribute());
            level.addMemberProperty(this.nameContext, levelProperty);
        }
    }

    @Nullable
    protected OlapMemberPropertiesValues addPropertiesValues(IOlapBuilderHierarchyDef hierarchyDef, OlapLevel level, IOlapBuilderTableRow data) {
        List<IOlapBuilderPropertyDef> properties = hierarchyDef.getPropertiesForBuilder(level.getName(this.nameContext));
        if (properties.isEmpty()) {
            return null;
        }
        OlapMemberPropertiesValues memberProperties = new OlapMemberPropertiesValues();
        for (IOlapBuilderPropertyDef propertyDef : properties) {
            if (propertyDef.isAttribute()) continue;
            String propertyName = propertyDef.getName();
            OlapUserDefinedMemberProperty property = level.lookupPropertyByName(propertyName);
            if (property == null) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.LEVEL_PROPERTY_NOT_FOUND, new Serializable[]{propertyName, level.getName(this.nameContext)});
            }
            Comparable javaValue = data.getJavaNativeDataValue(propertyDef.getPropertyColumn());
            memberProperties.put(property, javaValue);
        }
        return memberProperties;
    }

    @Nullable
    protected static String toMemberName(@Nullable Comparable object) {
        return object == null ? null : object.toString();
    }

    protected IOlapHierarchyPermission getFullControlPermissions(OlapHierarchy hierarchy) {
        OlapRoleSchemaPermissions permissions = this.context.getSchema().getFullControlPermissions();
        IOlapDimensionsPermission dimsPermissions = permissions.getDimensionsPermissions(null);
        IOlapDimensionPermission dimPermissions = dimsPermissions.getDimensionPermissions(hierarchy.getDimension());
        IOlapHierarchyPermission hierarchyPermissions = dimPermissions.getHierarchyPermission(hierarchy);
        return hierarchyPermissions;
    }

    protected static boolean hasArray(List<IOlapBuilderDataColumnDef> columnDefs) {
        for (IOlapBuilderDataColumnDef column : columnDefs) {
            if (column.getDecorationType() != OlapBuilderColumnDecorationType.ARRAY) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasArray(@Nullable IOlapBuilderDataColumnDef column) {
        return column != null && column.getDecorationType() == OlapBuilderColumnDecorationType.ARRAY;
    }

    protected void assertMemberProperties(IOlapBuilderTableRow data, OlapMember member) {
        if (!this.context.hasMemberPropertyConsistencyCheck()) {
            return;
        }
        OlapMemberPropertiesValues propertiesValues = this.addPropertiesValues((IOlapBuilderHierarchyDef)this.hierarchyDef, member.getLevel(), data);
        if (propertiesValues != null) {
            propertiesValues.assertMemberProperties(member);
        }
    }
}

