/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.facts.view;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderFactBuilderForView {
    private static final int MAX_SIZE = 1000;
    private final ReentrantLock LOCK = new ReentrantLock();
    private final OlapBuilderFactBuilder builder;
    @Nullable
    private Batch noPartitionBatch;
    private Map<IOlapBuilderTablePartitionKey, Batch> batches = new HashMap<IOlapBuilderTablePartitionKey, Batch>();

    public OlapBuilderFactBuilderForView(OlapBuilderFactBuilder builder) {
        this.builder = builder;
    }

    public void onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partitionKey, int rowNb, IOlapBuilderTableRow row) {
        Batch toProcess = partitionKey == null ? this.onNewRowWithoutPartition(context, originalTable, tabularData, columns, rowNb, row) : this.onNewRowWithPartition(context, originalTable, tabularData, columns, partitionKey, rowNb, row);
        this.fireBatch(context, toProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Batch onNewRowWithoutPartition(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, int rowNb, IOlapBuilderTableRow row) {
        this.LOCK.lock();
        try {
            if (this.noPartitionBatch == null) {
                this.noPartitionBatch = new Batch(null, originalTable, tabularData, columns, rowNb);
            }
            this.noPartitionBatch.rows.add(row);
            Batch toProcess = null;
            if (this.noPartitionBatch.rows.size() >= 1000) {
                toProcess = this.noPartitionBatch;
                this.noPartitionBatch = null;
            }
            Batch batch = toProcess;
            return batch;
        }
        finally {
            this.LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Batch onNewRowWithPartition(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, IOlapBuilderTablePartitionKey partitionKey, int rowNb, IOlapBuilderTableRow row) {
        this.LOCK.lock();
        try {
            Batch batch = this.batches.get(partitionKey);
            if (batch == null) {
                batch = new Batch(partitionKey, originalTable, tabularData, columns, rowNb);
                this.batches.put(partitionKey, batch);
            }
            batch.rows.add(row);
            Batch toProcess = null;
            if (batch.rows.size() >= 1000) {
                toProcess = batch;
                this.batches.remove(partitionKey);
            }
            Batch batch2 = toProcess;
            return batch2;
        }
        finally {
            this.LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTableProcessingCompleted(OlapBuilderContext context) {
        Collection<Batch> toProcesses;
        Batch toProcess;
        this.LOCK.lock();
        try {
            toProcess = this.noPartitionBatch;
        }
        finally {
            this.LOCK.unlock();
        }
        this.fireBatch(context, toProcess);
        this.LOCK.lock();
        try {
            toProcesses = this.batches.values();
        }
        finally {
            this.LOCK.unlock();
        }
        for (Batch toProcess2 : toProcesses) {
            this.fireBatch(context, toProcess2);
        }
    }

    private void fireBatch(OlapBuilderContext context, @Nullable Batch batch) {
        if (batch != null && !batch.rows.isEmpty()) {
            this.builder.onNewRows(context, batch.originalTable, batch.tabularData, batch.columns, batch.partitionKey, batch.rowNb, batch.rows);
        }
    }

    static class Batch {
        final IOlapBuilderTabularDataDef originalTable;
        final IOlapBuilderTabularDataDef tabularData;
        final List<IOlapBuilderDataColumnDef> columns;
        @Nullable
        final IOlapBuilderTablePartitionKey partitionKey;
        final int rowNb;
        final List<IOlapBuilderTableRow> rows = new ArrayList<IOlapBuilderTableRow>();

        public Batch(@Nullable IOlapBuilderTablePartitionKey partitionKey, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, int rowNb) {
            this.originalTable = originalTable;
            this.tabularData = tabularData;
            this.columns = columns;
            this.partitionKey = partitionKey;
            this.rowNb = rowNb;
        }
    }
}

